c-----------------------------------------------------------------------
c	Dany subroutine
c	part of Mitch Wyle's DTC program
c
c	NOTE TO DECUS MEMBERS:
c	This subroutine is meant to be a replacement to the original
c	DANY.FOR subroutine. This newer version uses a matematical
c	congruency formula for calculating the day of the week which 
c	a particular date falls on .
c
c	BUGS:
c	I don't think it works properly for years before 1400 A.D.
c
c
c						Kevin Carothers
c
c	Inputs: 
c		im	-	month (number 1-12)
c		iy	-	year  (either 1983 or 83)
c
c	Outputs:
c		ib	-	integer corresponding to day of week
c				on which the month begins (1-7)
c		il	-	length of the month in days
c-----------------------------------------------------------------------

	SUBROUTINE dany(ib,il,im,iy)
c
c	Declarations:
c
	integer im		!	Julian Month
	integer iy		!	Julian Year
	integer months(12)	!	array of months and the number 
c				!	of days in each one
c	Initialize:
c
	data months /31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31/
c
c		Leap year consideration:
c
	If ( (mod(iy,4).eq.0.and.mod(iy,100).ne.0)
	1	.or. mod(iy,400).eq.0) then
		months(2) = 29
	else
		months(2) = 28
	endif
c
c		compute date/day
c 
	il = months (im)
	iy1 = iy
	im1 = im
	If (iy1 .lt. 1900) iy1 = iy1 + 1900
	If (im1 .eq. 1) then
	   im1 = im1 + 12
	   iy1 = iy1 - 1
	endif
c this thing seems to be ok for most months but screws up for February
c for reasons which are mysterious.
	ib = 1 + 2*im1 + 3*(im1+1)/5 + iy1 + iy1/4 + iy1/400 - iy1/100 + 1 
	ib = mod (ib, 7) + 1
	return
	end
