.;
.; MCEBLD.CMD -- Commandfile to build the MCE commandline editor
.;
	.ENABLE SUBSTITUTION
	.DISABLE DISPLAY
.;
	.SETF  A$SV    ! Conditional for CRW/ASV  Erasmus university Rotterdam
	.IF P1 EQ "ASV" .SETT A$SV
.;
	.SETS VERION "04.0b"		! Version
	.SETS HLPUIC "[1,2]"		! Helpfile UIC
	.SETS SYSUIC <LIBUIC>		! Task uic
	.SETS INIUIC "[1,2]"		! Change mce.mac to change uic
	.IFT A$SV .SETS INIUIC "[2,2]"	! Change mce.mac to change uic
;
;************************
;* M C E B L D . C M D  *
;************************
;
;MCEBLD.CMD -- Commandfile to build the MCE commandline editor
;
.;Version: 'verion'
.;
.;
	.PARSE	<FILSPC> "]."  DUM PRNAME DUM
.;
.;Test if correct CLI
.;
	.if <cli> = "DCL" .sets cli "MCR"
	.if <cli> = "MCR" .sets cli ""
	.ifdf cli .goto c1
        .disable quiet
 ;
 ;'PRNAME' -- CLI '<cli>' not supported
 ;
	.EXIT <SEVERE>
.C1:
	.SETF HLP
	.SETF COP
	.SETF INS
	.SETF PRI
        .IF P1 = "MAC" .GOTO MAC
        .IF P1 = "LINK" .GOTO LINK
	.ASK INI 'PRNAME' -- Want the MCEINI file support [D:N] ? 
	.ASK CLS 'PRNAME' -- Want the multiple CLI support [ D:N ] ? 
	.ASK NAM 'PRNAME' -- Want the named directory support [ D:N ] ? 
	.ASK SIL 'PRNAME' -- Want Startup and exit messages [D:N] ? 
	.ASK VT2 'PRNAME' -- Want the VT2xx, VT3xx function key support [D:N] ? 
	.ASK TD2 'PRNAME' -- Want the TDV2230 function key support [D:N] ? 
	.SETF TMO
	.SETN TMON 4.
	.ASK TMO 'PRNAME' -- Want the terminal time-out support [D:N] ? 
	.IFT TMO .ASKN [2.:120.:4.] TMON 'PRNAME' -- Enter number of time-out minutes [2..120 D:4] : 
	.ASKN [1.:10.:1.] MINCHR 'PRNAME' -- Enter minimal commandline length to be saved [1..10 D:1] : 
	.ASKN [1.:99.:23.] MAXFIF 'PRNAME' -- Enter maximal number of entries in FIFO [1..99 D:23.] : 
	.IF P1 <> "ALL" .GOTO 1$
	.SETT HLP
	.SETT COP
	.SETF INS
	.SETF PRI
	.GOTO 2$
.1$:
        .ASK HLP 'PRNAME' -- Create helpfile on LB: [D:N] ? 
	.DISABLE LOWERCASE
        .IFT HLP .ASKS [::HLPUIC] HLPUIC 'PRNAME' -- What is your helpfile UIC [ D:'HLPUIC' ] : 
	.IF HLPUIC EQ "Y" .GOTO 1$
        .SETF INS
        .ASK COP 'PRNAME' -- When ready and successfull copy to LB: device [D:N] ? 
	.IFT COP .ASKS [::SYSUIC] SYSUIC 'PRNAME' -- What is your task UIC [ D:'SYSUIC' ] : 
	.IF HLPUIC EQ "Y" .GOTO 1$
	.ENABLE LOWERCASE
        .IFT COP .ASK INS 'PRNAME' -- Install task [D:N] ? 
        .ASK PRI 'PRNAME' -- Print listings [D:N] ? 
.2$:
        .IFF HLP .GOTO 65$
;'PRNAME' -- Creating help .....
        .OPEN LB:'HLPUIC'MCE.HLP
.DATA  MCE - Commandline Editor Utility Commands
.DATA  MCE V4.0 supports all Line Editing Functions of VMS V4.0 in MCR and DCL
.DATA
.DATA  <CTRL/A>               - Switch between overstrike and insert mode
.DATA                           Current mode is shown by first prompt character.
.DATA                                 "+" insert mode.    "-" overstrike mode.
.DATA  <CTRL/B> or UP-ARROW   - Retrieve previous command
.DATA            DOWN-ARROW   - Reverse of UP-ARROW (next command)
.DATA  <CTRL/D> or LEFT-ARROW - Move Cursur left
.DATA  <CTRL/E>               - Go to end of line
.DATA  <CTRL/F> or RIGHT-ARR  - Move Cursur right
.DATA  <CTRL/H> or BACKSPACE  - Move Cursur to beginning of line
.DATA  <CTRL/J> or LINEFEED   - Delete word to the left of the cursur
.DATA  <CTRL/U>               - Delete from beginning of line to cursor
.DATA  <CTRL/R>               - Rewrite line
.DATA  <CTRL/T>               - Detach TI:, Wait 10 seconds, Prompt again
.DATA                           To enable output from other tasks
.IFT VT2 .DATA  "command" <ESC><ESC>
.IFT VT2 .DATA   or  "command" <DO>    - Spawn command without waiting
.IFF A$SV .IFT VT2 .DATA  <HELP>                 - Gives HELP MCE
.IFT A$SV .IFT VT2 .DATA  <HELP>                 - Gives HELP ASV MCE
.IFF VT2 .DATA  "command" <ESC><ESC>   - Spawn command without waiting
.DATA  Additional Features:
.DATA  <PF1>                  - Translate command without execution
.DATA  <PF2>                  - Recall Command previously requested starting
.DATA                           with a string entered before pressing key
.DATA  <PF3>                  - Show Command Translation Buffer
.DATA  <PF4>                  - Display previously requested commands
.IF MINCHR > 1 .DATA Only commands which contain 'MINCHR%D' or more characters will be saved.
.DATA The savebuffer can contain up to 'MAXFIF%D' commandlines.
.IFT TMO  .DATA Terminal time-out time support included ('TMON%D' minutes)
.DATA  More help : TRANS  RECALL  START  EXIT  INTERNAL  FUNC
.IFF A$SV .DATA 2 TRANS
.IFT A$SV .DATA 3 TRANS
.DATA  As in DCL from VMS a command may be defined by:
.DATA         +>CNAM := <TRANSLATION OF COMMAND>
.DATA  where CNAM is the command name which will be substituted by the
.DATA  text at the right side of the ":=". 
.DATA  NOTE: The ":=" must be prececed and followed by a single space.
.IFF A$SV .DATA  e.g.:  +>HE := HELP MCE        ! Followed by space, to append further text
.IFT A$SV .DATA  e.g.:  +>HE := HELP ASV MCE    ! Followed by space, to append further text
.IFF A$SV .DATA         +>HE                    ! Will request "HELP MCE"
.IFT A$SV .DATA         +>HE                    ! Will request "HELP ASV MCE"
.DATA  
.DATA  The translation may be performed without execution by <PF1> (only
.DATA  displayed on terminal)
.DATA  
.DATA  If you enter a predefined command followed by additional text,
.DATA  this additional text will normally be appended as a whole.
.IFF A$SV .DATA  e.g.:  +>HE TRAN               ! Will request "HELP MCE TRAN"
.IFT A$SV .DATA  e.g.:  +>HE TRAN               ! Will request "HELP ASV MCE TRAN"
.DATA  or:    +>HE TRAN<PF1>          ! Will be translated and displayed
.IFF A$SV .DATA  result +>HELP MCE TRAN
.IFT A$SV .DATA  result +>HELP ASV MCE TRAN
.DATA  
.DATA  You may delete a command translation entry by redefining it to null.
.DATA  e.g.:  +>HE :=                 ! Delete above definition
.DATA  
.DATA  It is also possible to allow abbreviatons of commands (as in DCL)
.DATA  by seperating the optional part by "*"
.IFF A$SV .DATA  e.g.:  +>HM*CE := HELP MCE
.IFT A$SV .DATA  e.g.:  +>HM*CE := HELP ASV MCE
.DATA  This command may now be requested with:
.DATA         +>HM or HMC or HMCE or HMCEXXX ect.
.DATA
.DATA  More sophisticated substitution is possible by the Parameter-Substitution,
.DATA  similar to the indirect commandfile processor.
.DATA  e.g.:  +>DIR*ECTORY := PIP ''P1''/LI
.DATA         +>COP*Y := PIP ''P2''/NV/CD=''P1''
.DATA         +>DIR                   ! Will be translated into "PIP /LI"
.DATA         +>DIREC FIL             ! Will be translated into "PIP FIL/LI"
.DATA         +>COPY A.CMD [200,200]  ! Will simulate DCL COPY command
.IFT INI .DATA  Note that Command Definitions may be performed from the commandfile
.IFT INI .IFF CLS .DATA         LB:'INIUIC'MCEINI.CMD  and  SY:MCEINI.CMD
.IFT INI .IFT CLS .DATA         LB:'INIUIC'MCEINI.xxx  and  SY:MCEINI.xxx
.IFT INI .DATA  which will always be read when MCE is started.
.IFT INI .IFT CLS .DATA         "xxx" = CLI name
.IFT INI .DATA  Files are read in order they are mentioned above.
.DATA  
.IFF A$SV .DATA 2 FUNC
.IFT A$SV .DATA 3 FUNC
.DATA  You may request a command with function keys <PF1>, <PF2>, <PF3> or <PF4>
.IFT VT2 .DATA  On a VT2xx you can also define the function keys <F6> .. <F20> and <FIND>
.IFT VT2 .DATA  <INSERT HERE> ect.
.IFT TD2 .DATA	On a TDV2230 you can also define the function keys <F1> ... <F7>
.DATA  Define the command translation as "''key'' := command".
.DATA  e.g.   +>PF2 := TIM            ! Redefine <PF2> function key
.DATA         <PF2>                   !  to display the current time
.IFT VT2 .OR .IFT TD2 .DATA         +>F6 := ACT             ! Define F6 function key
.IFT VT2 .OR .IFT TD2 .DATA         <F6>                    !  to display the active tasks
.IFT VT2 .DATA  On a VT2XX the keys <FIND> ect. must be entered as F$a  where "a" is the
.IFT VT2 .DATA  first char. of the key function.  e.g.  "F$P" for <PREV SCREEN> 
.IFF A$SV .DATA 2 START
.IFT A$SV .DATA 3 START
.DATA  Invoke MCE with command "MCE" (at best in your LOGIN file by ".XQT MCE").
.DATA  A File of Command Definitions will be executed at MCE start time,
.DATA  the file may be specified in the form "MCE startup_file".
.DATA  If no startup file is specified in the commandline (the normal case),
.DATA  files are searched for are in this order:
.IFT CLS .DATA     LB:'INIUIC'MCEINI.xxx,        followed by
.IFT CLS .DATA     SY:<current directory>MCEINI.xxx,
.IFT CLS .DATA  Where "xxx" is the name of the CLI defined for the terminal invoking MCE.
.IFF CLS .DATA     LB:'INIUIC'MCEINI.CMD,        followed by
.IFF CLS .DATA     SY:<current directory>MCEINI.CMD,
.DATA  This algorithm divides command-definitions into 2 groups:
.DATA  A system-wide set in LB:'INIUIC', followed by a users privat set in SY:<uic>.
.DATA  Overriding the default file name in the commandline invoking MCE offers
.DATA  the possibility to tailor an application specific command set.
.IFF A$SV .DATA 2 EXIT
.IFT A$SV .DATA 3 EXIT
.DATA   To exit MCE operations, use the "MCE EXIT" internal command.
.DATA   or <CTRL/Y>
.DATA   More about internal commands see help MCE INTERNAL.
.IFF A$SV .DATA 2 INTERNAL
.IFT A$SV .DATA 3 INTERNAL
.DATA   Two command verbs are specially handled by MCE: BYE and MCE.
.DATA   "BYE..." is sent to the CLI and MCE exits immediately.
.DATA   (Note,that you may define any other string (e.g. LOGOFF) to result
.DATA   in BYE.)
.DATA   Commands starting with "MCE" are treated as internal commands and
.DATA   not passed to the CLI. Following the verb "MCE " a 4 character action
.DATA   specifier defines the action wanted.
.DATA   Actions defined so far are:
.DATA   EXIT : MCE task exit (return to the normal command environment.)
.DATA   PURG : delete all commands in translation table
.DATA   READ file: read new command translations from file specified
.DATA   REPL file: combines PURGe and READ.
.DATA   The read and replace options, if no file is specified, follow the
.DATA   the same file name convention as at startup: the file(s) according
.DATA   to the current CLI is read in, i.e. the command "MCE REPLace"
.DATA   effects in an MCE restart (but the FIFO buffer is kept), usefull
.DATA   after a SET TERMINAL new_cli command.
.IFF A$SV .DATA 2 RECALL
.IFT A$SV .DATA 3 RECALL
.DATA  Recalling a command is done by entering the first part of a command
.DATA  which was previously executed, termimated by the function key "PF2".
.DATA  This will find the last commands already executed starting with the
.DATA  string entered.  The command may be edited or executed by pressing
.DATA  the return key.
.DATA  Note that the function key "PF2" may not have any superimposed
.DATA  translation defined (by defining "PF2 := ...").
.DATA  Example:
.DATA     +>DIR X.DAT        ! Previously entered commands
.DATA     +>DMP X.DAT
.DATA     +>..
.DATA     +>D<PF2>           ! will recall the first command
.DATA     +>DMP X.DAT        !  starting with "D"
.DATA     +>DI<PF2>          ! will recall the command:
.DATA     +>DIR X.DAT
        .close
        'cli' PIP LB:'HLPUIC'MCE.HLP/PU/NM
.65$:
;'PRNAME' -- Creating build files .....
        .open MCEASM.CMD
	.data ;
	.data ; MCE Macro buildfile
	.data ; Created on '<date>' '<time>' by 'PRNAME'.CMD Version: 'verion'
	.data ;
	.data MCE,MCE/-SP=MCEPRE,MCE
	.CLOSE
	.OPEN MCEPRE.MAC
	.data 	.SBTTL MCE - Configuration prefixfile MCEPRE.MAC
	.data ;
	.data ; MCE Macro Prefixfile
	.data ; Created on '<date>' '<time>' by 'PRNAME'.CMD Version: 'verion'
	.IFT VT2 .DATA VT2XX = 1	; VT2xx support included
	.IFT TD2 .DATA TDV2XX = 1	; TDV2230 support included
	.IFT INI .DATA FILE = 1	; MCEINI file support included
	.IFT CLS .DATA CLISUP = 1	; Multiple cli supp
	.IFT NAM .DATA NAMDIR = 1	; Named directory support
	.IFF SIL .DATA SILENT = 1	; No Startup and exit messages
	.IFT TMO .DATA TMOTIM = 60.	; Time-out support
	.IFT TMO .DATA TMO0 = 'TMON'.	; Time-out count
	.IFT A$SV .DATA A$SV = 1	; EUR - CRW/ASV support
	.DATA MINCHR = 'MINCHR'.	; Minimal cmd-line length to be saved
	.DATA MAXFIF = 'MAXFIF'.	; Maximal number of entries in FIFO
	.CLOSE
.;
        .OPEN MCETKB.CMD
	.IF <SYSTEM> EQ 1 .GOTO 70$
	.SETS LIBR "SUPLIB=FCSFSL:SV"	; Assume FCSFSL
	.TESTFILE LB:[1,1]FCSFSL.TSK
	.IF <FILERR> EQ 1 .GOTO LINK2
.70$:
	.SETS LIBR "LIBR=FCSRES:RO"	; Assume FCSRES
	.TESTFILE LB:[1,1]FCSRES.TSK
	.IF <FILERR> EQ 1 .GOTO LINK2
	.SETS LIBR ";"
.LINK2:
.ENABLE DATA
;
; MCE Link buildfile
; Created on '<date>' '<time>' by 'PRNAME'.CMD Version: 'verion'
; 
MCE/CP,MCE/-SP=MCE
LB:[1,1]VMLIB/LB:INIDM:EXTSK
/
UNITS=2
ASG=TI:1
ASG=SY:2
PRI=150
TASK=...MCE
'LIBR'
EXTTSK=400
/
.DISABLE DATA
        .CLOSE

    'cli' PIP MCEASM.CMD/PU/NM,MCEASM.CMD
.MAC:
;'PRNAME' -- Assembling .....
	.;
    'cli' MAC @MCEASM
        .IF <EXSTAT> NE <succes> .GOTO 200$
	.;
    'cli' PIP MCE.OBJ/PU/NM,MCE.LST
    'cli' PIP MCEPRE.MAC/PU/NM
.LINK:
;'PRNAME' -- Building MCE .....
    'cli' PIP MCETKB.CMD/PU/NM
    'cli' TKB @MCETKB
        .IF <EXSTAT> NE 1 .GOTO 200$
.;
    'cli' PIP MCE.TSK/PU/NM,MCE.MAP
.;
        .IFF COP .GOTO 100$
    'cli' PIP LB:'SYSUIC'/NV/FO/CO=MCE.TSK
        .IFF INS .GOTO 100$
        .IFINS ...MCE           'cli' REM ...MCE
    'cli' INS LB:'SYSUIC'MCE
.;
.100$:
        .IFT PRI 'cli' PRI MCE/FLA=MCE.LST,MCE.MAP
;'PRNAME' -- Procedure done
        .EXIT   <SUCCES>
.200$:
;
;'PRNAME' -- Something wrong !!!
;
        .EXIT   <WARNIN>
