.ENABLE SUBSTITUTION
.SETS UIC <UIC>
;
; This command file assembles and links the sample ACP software.
; Included are a null driver and its ACP, an enable task, and a
; disable task.
;
; The command file assumes the system device (SY:) is the disk the
; ACP software is on and the library device (LB:) is the disk with the
; system software. It also assumes the current UIC is the UIC with the
; ACP software and will create the ACP output in this UIC. We will now
; check all files are in the correct place. Any files not in the correct
; place will generate a message and the command file will pause to allow
; you to correctly position them.
.100: ;
;
.SETT FOUND
.TESTFILE SY:'UIC'DRVBLD.CMD
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'ACPBLD.CMD
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'ENABLD.CMD
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'DISBLD.CMD
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'COMACP.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'NULDRV.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'NULACP.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'ENABLE.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE SY:'UIC'DISABL.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[1,1]EXEMC.MLB
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[1,1]EXELIB.OLB
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[1,54]RSXMC.MAC
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.TESTFILE LB:[1,54]RSX11M.STB
.IF <FILERR> NE 1 ; '<FILSPC>' NOT FOUND
.IF <FILERR> NE 1 .SETF FOUND
.IFT FOUND .GOTO 200
;
; We will now pause. Please correct any problems
;
.PAUSE
.GOTO 100
.200: ;
; Assemble ACP sources
;
.IFNINS ...MAC INS $MAC
MAC NULDRV,NULDRV/-SP=LB:[1,1]EXEMC/ML,[1,54]RSXMC,SY:'UIC'COMACP,NULDRV
MAC NULACP,NULACP/-SP=LB:[1,1]EXEMC/ML,[1,54]RSXMC,SY:'UIC'COMACP,NULACP
MAC ENABLE,ENABLE/-SP=LB:[1,1]EXEMC/ML,[1,54]RSXMC,SY:'UIC'ENABLE
MAC DISABL,DISABL/-SP=LB:[1,1]EXEMC/ML,[1,54]RSXMC,SY:'UIC'DISABL
;
; Task build null driver.
;
.IFNINS ...TKB INS $TKB
TKB @DRVBLD.CMD
;
; Task build null ACP.
;
TKB @ACPBLD.CMD
;
; Task build enable/disable task.
;
TKB @ENABLD.CMD
TKB @DISBLD.CMD
;
; All done.
;
