      PROGRAM TEST
      INCLUDE 'GKENUM.FIN'
C
C     Plot golf ball
C
      REAL        X(21),Y(21)
      REAL        XX(2)
      REAL        YY(2)
      INTEGER     TTOUT
      PARAMETER  (TTOUT=10)
      INTEGER     WKID
      CHARACTER*1 INLINE
C
C     Format statements.
C
5     FORMAT (1H+, 'PAUSE -- Hit return to continue.', $)
10    FORMAT (1A1)
C
C     Executable code begins here.
C
      OPEN (TTOUT, STATUS='NEW')	! Open a FORTRAN Logical Unit (LUN)
					!   to be used for output. This must
					!   be done for F77 prior to the 
					!   GOPWK call because of a bug in
					!   ILUN.
      WKID = 1
      CALL GOPKS  (5, -1)		! Open GKS.
      CALL GOPWK  (WKID, TTOUT, 1)	! Open a workstation on FORTRAN LUN 
					!   TTOUT.
      CALL GQDSP  (WKID, ERRIND, DCUNIT, RX, RY, LX, LY)
      CALL GACWK  (WKID)		! Activate the workstation.
C
C     Setup the Normalization Tranformation.
C
      NT = 1
      CALL GSWN   (NT, 0.0, 8.0, 0.0, 8.0)	! Set the world coordinate
						!   window.
      CALL GSVP   (NT, 0.0, 1.0, 0.0, 1.0)	! Set the NDC viewport.
      CALL GSELNT (NT)				! Select normalization 
						!   transform number 1.
C
C     Setup the WorkStation Transformation.
C
      CALL GSWKWN (WKID, 0.0, 1.0, 0.0, 1.0)	! Set the workstation window
						!   in NDC space.
      CALL GSWKVP (WKID, (RX-RY)/2., (RX+RY)/2., 0.0, RY) ! Setup the viewport
						!   in DC space.
      CALL GSCLIP(1)				! Turn on the normalization
						!   clip.
C
C     Make it happen. Clear the WorkStation.
C
      CALL GCLRWK (WKID, 1)		! Clear the workstation. The new NT
					!   actually gets set now!
      CALL GSPLCI (2)			! Select RED as the line color.
C
C     Compute the points on the edge of the golf ball.
C
      DO 20 I0=1,21
         TH=I0*0.299199
         X(I0)=3.5*COS(TH)+4.0
         Y(I0)=3.5*SIN(TH)+4.0
20    CONTINUE
C
C     Connect each point with every other point.
C
      DO 35 I0=1,20
         I1=1+I0
         DO 30 I2=I1,21
            XX(1) = X(I0)
            XX(2) = X(I2)
            YY(1) = Y(I0)
            YY(2) = Y(I2)
            CALL GPL (2, XX, YY)	! Draw a line.
30       CONTINUE
35    CONTINUE
C
C     The next three lines of code illustrate a sort of kludgy solution to
C     the problem of how to suspend the picture. The ultimate solution will
C     be to include an escape function to PAUSE, or to implement the LOCATOR
C     function.
C
      CALL GUWK   (WKID, GPERFO)	! Update the workstation to be sure
					!   that all the buffers are flushed.
      TYPE 5				! Present the prompt to the user.
      READ (5, 10) INLINE		! Wait for his response.
C
      CALL GDAWK  (WKID)		! Deactivate the workstation.
      CALL GCLWK  (WKID)		! Close the workstation.
      CALL GCLKS			! Close GKS.
      STOP
      END
