.;+
.;	Title:	TEM.CMD
.;	Author:	T. R. Wyant
.;	Date:	15-Mar-1985
.;	Modified:
.;	Remarks:
.;		This command file connects you to various systems
.;		via TEM. The systems are identified by node name, or
.;		a reasonable proxy.
.;-
	.ENABLE SUBSTITUTION
	.ENABLE ESCAPE
	.SETN N$NUM 15
	.SETS S$CR "'N$NUM%V'"
	.SETS S$ATCH "^\"	! The desired attention character.
	.SETS S$TERM "TT7:"	! The terminal TEM is to execute on.

.;
.;		What follows is the node table. All that is necessary
.;		to add support for another node is to define its name
.;		as a string symbol, whose text is a system identifi-
.;		cation string, the system-specific TEM commands, and
.;		the modem commands needed to dial the system, all se-
.;		parated by the "|" character.

.;		The samples below all start by dialing a Hayes Smart-
.;		modem. Some then go on to do fancier things. Except for
.;		"DSIN", phone numbers, etc. have been changed to protect
.;		the innocent.
.;
.;		DIRECT - Direct dials the desired system. This is the
.;			"no frills" example on which all others are
.;			based.
.;		DSIN - Opens a log file, and calls up the Digital Soft-
.;			ware Information Network. Note that this does
.;			you no good unless you have an account. See your
.;			friendly neighborhood DEC rep for further
.;			details.
.;		IS4000 - Rotaries through a couple of numbers to connect
.;			to an Infotron 4000 terminal switch. If you get
.;			a hit on the first number, the <CR>'s wake up
.;			the switch and satisfy its rather delicate auto-
.;			baud algorithm, after which the switch errors on
.;			the second phone number, issues a stream of
.;			destination prompts, and you're home free. If
.;			the first number is busy, the Smartmodem gets
.;			the carriage returns (which it ignores), and
.;			then dials the second number.
.;		OTHER - A dummy.
.;		SYTEK - Rotaries through a couple of numbers, to try to
.;			get on a SYTEK LocalNet 20 net. If the first
.;			call succeeds, the T-box issues an error on the
.;			Smartmodem command, but no harm is done.
.;
	.SETS SYTEK "Via LocalNet 20||ATD1234567|ATD1234568|CALL FFFF"
	.SETS OTHER "Some system not covered by this command procedure||"
	.SETS IS4000 "Infotron switch||ATD1234567|"+S$CR+S$CR+"ATD1234568|"+S$CR+S$CR
	.SETS DSIN "DEC Software Info Net|/LOG:SPR.LOG|ATD9,1,303,5901600"
	.SETS DIRECT "Direct dial a system||ATD4061"

.;
.;		Validation stuff for the TEM options, in an attempt to
.;		prevent the passing of bad commands to TEM. THIS IS NOT
.;		BULLET PROOF, but should catch most innocent errors.
.;		Also it allows a simple help on TEM, which TEM itself
.;		does not support.
.;
	.SETS S$T$ "//Null switch"
	.SETS S$T$TR "TRANSLATE/NOTRANSLATE/Translate the given input character to another"
	.SETS S$T$TE "TERMINAL/NOTERMINAL/The remote device is a terminal, not a computer"
	.SETS S$T$ST "STOP/NOSTOP/Suspend TEM and go into '<CLI>'"
	.SETS S$T$SP "SPEED:speed/current setting/Set the baud rate on 'S$TERM'"
	.SETS S$T$SE "SEND:file/NOSEND/Send the named file to the remote system"
	.SETS S$T$RP "RPA/RPA/Simulate >SET /RPA=TI:"
	.SETS S$T$RE "REMOTE/current setting/Simulate >SET /[NO]REMOTE='S$TERM'"
	.SETS S$T$QU "QUIET/NOQUIET/Supress terminal output during file send"
	.SETS S$T$PR "PROMPT/PROMPT:LF/Set the character that prompts for the next record"
	.SETS S$T$PA "PARITY/PARITY:SPACE/Set parity to SPACE, MARK, ODD, or EVEN"
	.SETS S$T$NU "NULLS/NONULLS/Pass received nulls to log file"
	.SETS S$T$MO "MONITOR/NOMONITOR/Translate control characters to printable"
	.SETS S$T$MA "MAXBUFFER/NOMAXBUFFER/Set maximum logfile record"
	.SETS S$T$LO "LOG/NOLOG/Turn on logging to specified file"
	.SETS S$T$LI "LIST/LIST/Give the log file list carriage control"
	.SETS S$T$HO "HOLD/NOHOLD/Don''t hang up the line on exit"
	.SETS S$T$EX "EXIT/NOEXIT/Exit if no more commands in command file"
	.SETS S$T$EO "EOF/EOF:^Z/Send an EOF character after the last file record"
	.SETS S$T$EC "ECHO/NOECHO/Local echo"
	.SETS S$T$DE "DELAY/DELAY:15T/Set the delay after sending each file record"
	.SETS S$T$CO "COMMAND/NOCOMMAND/Prompt for another command immediately"
	.SETS S$T$CH "CHECKPARITY/NOCHECKPARITY/Turn on parity checking"
	.SETS S$T$AT "ATTENTION/ATTENTION:'S$ATCH'/Specify the TEM attention character"
	.SETS S$T$AS "ASSIGN/NOASSIGN/Assign a character code to a key"

	.SETS S$MCR ""
	.IF <CLI> <> "MCR"	.SETS S$MCR "MCR "
	.SETN N$ZERO 0

	.SETF L$SYS
	.SETF L$OPTS
	.TEST P1 "/"
	.SETN N$SLSH <STRLEN>
	.TEST P1
	.IF N$SLSH = 0	.SETN N$SLSH <STRLEN>+1
	.SETS S$SYS P1[1:N$SLSH-1]
	.SETS S$OPTS P1[N$SLSH:*]
	.IFDISABLED MCR	; S$SYS = "'S$SYS'", S$OPTS = "'S$OPTS'"
	.IF S$SYS <> ""	.SETT L$SYS
	.IF S$OPTS <> ""	.SETT L$OPTS
	.IFT L$SYS .SETT L$OPTS
	.IFT L$SYS .IFT L$OPTS	.GOTO LINE
;
;		'<NETNOD>'::'<FILSPC>'
;
;	Connect TEM to various and sundry systems.
;	For help, type <ESC>.
;

.LINE:	.TESTDEVICE 'S$TERM'
	.SETS S$ERR "'S$TERM' has been allocated to another terminal"
	.TEST <EXSTRI> ",ALO"
	.IF <STRLEN> > 0	.GOTO ERROUT
	.SETS S$ERR "'S$TERM' has been attached by another task"
	.TEST <EXSTRI> ",NAT"
	.IF <STRLEN> = 0	.GOTO ERROUT
	.SETS S$ERR "'S$TERM' is logged on"
	.PARSE <EXSTRI> "," S$DEV S$UCW1 S$UCW2 S$UCW3 S$UCW4 S$FLGS
	.IF N$ZERO = 'S$UCW2'&400	.GOTO ERROUT
	.IFT L$SYS	.GOTO ASKCHK

.ASK:
	.DISABLE LOWERCASE
	.ASKS [0:6] S$SYS What system shall I connect to
	.ENABLE LOWERCASE
	.IFT <ESCAPE>	.GOTO ASKHLP
	.IF S$SYS = ""	.EXIT
.ASKCHK:.TEST S$SYS
	.IFF <ALPHAN>	.GOTO ASKERR
	.TEST ",COMMAN,P0,P1,P2,P3,P4,P5,P6,P7,P8,P9," ",'S$SYS',"
	.IF <STRLEN> > 0	.GOTO ASKERR
	.IFDF 'S$SYS'	.GOTO ASKOK

.ASKERR:.DISABLE DISPLAY
	;
	;Error - System name "'S$SYS'" is illegal or unsupported.
.ASKHLP:.DISABLE DISPLAY
	;
	;Legal system names are:
	;
	.SETS <NXTSYM> ""
.ASKLP:
	.SETS S$SYM <NXTSYM>
	.IF S$SYM = ""	.GOTO ASKLPE
	.IFNDF 'S$SYM'	.GOTO ASKLP
	.TEST ",COMMAN,P0,P1,P2,P3,P4,P5,P6,P7,P8,P9," ",'S$SYM',"
	.IF <STRLEN> > 0	.GOTO ASKLP
	.TEST S$SYM
	.IFF <ALPHAN>	.GOTO ASKLP
	.PARSE 'S$SYM' "|" S$ID S$DFOP S$CMDS
	;    'S$SYM%R6':: - 'S$ID'
	.GOTO ASKLP

.ASKLPE:;
	.ENABLE DISPLAY
	.IFF L$SYS	.GOTO ASK
	.EXIT

.ASKOK:	.;

	.PARSE 'S$SYS' "|" S$ID S$DFOP S$CMDS
	.SETS S$DFOP "/ATTENTION:'S$ATCH'"+S$DFOP
	.IFF L$OPTS	.GOTO OPTASK
	.IF S$OPTS = ""	.SETS S$OPTS S$DFOP
	.GOTO OPTOK
.OPTASK:
	.DISABLE LOWERCASE
	.ASKS [::S$DFOP] S$OPTS What TEM options do you want
	.ENABLE LOWERCASE
	.IFT <ESCAPE>	.GOTO OPTHLP
	.SETS S$JUNK S$OPTS[1:1]
	.IF S$JUNK <> "/" .IF S$OPTS <> ""	.SETS S$OPTS "/"+S$OPTS
	.SETS S$OPTL ""
	.SETS S$OPTX S$OPTS
	.SETS S$DASH "-"
.OPTLP:
	.PARSE S$OPTS "/" S$OPT S$OPTS
	.SETS S$OPNG "NO"
	.IF S$OPNG = S$OPT[1:2]	.GOTO OPTNG
	.SETS S$OPNG "-"
	.IF S$OPNG = S$OPT[1:1]	.GOTO OPTNG
	.SETS S$OPNG ""
.OPTNG:	.TEST S$OPNG
	.SETS S$OPTA S$OPT[<STRLEN>+1:<STRLEN>+2]
	.IF <STRLEN> > 0	.SETS S$OPNG "-"
	.IFNDF S$T$'S$OPTA'	.GOTO OPTERR
	.PARSE S$T$'S$OPTA' "/" S$OPTA S$JUNK
	.PARSE S$OPT ":" S$OPTN S$OPTP
	.TEST "/'S$OPTA'/" "/'S$OPTN'"
	.IF <STRLEN> <> 1	.GOTO OPTERR
	.SETS S$OPTL S$OPTL+"/"+S$OPNG+S$OPTA[1:2]
	.IF S$OPTP <> ""	.SETS S$OPTL S$OPTL+":"+S$OPTP
	.IF S$OPTS <> ""	.GOTO OPTLP
	.SETS S$OPTS S$OPTX
	.GOTO OPTOK

.OPTERR:.DISABLE DISPLAY
	;
	;Error - Option "/'S$OPT'" is illegal.
.OPTHLP:.DISABLE DISPLAY
	;
	;Legal options are:
	;
	;Option Name    Option default   Option Description
	;-------------- ---------------- ------------------------------------
	.SETS <NXTSYM> ""
	.SETS S$SHDR "S$T$"
.OPTHL:
	.SETS S$SYM <NXTSYM>
	.IFDISABLED MCR	; S$SYM = 'S$SYM'
	.IF S$SYM = ""	.GOTO OPTHLE
	.IFNDF 'S$SYM'	.GOTO OPTHL
	.IF S$SHDR <> S$SYM[1:4]	.GOTO OPTHL
	;/'S$ID%L13' /'S$DF%L15' 'S$TX'
	.GOTO OPTHL

.OPTHLE:;
	.ENABLE DISPLAY
	.IFF L$OPTS	.GOTO OPTASK
	.EXIT <ERROR>

.OPTOK:	.IF S$OPTS = "/"	.SETS S$OPTS ""
	.DISABLE DISPLAY
	;
	;Connecting to 'S$SYS':: - 'S$ID'
	.IF S$OPTS <> ""	;        with TEM options "'S$OPTS'".
	.IF S$OPTS = ""		;        taking all TEM defaults.
	.SETS S$AT "^C"
	.TEST S$OPTS "/AT"
	.IF <STRLEN> = 0	.GOTO OPTATT
	.SETS S$JUNK S$OPTS[<STRLEN>+1:*]
	.PARSE S$JUNK ":/" S$JUNK S$AT S$JUNK
	.SETS S$JUNK S$AT[1:1]
	.IF S$JUNK = "^"	.GOTO OPTATT
	.IF S$JUNK <> "%" .IF S$JUNK <> "''"	.GOTO OPTATT
	.SETS S$AT S$AT[2:*]
	.IF S$JUNK = "''"	.GOTO OPTATT
	.SETN N$AT ('S$AT%V'+40)&177
	.SETS S$AT "'N$AT%V'"
.OPTATT:;Type "'S$AT'" to get the TEM prompt.
	;
	.ENABLE DISPLAY

	.SETS S$OPT2 ""
	.SETF L$FILE
	.IF S$CMDS = ""	.GOTO TEMRUN

	.GOSUB XFER CO/NOCO
	.GOSUB XFER SE
	.GOSUB XFER EO/EO

	.SETT L$FILE
	.OPEN TEMNET1.TMP
	.DATA 'S$TERM''S$OPTS'/CO
	.DATA /SE:TEMNET2.TMP/NOEOF
	.DATA 'S$OPT2'
	.CLOSE

	.OPEN TEMNET2.TMP
.CMDLP:
	.PARSE S$CMDS "|" S$CMD S$CMDS
	.DATA 'S$CMD'
	.IF S$CMDS <> ""	.GOTO CMDLP
	.CLOSE

.TEMRUN:'S$MCR'SET /NOBRO=TI:
	.IFT L$FILE	'S$MCR'TEM @TEMNET1.TMP
	.IFF L$FILE	'S$MCR'TEM 'S$TERM''S$OPTS'
	'S$MCR'SET /BRO=TI:
	.IFT L$FILE	'S$MCR'PIP TEMNET%.TMP;*/DE
	.EXIT <SUCCES>
.ERROUT:.DISABLE DISPLAY
	;
	;Error - 'S$ERR'.
	;        TEM is not available to you at this time.
	;
	.ENABLE DISPLAY
	.EXIT <ERROR>

.XFER:
	.SETS COMMAN "'COMMAN%C'"
	.SETS COMMAN "'COMMAN%C'"
	.SETF L$XFER
	.BEGIN
	.PARSE COMMAN " " SX$SN SX$JK
	.PARSE SX$SN "/" SX$SN SX$O2
	.TEST S$OPTS "/'SX$SN'"
	.IF <STRLEN> > 0	.GOTO XFER20
	.TEST S$OPTS "/-'SX$SN'"
	.IF <STRLEN> > 0	.GOTO XFER20
	.TEST S$OPTS "/NO'SX$SN'"
	.IF <STRLEN> = 0	.GOTO XFER90
.XFER20:.;
	.SETT L$XFER
	.SETS SX$O2 S$OPTS[<STRLEN>+1:*]
	.SETS S$OPTS S$OPTS[1:<STRLEN>]
	.PARSE SX$O2 "/" SX$O2 SX$JK
	.SETS S$OPTS S$OPTS+SX$JK
.XFER90:.SETS S$OPT2 S$OPT2+"/"+SX$O2
	.END
	.RETURN
