	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL
.;
.; MOVEBLD.CMD -
.;
.; This command procedure rebuilds MOVE.TSK.  It is then installed as
.; 'tsk'.  This symbol should be .SETS tsk "...nnn", where nnn is the 
.; three character mnemonic for the task.  We use DEF because we already
.; have such a procedure on our VAXcluster.
.;
.; The symbol 'for' should be redefined for your local MCR command to
.; compile.  Due to age-old command procedures, we use F4P mostly.
.;
.; The symbol 'libr' is the LIBR or SUPLIB line.  We use F4PRES.
.;
.; The following things could happen:
.;
.; 1)  The library file MOVE.OLB does not exist.  The command file checks
.;     for each object module, rebuilding those it does not find, creates
.;     the object library and task builds.
.;
.; 2)  The library exists, so it uses the 'd' symbols to select or deselect
.;     modules to recompile.  It inserts these into the library and then
.;     task builds.
.;
.; The compiler name we use for F77 is F4P.
.;
	.SETS tsk "...DEF"			! Task name.
	.SETS for "F4P"				! Compiler command name.
.;	.SETS for "F77"				! F77 compiler.
	.SETS swt "/NOTR/RO"			! Compiler switches.
	.SETS libr "LIBR=F4PRES:RO"		! Resident library in use.
.;	.SETS libr ""				! No resident library.
.;		
	.IFNDF $cmpil .GOTO Next		! Check for library.
		.IFT $cmpil .GOTO Compl		! Compile and make library.
.Next:
	.TESTFILE MOVE.OLB			! Test for library.
	.IF <filerr> = 1 .GOTO GotLib		! Its there, don't rebuild.
.Compl:
	    .SETS fil1 "MOVE.FTN"		! Start file list.
	    .SETS fil2 "GETLOG.FTN"
	    .SETS fil3 "GETDEF.FTN"
	    .SETS fil4 "PARSE.FTN"
	    .SETS fil5 "INSZIP.FTN"
	    .SETS fil6 "SKPSPC.FTN"
	    .SETS fil7 "DEVUIC.FTN"
	    .SETS fil8 "CHKDEV.FTN"
	    .SETS fil9 "CHKUIC.FTN"
	    .SETS fil10 "SETTRM.FTN"
	    .SETS fil11 "MCRCMD.FTN"
	    .SETS fil12 "ASNRST.FTN"
	    .SETS fil13 "CHKMOU.FTN"
	    .SETS fil14 "DEFCMD.FTN"
	    .SETS fil15 "LSTDIR.FTN"
	    .SETS fil16 "ASTERX.FTN"
	    .SETS fil17 "DIRUIC.FTN"
	    .SETS fil18 ""			! Flag to end file list.
.;
.; The code until GOTLIB is only executed if no library exists.  It checks
.; for each object module and compiles it if necessary.
.;
	    .SETN i 1
.Loop:
		.SETD i
		.SETS variab fil'i'
		.IF variab = "" .GOTO NoMore
		    .PARSE variab "." name ext
		    .SETS tstfil name+".OBJ"
		    .TESTFILE 'tstfil'
		    .IF <filerr> = 1 .GOTO NoComp
			'for' 'name'='variab''swt'
			.IF <exstat> <> 1 .GOTO Err
.NoComp:
		    .INC i
		    .GOTO Loop
.NoMore:
	    LBR MOVE.OLB/CR=MOVE,PARSE,GETLOG,INSZIP,GETDEF,ASNRST
	    LBR MOVE.OLB/IN=SKPSPC,DEVUIC,CHKDEV,CHKUIC,SETTRM,MCRCMD
	    LBR MOVE.OLB/IN=CHKMOU,DEFCMD,LSTDIR,ASTERX,DIRUIC
	    .GOTO MakBld
.GotLib:
.;
.; To get here, the library has to already exist.
.;
	.SETS dparse ".;"
	.SETS dgetlg ".;"
	.SETS dgetdf ".;"
	.SETS dinszp ".;"
	.SETS dmove ".;"
	.SETS dskpsp ".;"
	.SETS ddvuic ".;"
	.SETS dchkdv ".;"
	.SETS dchkuc ".;"
	.SETS dsettr ".;"
	.SETS dmcrcm ".;"
	.SETS dasnrs ".;"
	.SETS dchkmo ".;"
	.SETS ddefcd ".;"
	.SETS dlstdr ".;"
	.SETS ddruic ".;"
	.SETS dastrx ".;"
.;
.;	.SETS dparse ""			! Recompile subroutine PARSE.
.;	.SETS dgetlg ""			! Recompile subroutine GETLOG.
.;	.SETS dgetdf ""			! Recompile subroutine GETDEF.
.;	.SETS dinszp ""			! Recompile subroutine INSZIP.
.;	.SETS dskpsp ""			! Recompile subroutine SKPSPC.
.;	.SETS ddvuic ""			! Recompile subroutine DEVUIC.
.;	.SETS dchkdv ""			! Recompile subroutine CHKDEV.
	.SETS dchkuc ""			! Recompile subroutine CHKUIC.
.;	.SETS dsettr ""			! Recompile subroutine SETTRM.
.;	.SETS dasnrs ""			! Recompile subroutine ASNRST.
.;	.SETS dmcrcm ""			! Recompile subroutine MCRCMD.
.;	.SETS dchkmo ""			! Recompile subroutine CHKMOU.
.;	.SETS dlstdr ""			! Recompile LSTDIR.
.;	.SETS dastrx ""			! Recompile ASTERX.
.;	.SETS ddefcd ""			! Recompile subroutine DEFCMD.
.;	.SETS ddruic ""			! Recompile DIRUIC.
	.SETS dmove ""			! Recompile subroutine MOVE.
.;
.; Uncomment above lines to select any or all modules to rebuild.
.;
.; Begin compilations.
.;
'dmove'	'for' MOVE=MOVE'swt'
'dmove'	.IF <exstat> <> 1 .GOTO Err
'ddefcd''for' DEFCMD=DEFCMD'swt'
'ddefcd'.IF <exstat> <> 1 .GOTO Err
'dgetlg''for' GETLOG=GETLOG'swt'
'dgetlg'.IF <exstat> <> 1 .GOTO Err
'dparse''for' PARSE=PARSE'swt'
'dparse'.IF <exstat> <> 1 .GOTO Err
'dinszp''for' INSZIP=INSZIP'swt'
'dinszp'.IF <exstat> <> 1 .GOTO Err
'dgetdf''for' GETDEF=GETDEF'swt'
'dgetdf'.IF <exstat> <> 1 .GOTO Err
'dskpsp''for' SKPSPC=SKPSPC'swt'
'dskpsp'.IF <exstat> <> 1 .GOTO Err
'ddvuic''for' DEVUIC=DEVUIC'swt'
'ddvuic'.IF <exstat> <> 1 .GOTO Err
'dchkdv''for' CHKDEV=CHKDEV'swt'
'dchkdv'.IF <exstat> <> 1 .GOTO Err
'dchkuc''for' CHKUIC=CHKUIC'swt'
'dchkuc'.IF <exstat> <> 1 .GOTO Err
'dsettr''for' SETTRM=SETTRM'swt'
'dsettr'.IF <exstat> <> 1 .GOTO Err
'dmcrcm''for' MCRCMD=MCRCMD'swt'
'dmcrcm'.IF <exstat> <> 1 .GOTO Err
'dasnrs''for' ASNRST=ASNRST'swt'
'dasnrs'.IF <exstat> <> 1 .GOTO Err
'dchkmo''for' CHKMOU=CHKMOU'swt'
'dchkmo'.IF <exstat> <> 1 .GOTO Err
'dlstdr''for' LSTDIR=LSTDIR'swt'
'dlstdr'.IF <exstat> <> 1 .GOTO Err
'dastrx''for' ASTERX=ASTERX'swt'
'dastrx'.IF <exstat> <> 1 .GOTO Err
'ddruic''for' DIRUIC=DIRUIC'swt'
'ddruic'.IF <exstat> <> 1 .GOTO Err
.;
.; Replace specified modules.
.;
'dmove'	LBR MOVE.OLB/RP=MOVE.OBJ
'dparse'LBR MOVE.OLB/RP=PARSE.OBJ
'dgetlg'LBR MOVE.OLB/RP=GETLOG.OBJ
'dgetdf'LBR MOVE.OLB/RP=GETDEF.OBJ
'dinszp'LBR MOVE.OLB/RP=INSZIP.OBJ
'dskpsp'LBR MOVE.OLB/RP=SKPSPC.OBJ
'ddvuic'LBR MOVE.OLB/RP=DEVUIC.OBJ
'dchkdv'LBR MOVE.OLB/RP=CHKDEV.OBJ
'dchkuc'LBR MOVE.OLB/RP=CHKUIC.OBJ
'dsettr'LBR MOVE.OLB/RP=SETTRM.OBJ
'dmcrcm'LBR MOVE.OLB/RP=MCRCMD.OBJ
'dasnrs'LBR MOVE.OLB/RP=ASNRST.OBJ
'dchkmo'LBR MOVE.OLB/RP=CHKMOU.OBJ
'ddefcd'LBR MOVE.OLB/RP=DEFCMD.OBJ
'dlstdr'LBR MOVE.OLB/RP=LSTDIR.OBJ
'dastrx'LBR MOVE.OLB/RP=ASTERX.OBJ
'ddruic'LBR MOVE.OLB/RP=DIRUIC.OBJ
.;
.MakBld:
	.OPEN MOVBLD.BLD
	.DATA MOVE/MU/ID/FP=MOVE/LB:MOVE,MOVE/LB
	.DATA LB:[1,1]F4POTS/LB,SYSLIB/LB
	.DATA /
	.DATA TASK='tsk'
	.DATA UNITS=5
	.DATA 'libr'
	.DATA //
	.CLOSE MOVBLD.CMD
	TKB @MOVBLD.BLD
.;
.; Purge and delete files.
.;
	PIP MOVE.OBJ;*/DE/NM,PARSE.OBJ;*,GETLOG.OBJ;*,INSZIP.OBJ;*
	PIP GETDEF.OBJ;*/DE/NM,SKPSPC.OBJ;*,DEVUIC.OBJ;*,CHKDEV.OBJ;*
	PIP CHKUIC.OBJ;*/DE/NM,SETTRM.OBJ;*,MCRCMD.OBJ;*,ASNRST.OBJ;*
	PIP CHKMOU.OBJ;*/DE/NM,DEFCMD.OBJ;*,LSTDIR.OBJ;*,ASTERX.OBJ;*
	PIP DIRUIC.OBJ;*/DE/NM
	PIP MOVBLD.BLD;*/DE/NM
	PIP MOVE.TSK/PU
.;
.; Install new task.
.;
.;	.IFINS 'tsk' REM 'tsk'
.;	INS MOVE/TASK='tsk'
.Xit:
	.EXIT
.ERR:
	.GOTO Xit
