	PROGRAM PRNTER
C
	IMPLICIT	NONE
C
	CHARACTER*80	file_name		! File name.
	CHARACTER*80	name_buffer		! Switch value buffer.
	CHARACTER*80	que_nam, copies		! Values for queue and copies.
	CHARACTER*80	forms			! Value for FORM switch.
	CHARACTER*1	blnk			! Blank.
C
	LOGICAL		flag_file		! Flag for success.
C
	INTEGER*4	error_status
	INTEGER*4	completion_status
	INTEGER*4	log_file
	INTEGER*4	remote_node
	INTEGER*4	start_loc
	INTEGER*4	total_length
	INTEGER*4	loc_end
	INTEGER*4	LIB$SPAWN
	INTEGER*4	SS$_NORMAL
	INTEGER*4	len_que
	INTEGER*4	len_copies
	INTEGER*4	len_form
	INTEGER*4	comma1, comma2, comma3
	INTEGER*2	fatal, success
C
	EXTERNAL	SS$_NORMAL
	EXTERNAL	LIB$SPAWN
C
	DATA		blnk/' '/
	DATA		log_file/1/
	DATA		remote_node/2/
	DATA		total_length/80/
	DATA		fatal/-1/, success/0/
C
C	 Executable begins here.
C
	flag_file = .FALSE.
C
	OPEN (	UNIT = log_file,			! Open output file.
     +		FILE = 'PRINT_LIST.TMP',
     +		STATUS = 'NEW',
     +		DISPOSE = 'SAVE',
     +		ERR = 9900 )
C
	OPEN (	UNIT = remote_node,			! Open DECNET.
     +		FILE = 'sys$net',
     +		FORM = 'UNFORMATTED',
     +		ACCESS = 'SEQUENTIAL',
     +		STATUS = 'OLD',
     +		RECORDTYPE = 'VARIABLE',
     +		ERR = 9950 )
C
	WRITE ( log_file, 5 )
5	FORMAT ( ' Starting PRNTER.EXE...' )
C
	READ ( remote_node,				! Get the file name
     +	       IOSTAT = error_status ) file_name	! to copy and print.
	IF ( error_status .NE. 0 ) THEN			! Read go OK?
	   flag_file = .TRUE.				! Print out log_file.
	   WRITE ( log_file, 10 ) error_status		! Nope, so say so.
10	   FORMAT(1X,'%PRNTER-F, Unable to read ',	! 
     +		  ' from DECNET.  IOSTATUS = ',I10,/)	! 
	ELSE						! Read file list.
	    WRITE ( log_file, 23 ) file_name		! Write input to log file.
23	    FORMAT ( ' File list:'/' ',A )		! 
	    READ ( remote_node,				! Get the queue name,
     +		   IOSTAT=error_status ) name_buffer	! to copy and print,
							! if any.
	    IF ( error_status .NE. 0 ) THEN		! Failure to read.
		flag_file = .TRUE.			! Print out log_file.
		WRITE ( log_file, 10 ) error_status	! Nope, so say so.
25		FORMAT(1X,'%PRNTER-F, Unable to read ',	! 
     +		       ' from DECNET.  ',		! 
     +		       'IOSTATUS = ',I10,/)		! 
	    ELSE					! Success reading data.
		WRITE ( log_file, 622 ) name_buffer	! Write to log file.
622		FORMAT (' Switch values:',/' ',A)	! 
		comma1 = INDEX ( name_buffer,		! First comma splits
     +				      ',' )		! off copy count.
		IF ( comma1 .LE. 0 ) THEN
		    WRITE ( log_file, 671 ) 'COMMA1', comma1
671		    FORMAT ( ' ',A,': ',I10 )
		    flag_file = .TRUE.			! Print error message.
		    GO TO 9100				! Error exit.
		END IF
		comma2 = INDEX ( name_buffer(comma1+1:	! Find second comma,
     +				 total_length), ',' ) +	! denoting queue name.
     +			 comma1				! 
		IF ( comma2 .LE. comma1 ) THEN
		    WRITE ( log_file, 671 ) 'COMMA2', comma2
		    flag_file = .TRUE.			! Print error message.
		    GO TO 9100				! Error exit.
		END IF
		comma3 = INDEX ( name_buffer(comma2+1:	! Point to third comma,
     +				 total_length), ',' ) +	! used for FORM number.
     +			 comma2				! 
		IF ( comma3 .LE. comma2 ) THEN
		    WRITE ( log_file, 671 ) 'COMMA3', comma3
		    flag_file = .TRUE.			! Print error message.
		    GO TO 9100				! Error exit.
		END IF
		copies(1:) = name_buffer(1:comma1-1)	! Pull off first value,
							! use as copy count.
		len_copies = comma1 - 1			! Save length.
		que_nam(1:) = name_buffer(comma1+1:	! Pull off queue name.
     +					  comma2-1)	! 
		len_que = comma2 - comma1 - 1		! Save length.
		forms(1:) = name_buffer(comma2+1:	! Pull off form number.
     +					comma3-1)	! 
		len_form = comma3 - comma2 - 1		! Save length.
		loc_end = INDEX ( file_name, blnk ) - 1	! Find first blank;
							! this denotes end of
							! list.
		IF ( loc_end .LE. 0 ) loc_end =		! 
     +					  total_length	! 
		WRITE ( log_file, 633 ) 'PRINT'//	! Print command.
     +					   '/COPIES='//	! 
     +					   copies(1:len_copies)//
     +					   '/QUEUE='//	! 
     +					   que_nam(1:len_que)//
     +					   '/FORM='//	! 
     +					   forms(1:len_form)//
     +					   '/DELETE '//	! 
     +					   file_name(1:loc_end)
633		FORMAT ( ' ',A )
		error_status = LIB$SPAWN ( 'PRINT'//	! Print command.
     +					   '/COPIES='//	! 
     +					   copies(1:len_copies)//
     +					   '/QUEUE='//	! 
     +					   que_nam(1:len_que)//
     +					   '/FORM='//	! 
     +					   forms(1:len_form)//
     +					   '/DELETE '//	! 
     +					   file_name(1:loc_end),
     +					   , , , , ,	! 
     +					   completion_status )
		IF ( (error_status .NE.			! Print failed.
     +		      %LOC ( SS$_NORMAL )) .OR.		! Issue error message.
     +		     (IAND ( completion_status,		! 
     +		      %LOC ( SS$_NORMAL ) )		! 
     +		      .NE. %LOC ( SS$_NORMAL )) ) THEN	! 
		    flag_file = .TRUE.			! 
		    WRITE ( log_file, 30 ) error_status,! 
     +					   completion_status
30		    FORMAT (1X,'%PRNTER_F, Cannot print file,',
     +			    ' status = ',I10/
     +			    1X,'completion status = ',I10)
		END IF					! 
	    END IF					! 
	END IF						! 
9100	CONTINUE
	IF ( flag_file ) THEN				! 
	   CLOSE ( UNIT = log_file, DISPOSE = 'SAVE' )	! Close the log file.
	   error_status = LIB$SPAWN ( 'PRINT/DELETE PRINT_LIST.TMP',
     +				      , , , , , completion_status )
	    WRITE ( remote_node,			! Write error value.
     +		   IOSTAT=error_status ) fatal		! 
	ELSE						! 
	   CLOSE ( UNIT = log_file, DISPOSE = 'DELETE' )! 
	   WRITE ( remote_node,				! Write error value.
     +		   IOSTAT=error_status ) success	! 
	END IF
9000	CONTINUE
	CLOSE ( UNIT = remote_node )			! Close the DECNET
							! connection.
	CALL EXIT
C
9900	CONTINUE
9950	CONTINUE
	GO TO 9000
	END
