.;
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.ENABLE QUIET
.DISABLE DISPLAY
.ENABLE CONTROL-Z
.ENABLE ESCAPE
.;
.; MOVE.CMD --
.;
.; This command file was designed to work in conjunction with the CCL
.; command line interpreter to allow moving around from device to device,
.; UIC to UIC, user number to user number and group to group.  It also
.; allows for logical name translation.
.;
.; This command file is only good on M-PLUS systems, V 3.0B and up, and
.; it won't work with named directories yet, due to the parsing scheme.
.;
.; The general idea is to look for a colon.  If we have one, parse into
.; device and UIC and check each.  Otherwise, try to convert the input
.; string from a logical.  Also, allow the inclusion of spaces between
.; the two UIC numbers, and allow the forms <nnn,> and <,nnn> to change
.; just the user or group number, by using the value of the <UIC> symbol
.; as the default.
.;
.; Author:	Robert Hays
.; Company:	KMS Fusion, Inc.
.; Address:	3621 South State Road
.;		Ann Arbor, MI  48106
.; Date:	April 1, 1986
.;
.ONERR Err
.;
.; Initialize constants and variables.
.;
.SETN status 1				! Exit status.
.SETF dev				! If we find a device, set to true.
.SETF uic				! If we find a UIC, set to true.
.SETF $devmo				! If we mount device, set true.
.SETS def "SYS$LOGIN"			! Set up default destination.
.SETS dstuic ""				! Destination UIC.
.SETS curuic "'<uic>'"			! Current UIC (default).
.SETS $devic ""				! Global for dest. device.
.SETS $uic ""				! Global for UIC.
.PARSE curuic "," frscur lstcur		! Parse our default UIC.
.SETS defdev <sydisk>+"'<syunit>'"+":"
.;
	.IFNDF p1 .SETS p1 ""		! Initialize p1.
	.IF p1 NE "" .GOTO TryIt
		.SETS outlst defdev+curuic
		.GOTO Disply
.TryIt:
	.TEST p1 ":"			! Look for colon.
	.IF <strlen> LE 0 .GOTO Nodev	! No device if no colon.  We will look
.;					! for logicals soon.
.;
	.PARSE p1 ":" $devic p1		! Parse off the device into the global
.;					! symbol $DEVIC for the call and
.;					! return to LOGNAM, which checks for
.;					! logical names.
	@LB:[1,5]LOGNAM '$devic'
	.IF $devic EQ "" .GOTO Setuic	! On no device, skip to UIC check.
.;					! Otherwise, check that the device
.;					! requested is mounted.  If not,
.;					! mount it.  This is what CHKDEV
.;					! does.
		@CHKDEV '$devic'
		.IF <exstat> NE 1 .GOTO Err
		.SETT dev		! Set flag for device to true.
.Nodev:
	.SETS dstuic p1			! If no device, store input in dstuic.
	.IF p2 NE "" .SETS dstuic dstuic+" "+p2
.;					! If p2 was not blank, force a blank
.;					! between p1 and p2 at this point.
.;					! Notice, the device name, if any,
.;					! has been parsed off.
.;
.Setuic:
	.IF $uic NE "" .SETS dstuic $uic+dstuic
.;					! If $UIC is not blank, the logical
.;					! name used in the device call to
.;					! LOGNAM contained a UIC, so tack
.;					! it on now.
	.IF dstuic EQ "" .GOTO Cont	! If no UIC at this point, continue.
.;
.; At this point, DSTUIC contains either:
.; 1)  A UIC,
.; 2)  Part of a UIC, or
.; 3)  A logical name only.
.;
.; Replace the first blank with a comma.
.;
		.TEST dstuic " "
		.SETN comma <strlen>
		.TEST dstuic
		.SETN totlen <strlen>
		.IF comma GT 0 .SETS first dstuic[1:comma-1]
		.IF comma GT 0 .SETS last dstuic[comma+1:<strlen>]
		.IF comma GT 0 .SETS dstuic first+","+last
.;
		.TEST dstuic ","
.;
.; If there is no comma in the destination UIC now, we must have either
.; a logical name or a bad line, so try it out at Trylog.
.;
		.IF <strlen> LE 0 .GOTO Trylog
		.PARSE dstuic "," first last
.;
.; Check for only user number or group number, and set default if needed.
.;
		.IF first EQ "" .SETS first frscur
		.IF last EQ "" .SETS last lstcur
		.SETS dstuic first+","+last
		.SETT uic		! Got a UIC, so set flag.
.;
.; Make sure [ and ] are on UIC string.
.;
		.TEST dstuic "["
		.IF <strlen> LE 0 .SETS dstuic "["+dstuic
		.PARSE dstuic "]" dstuic rest
		.SETS dstuic dstuic+"]"
.;
.Cont:
.;
.; If the appropriate flag is set, set SY: to the desired device and
.; set the UIC also.
.;
	.IFT dev ASN '$devic'=SY:
	.IFT uic SET /UIC='dstuic'
.;
.; Display destination.
.;
	.SETS outlst ""
	.IFT dev .SETS outlst $devic
	.IFF dev .SETS outlst defdev
	.IFT uic .SETS outlst outlst+dstuic
	.IFF uic .SETS outlst outlst+curuic
.;
.; Define local logicals for last location and current location.
.;
	ASN =LAST:
	ASN =CURRENT:
	ASN 'outlst'=CURRENT:
	.SETS tmp defdev+curuic
	ASN 'tmp'=LAST:
.Disply:
	.DISABLE QUIET
	;'outlst'
	.ENABLE QUIET
.;
.Endr:
	.EXIT status
.;
.Trylog:
.;
.; Check for a logical name.
.;
	@LOGNAM 'dstuic'
	.IF <exstat> NE 1 .GOTO Err
		.SETS dstuic $uic
		.IF dstuic NE "" .SETT uic
		.IF $devic NE "" .SETT dev
		.IFF uic .IFF dev .GOTO Err
		.GOTO Cont
.;
.Err:
.;
.; Error.
.;
	.IFT $devmo DMO '$devic'/LOCK=N
	.DISABLE QUIET
	; ERROR -- No change in device location.
	.ENABLE QUIET
	.SETN status 4
	.GOTO Endr
