.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.ENABLE DISPLAY
.ENABLE QUIET
.;
.; This command file stops accounting and error logging, then
.; copies the data files for these tasks to the account at logical
.; name KMS$BACKUPLOG, and either create a new monthly report file for
.; each or append the files if the monthly file already exists.
.;
.; Set the symbol CMDLOC for the location of your LOGNAM command file.  If
.; you use the default location for Indirect, then make it a nul string, or
.; "".
.;
.;	.SETS dbg ";"
	.SETS dbg ""
.;
	.SETS cmdloc "KMS$COMMAND:"
.;
	.SETS def1 "LB:[1,6]"
	.SETS def2 "LB:[1,6]"
	.SETS def3 "LB:[1,6]"
.;
.; Check for logical names SYS$ERRLOG and SYS$ACCOUNT, and if they do not
.; come back from LOGNAM, then use defaults.
.;
	.SETS $devic ""
	.SETS errloc "SYS$ERRLOG:"
	@'cmdloc'LOGNAM SYS$ERRLOG
	.IF $devic <> "" .GOTO GotERR
	    .SETS errloc def1
.GotERR:
	.SETS $devic ""
	.SETS acnloc "SYS$ACCOUNT:"
	@'cmdloc'LOGNAM SYS$ACCOUNT
	.IF $devic <> "" .GOTO GotACN
	    .SETS acnloc def2
.GotACN:
.;
.; Set up source file names.
.;
	.SETS srclog "ERRORS.LOG"
	.SETS srcerr "LOG.ERR"
	.SETS srcsys "ACNTRN.SYS"
.;
.; Create destination file names.
.;
	.SETS date <date>			! Get system date.  We will
.;						! ignore the day.
	.PARSE date "-" day month year		! Pull out month and year.
	.SETS errlog month+year+"ERR.LOG"	! Fix up the three file names:
	.SETS logerr month+year+"LOG.ERR"	!   *ERR.LOG is for ERRORS.LOG
	.SETS acnsys month+year+"ACN.SYS"	!   *LOG.ERR is for LOG.ERR
.;						!   *ACN.SYS is for ACNTRN.SYS
.; Check for backup location's existance.
.;
	.SETS $devic ""
	.SETS backup "KMS$BACKUPLOG:"
	@'cmdloc'LOGNAM KMS$BACKUPLOG
	.IF $devic <> "" .GOTO GotBac
	    .SETS backup def3
.GotBac:
.;
.; Stop error logging and accounting.
.;
'dbg'	@'cmdloc'STOPACC
'dbg'	@'cmdloc'STOPELI
.;
.; Go to backup location so we can copy files here.
.;
'dbg'	@'cmdloc'MOVE 'backup'
'dbg'	PIP 'backup'/NV='errloc''srcerr'
'dbg'	PIP 'backup'/NV='errloc''srclog'
'dbg'	PIP 'backup'/NV='acnloc''srcsys'
.;
.; The files are now copied to the backup location.  Append them to the
.; current month's file.  First, see that the file exists.
.;
	.SETN stat 1
'dbg'	.TESTFILE 'errlog'
	.IF <filerr> = 1 .GOTO gdfil1
'dbg'	    PIP 'errlog'/NV='srclog'
	    .IF <exstat> <> 1 .SETN stat 4
	    .GOTO Nxt1
.Gdfil1:
'dbg'	    PIP 'errlog'='srclog'/AP
	    .IF <exstat> <> 1 .SETN stat 4
.Nxt1:
	.DISABLE QUIET
	.IF stat <> 1 ; ERROR File 'srclog' not merged into monthly file.
	.IF stat = 1 ; File 'srclog' merged into monthly file.
	.ENABLE QUIET
	.SETN stat 1
'dbg'	PIP 'srclog';0/DE/NM
'dbg'	.TESTFILE 'logerr'
	.IF <filerr> = 1 .GOTO gdfil2
'dbg'	    PIP 'logerr'/NV='srcerr'
	    .IF <exstat> <> 1 .SETN stat 4
	    .GOTO Nxt2
.Gdfil2:
'dbg'	    PIP 'logerr'='srcerr'/AP
	    .IF <exstat> <> 1 .SETN stat 4
.Nxt2:
	.DISABLE QUIET
	.IF stat <> 1 ; ERROR File 'srcerr' not merged into monthly file.
	.IF stat = 1 ; File 'srcerr' merged into monthly file.
	.ENABLE QUIET
	.SETN stat 1
	PIP 'srcerr';0/DE/NM
	.TESTFILE 'acnsys'
	.IF <filerr> = 1 .GOTO gdfil3
'dbg'	    PIP 'acnsys'/NV='srcsys'
	    .IF <exstat> <> 1 .SETN stat 4
	    .GOTO Nxt3
.Gdfil3:
'dbg'	    PIP 'acnsys'='srcsys'/AP
	    .IF <exstat> <> 1 .SETN stat 4
.Nxt3:
	.DISABLE QUIET
	.IF stat <> 1 ; ERROR File 'srcsys' not merged into monthly file.
	.IF stat = 1 ; File 'srcsys' merged into monthly file.
	.ENABLE QUIET
	.SETN stat 1
	PIP 'srcsys';0/DE/NM
.;
.; We now have account and error log files merged and contained in the
.; monthly files.  Now, delete the source files and start accounting and
.; ELI back up.
.;
'dbg'	@'cmdloc'MOVE 'errloc'
'dbg'	PIP 'srclog';0/de/nm
'dbg'	PIP 'srcerr';0/de/nm
'dbg'	@'cmdloc'MOVE 'acnloc'
'dbg'	PIP 'srcsys';0/de/nm
.;
.; Start error logging and accounting back up.
.;
'dbg'	@'cmdloc'STARTELI
'dbg'	@'cmdloc'STARTACC
.;
.Xit:
	.DELAY 2M
	.EXIT
