.ENABLE SUBSTITUTION
.ENABLE ESCAPE
;
; Command file to assemble / build task IDX
; 28-NOV-79 by G. Maxwell
;
.SETS ORGUIC <UIC>
.SETF CWDINS
.IFINS ...CWD .SETT CWDINS
; Answer Yes to the following query if you wish to build IDX
; from an existing copy of IDX.OLB.
;
.ASK BONLY Do you wish to build IDX from an existing object library
.IFT BONLY .GOTO 9
.9:
;
; The following queries will establish the device and UIC locations
; for source files and the destinations for output files.
;
; Typing the <ESC> character in response to any of the following device
; queries will default the specific device to be your current
; default device ("SY0:")
;
.SETS DEFD "SY0:"
.3010:
.IFT BONLY .ASKS XXD On which device is the object library located (DDN:)?
.IFF BONLY .ASKS XXD On which device are the source files located (DDN:)?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 3010
.IFT <ESCAPE> .SETS XXD DEFD
.SETS LSD ""
.IFT BONLY .GOTO 3015
.3012:
.ASKS LSD Which device will receive the list files (DDN:)?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 3012
.IFT <ESCAPE> .SETS LSD DEFD
.3015:
.ASKS MPD Which device will receive the map file (DDN:)?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 3015
.IFT <ESCAPE> .SETS MPD DEFD
.3020:
.ASKS SY1D Which device will receive the task image (DDN:)?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 3020
.IFT <ESCAPE> .SETS SY1D DEFD
.3025:
;
ASN 'XXD'=XX:
.IFF BONLY ASN 'LSD'=LX:
ASN 'MPD'=MP:
ASN 'SY1D'=SY1:
.IFT BONLY .SETS S "map"
.IFF BONLY .SETS S "source, map,"
.IFT BONLY .SETS S0 "object library"
.IFF BONLY .SETS S0 "source and listing files"
;
; Please note that you must have write access to the 'S'
; and task image UIC's in order for this command file to work!
;
; Typing the <ESC> character in response to the following query will
; set the 'S0' directory to the current default 
; directory: '<UIC>'
;
.IFF BONLY ; Note that listing and object files are directed to the same
.IFF BONLY ; directory that contains the source files.
.IFF BONLY ;
.3030:
.IFT BONLY .ASKS DUIC Which directory contains the object library ([G,M])?
.IFF BONLY .ASKS DUIC Which directory contains the source files ([G,M])?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 3030
.IFT <ESCAPE> .SETS DUIC <UIC>
;
; Typing the <ESC> character in response to the following query will set 
; the map directory to be the current default directory: '<UIC>'
;
.3035:
.ASKS MUIC Which directory will receive the map file ([G,M])?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 3035
.IFT <ESCAPE> .SETS MUIC <UIC>
;
; Typing the <ESC> character in response to the following query will
; direct the task image file to the system directory: '<SYSUIC>'
;
.40:
.ASKS SUIC Which directory will receive the task image file ([G,M])?
.IF <STRLEN> EQ 0 .AND .IFF <ESCAPE> .GOTO 40
.IFT <ESCAPE> .SETS SUIC <SYSUIC>
.IFT BONLY .GOTO 6000
;
; We will now assemble the necessary files...
;
.IFT CWDINS CWD 'DUIC'
.IFF CWDINS SET /UIC='DUIC'
PIP XX:INDEX.OBJ;*/DE,LX:INDEX.LST;*
PIP XX:BUFFER.OBJ;*/DE,LX:BUFFER.LST;*
PIP XX:EVAL.OBJ;*/DE,LX:EVAL.LST;*
PIP XX:GET.OBJ;*/DE,LX:GET.LST;*
PIP XX:INCLUD.OBJ;*/DE,LX:INCLUD.LST;*
PIP XX:IOCHR.OBJ;*/DE,LX:IOCHR.LST;*
PIP XX:IOLINE.OBJ;*/DE,LX:IOLINE.LST;*
PIP XX:LINETP.OBJ;*/DE,LX:LINETP.LST;*
PIP XX:OPNCLO.OBJ;*/DE,LX:OPNCLO.LST;*
PIP XX:OUTPUT.OBJ;*/DE,LX:OUTPUT.LST;*
PIP XX:PAREXP.OBJ;*/DE,LX:PAREXP.LST;*
PIP XX:RAD50.OBJ;*/DE,LX:RAD50.LST;*
PIP XX:SKPNUM.OBJ;*/DE,LX:SKPNUM.LST;*
PIP XX:STORE.OBJ;*/DE,LX:STORE.LST;*
PIP XX:TABLE.OBJ;*/DE,LX:TABLE.LST;*
;
; We will now determine the assembly options you desire for IDX.
;
; The FORTRAN-IV-PLUS compiler has the capability of processing
; INCLUDE statements in a program. This allows external source files
; to be processed during compilation. To implement this feature
; for IDX requires additional File Descriptor Blocks, one for every
; nested INCLUDE statement in a source program. 
;
; The default nesting level is 3. However, in the following query,
; you may decide to allow any nesting level you desire. If you respond
; with zero (0), all INCLUDE processing for IDX is disabled and
; is not assembled.
;
.ASKN [0:10.:3] NLEV Maximum allowable nesting level for INCLUDEs:
;
; Answer Yes to the following query if your host processor has
; EIS hardware capability.
;
.ASK EIS Does your host have EIS capability
;
PIP XX:RSXPRE.MAC;*/DE
.OPEN XX:RSXPRE.MAC
.ENABLE DATA
.NLIST
R$$SX = 0	; Assemble for RSX-11M
L$$INC = 'NLEV'.	; Nesting depth
.DISABLE DATA
.IFT EIS .DATA E$$IS = 0	; EIS capability
.DATA .LIST
.CLOSE
PIP XX:IDXASM.CMD;*/DE
.OPEN XX:IDXASM.CMD
.ENABLE DATA
XX:INDEX,LX:INDEX/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'INDEX
XX:BUFFER,LX:BUFFER/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'BUFFER
XX:EVAL,LX:EVAL/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'EVAL
XX:GET,LX:GET/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'GET
XX:INCLUD,LX:INCLUD/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'INCLUD
XX:IOCHR,LX:IOCHR/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'IOCHR
XX:IOLINE,LX:IOLINE/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'IOLINE
XX:LINETP,LX:LINETP/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'LINETP
XX:OPNCLO,LX:OPNCLO/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'OPNCLO
XX:OUTPUT,LX:OUTPUT/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'OUTPUT
XX:PAREXP,LX:PAREXP/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'PAREXP
XX:RAD50,LX:RAD50/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'RAD50
XX:SKPNUM,LX:SKPNUM/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'SKPNUM
XX:STORE,LX:STORE/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'STORE
XX:TABLE,LX:TABLE/-SP=XX:'DUIC'RSXPRE,-
XX:'DUIC'TABLE
.DISABLE DATA
.CLOSE
;
MAC @XX:IDXASM.CMD
.WAIT ...MAC
;
.ASK L Did everything assemble without errors
.IFT L .GOTO 60
;
; Hmmmm, even though you should not have encountered errors,
; we will now exit so you can (hopefully) correct the problem...
;
.GOTO 990
.60:
;
; Good, we will now build the object library for IDX
;
PIP XX:IDX.OLB;*/DE,XX:IDX.OBS;*
PIP XX:IDX.OBS=XX:INDEX.OBJ;0,XX:BUFFER.OBJ;0,XX:EVAL.OBJ;0
.WAIT ...PIP
PIP XX:IDX.OBS=XX:GET.OBJ;0,XX:INCLUD.OBJ;0,XX:IOCHR.OBJ;0/AP
.WAIT ...PIP
PIP XX:IDX.OBS=XX:IOLINE.OBJ;0,XX:LINETP.OBJ;0,XX:OPNCLO.OBJ;0/AP
.WAIT ...PIP
PIP XX:IDX.OBS=XX:OUTPUT.OBJ;0,XX:PAREXP.OBJ;0,XX:RAD50.OBJ;0/AP
.WAIT ...PIP
PIP XX:IDX.OBS=XX:SKPNUM.OBJ;0,XX:STORE.OBJ;0,XX:TABLE.OBJ;0/AP
.WAIT ...PIP
;
PIP XX:INDEX.OBJ;0,XX:BUFFER.OBJ;0,XX:EVAL.OBJ;0/DE
PIP XX:GET.OBJ;0,XX:INCLUD.OBJ;0,XX:IOCHR.OBJ;0/DE
PIP XX:IOLINE.OBJ;0,XX:LINETP.OBJ;0,XX:OPNCLO.OBJ;0/DE
PIP XX:OUTPUT.OBJ;0,XX:PAREXP.OBJ;0,XX:RAD50.OBJ;0/DE
PIP XX:SKPNUM.OBJ;0,XX:STORE.OBJ;0,XX:TABLE.OBJ;0/DE
;
LBR XX:IDX/CR=XX:IDX.OBS
.WAIT ...LBR
PIP XX:IDX.OBS;*/DE
.GOTO 6002
;
.6000:
;
; Before we build, we have to know what the nesting depth for
; processing INCLUDE statements was in assembling the version of
; IDX in the object library. This information is present in the
; prefix file RSXPRE.MAC.
;
.ASK L Do you want the prefix file RSXPRE printed (it is a small file)
.IFT L PIP TI:=XX:'DUIC'RSXPRE.MAC
.IFT L ; Use the value assigned to L$$INC in RSXPRE.MAC as your answer
.IFT L ; to the following query.
;
.ASKN [0:10.:3] NLEV What is the maximum nesting depth for INCLUDE''s?
.6002:
;
; We will now build task IDX...
;
PIP XX:IDXBLD.CMD;*/DE
.OPEN XX:IDXBLD.CMD
.DATA SY1:'SUIC'IDX/-FP/CP,MP:'MUIC'IDX/-SP/CR=XX:'DUIC'IDX/LB:INDEX
.DATA XX:'DUIC'IDX/LB
.DATA /
.DATA TASK=...IDX
.SETN NUNITS 3.
.SETN NUNITS NUNITS+NLEV
.DATA UNITS='NUNITS'
.DATA ASG=TI:1,SY0:2:3
.IF NLEV EQ 0 .GOTO 6010
.SETS S0 "ASG=SY0"
.SETN I 4.
.6005:
.SETS S0 S0+":'I'"
.INC I
.IF I <= NUNITS .GOTO 6005
.DATA 'S0'
.6010:
;
; You may now decide how many lines IDX will output per page.
; This value by default is 57. (71 octal) per page. You may specify
; any octal value to override this default
;
.ASKN [::71] LINNUM Octal number of lines per page of IDX output:
.DATA GBLDEF=MAXLIN:'LINNUM'
.ENABLE DATA
;
; THE FOLLOWING SYMBOL DEFINITION SPECIFIES DEFAULT SWITCH SETTINGS.
; AS DISTRIBUTED, THE /LP AND /F4P SWITCHES DEFAULT TO THE 'ON'
; SETTING. FOR EACH CORRESPONDING BIT THAT IS SET IN THE GBLDEF
; OPTION, THE INDICATED SWITCH DEFAULTS TO THE ON POSITION. THE
; SWITCHES AND THEIR CORRESPONDING BITS ARE:
;
;     /HE          1
;     /DE          2
;     /EX          4
;     /LP         10
;     /NS         20
;     /F4P        40
;
GBLDEF=$DFSWT:50
.DISABLE DATA
;
; We will now determine the size allocation for IDX''s symbol table.
; If your host system has the EXTK$ directive capability, then you
; need not be concerned with allocation, as IDX uses the EXTK$ 
; directive as needed.
;
.ASK L Does your host system have the EXTK$ directive
.IFT L .DATA EXTTSK=1024
.IFT L .GOTO 6020
;
; IDX is entirely dependent on its task extension size for its symbol
; table storage requirements. For small to medium size FORTRAN input
; modules, the default extension size of 4096. words (4K words) is
; satisfactory. As a rough estimate of use, 1024. words of table space
; can hold 80. symbol definitions and 200. different symbol references.
;
.ASKN [::4096.] INC No. words (decimal) to allocate for symbol table:
.DATA EXTTSK='INC'
.6020:
.DATA //
.CLOSE
;
; You have the ability to decide which IDX command line switches will
; be on by default. This is done by editing the IDX indirect TKB command
; file, XX:'TASNAM'BLD.CMD. As distributed, switches /LP (132. column output)
; and /F4P (FORTRAN-IV-PLUS compiler mode) are on by default. Instructions
; for setting different switch defaults are included in the build file.
;
.ASK L Do you wish to pause now and edit the build file
.IFT L .PAUSE
;
; Now, we actually build...
;
.IFT CWDINS CWD 'SUIC'
.IFF CWDINS SET /UIC='SUIC'
;
TKB @XX:'DUIC'IDXBLD.CMD
.WAIT ...TKB
;
; Task build complete! If you encountered no errors, congratulations!
; You may want to purge old versions of the task and map files now...
;
.990:
.IFT CWDINS CWD 'ORGUIC'
.IFF CWDINS SET /UIC='ORGUIC'
;
ASN =XX:
ASN =MP:
.IFF BONLY ASN =LX:
ASN =SY1:
.999:
