c fastlp - output to line printer directly through i/o page
c
c
c	date of   first   version:  21-Jun-83
c
c	programmer:  Matt Prucka
c
c******************************************************************
c   DEFINE(ADDR,\"175660)		# CEL port #2
c CEL q-bus
      subroutine fastlp(buf)
      implicit integer (a-z)
      byte dc1,dc3,buf(1)
      data dc1,dc3/17,19/
c Set up I/O register addresses
      lprs="176500
      lprb=lprs+2
      lpts=lprs+4
      lptb=lprs+6
c Save csr's
      lprcsr=ipeek(lprs)
      lptcsr=ipeek(lpts)
c Disable interrupts.
      call ipoke(lprs,0)
      call ipoke(lpts,0)
c point to first byte in buf
      i=1
c turn on byte stream
      cntrl=1
c     while
23000 if(.not.(buf(i).ne.0))goto 23001
c output bytes from buffer to console
         if(.not.((ipeek(lprs) .and. "200).ne.0))goto 23002
c get char from lp, if any
c keep 7 bits
            char=ipeekb(lprb) .and. "177
            if(.not.(char.eq.dc1))goto 23004
c check for cntrl-Q
c if cntrl-Q, turn on byte stream
               cntrl=1
23004       continue
            if(.not.(char.eq.dc3))goto 23006
c check for cntrl-S
c if cntrl-S turn off byte stream
               cntrl=0
23006       continue
23002    continue
         if(.not.(cntrl.eq.1))goto 23008
c check that byte stream is turned on
c           while
23010       if(.not.((ipeek(lpts).and."200).eq.0))goto 23011
c wait here if output to lp is busy
               goto 23010
c           endwhile
23011       continue
c output next byte
            call ipokeb(lptb,buf(i))
c increment byte count
            i=i+1
23008    continue
         goto 23000
c     endwhile
23001 continue
c Restore csr's
      call ipoke(lprs,lprcsr)
      call ipoke(lpts,lptcsr)
      return
      end
