c
c
      subroutine axline (iseg)
c
c
c	PROG NAME:			AXLINE.RMC
c
c	DATE OF FIRST VERSION:		 9-Feb-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL routine to plot axis lines.
c
c	USAGE:		call AXLINE (ISEG)
c
c			where  ISEG = Axis segment number. Values:
c				    1 for the bottom segment
c				    2 for the left segment
c				    3 for the top segment
c				    4 for the right segment
c
c	NOTES FOR PROGRAMMERS:	The order to draw axis lines should be
c				Segments 2-1-4-3.  Segments 3 and 2
c				are drawn backwards in order to
c				keep the "pen" in constant "contact"
c				with the "paper".
c
c	PROGRAMMER:	E. Javel / M. Prucka
c
c*******************************************************************
c
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
      real*4zlog(8)
      logicalrevers,minors
      data zlog /.3010,.4771,.6021,.6990,.7782,.8451,.9031,.9542/
c
c---------------------------------------------------------------------
c
c Establish the various direction indicators and parameters for this segment
      xb = rxllc
      yb = ryllc
      xfac = 0.
      yfac = 0.
      xdir = 0.
      ydir = 0.
      if(.not.(iseg .eq. 1))goto 23000
c Bottom segment
         if(.not.(ticmrk .eq. 0.))goto 23002
            yfac = -1.
            goto 23003
c        else
23002       continue
            yfac = 1.
23003    continue
         xdir = 1.
         axlen = rxlen
         pct = xpct/100.
         vmin = rxmin
         vmax = rxmax
         vint = amax1(xint,1.)
         cyc = xcycle
         s1 = vmin
         s2 = vmax
         revers=.false.
         goto 23001
c     else
23000    continue
         if(.not.(iseg .eq. 2))goto 23004
c Left segment
            if(.not.(ticmrk .eq. 0.))goto 23006
               xfac = -1.
               goto 23007
c           else
23006          continue
               xfac = 1.
23007       continue
            ydir = 1.
            axlen = rylen
            pct = ypct/100.
            vmin = rymin
            vmax = rymax
            vint = amax1(yint,1.)
            cyc = ycycle
            s1 = vmax
            s2 = vmin
            yb = ryllc + rylen
            revers = .true.
            goto 23005
c        else
23004       continue
            if(.not.(iseg .eq. 3))goto 23008
c Top segment
               if(.not.(ticmrk .eq. 0.))goto 23010
                  yfac = 1.
                  goto 23011
c              else
23010             continue
                  yfac = -1.
23011          continue
               xdir = 1.
               axlen = rxlen
               pct = xpct/100.
               vmin = rxmin
               vmax = rxmax
               vint = amax1(xint,1.)
               cyc = xcycle
               xb = rxllc + rxlen
               yb = ryllc + rylen
               s1 = vmax
               s2 = vmin
               revers = .true.
               goto 23009
c           else
23008          continue
c Right segment
               if(.not.(ticmrk .eq. 0.))goto 23012
                  xfac = 1.
                  goto 23013
c              else
23012             continue
                  xfac = -1.
23013          continue
               ydir = 1.
               axlen = rylen
               if(.not.(rmin.eq.0. .and. rmax.eq. 0.))goto 23014
                  pct = ypct/100.
                  vmin = rymin
                  vmax = rymax
                  vint = amax1(yint,1.)
                  cyc = ycycle
                  goto 23015
c              else
23014             continue
                  pct = rpct/100.
                  vmin = rmin
                  vmax = rmax
                  vint = amax1(rint,1.)
                  cyc = rcycle
23015          continue
               xb = rxllc + rxlen
               s1 = vmin
               s2 = vmax
               revers = .false.
23009       continue
23005    continue
23001 continue
c Determine the number of minor intervals and, if it's a log axis,
c the limit to refer points to
      if(.not.(cyc .eq. 0.))goto 23016
         nminor = amod(10.*vint,10.) + .5
         if(.not.(nminor .gt. 1))goto 23018
            minors = .true.
            goto 23019
c        else
23018       continue
            minors = .false.
23019    continue
         delv = (s2-s1)/aint(vint)
         goto 23017
c     else
23016    continue
         nminor = 9
         minors = .true.
         delv = sign(1.,(s2-s1))
         zmin = alog10(vmin)
         s1 = alog10 (s1)
         s2 = alog10 (s2)
23017 continue
c Position the pen.
c start path
      call plot2 (xb,yb,3)
c Determine the offset to the first tick and half of a tick length
      offs = (1.-pct)/2.*axlen
      t2 = .5*tiklen
c Set the bases for future computations
      if(.not.(iseg.eq.1 .or. iseg.eq.3))goto 23020
         xb = rxllc + offs
         goto 23021
c     else
23020    continue
         yb = ryllc + offs
23021 continue
c Do major and minor intervals until we reach the end of the segment
      v = s1
      vendmn = amin1(s1,s2)
      vendmx = amax1(s1,s2)
      if(.not.(dbflg))goto 23022
         write(7,*)' axline: iseg,delv =',iseg,delv
23022 continue
c     repeat
23024    continue
c Determine the position of this tick and the
c value associated with the next major interval
         if(.not.(cyc .eq. 0.))goto 23027
            pos = (v-vmin)/(vmax-vmin)
            vend = v + delv
            goto 23028
c        else
23027       continue
            pos = (v-zmin)/cyc
            if(.not.(delv.lt.0 .and. v.gt.aint(v) .or. delv.gt.0 .and. 
     &       v.lt.aint(v)))goto 23029
               vend = aint(v)
               goto 23030
c           else
23029          continue
               vend = aint(v+delv)
23030       continue
23028    continue
         vend = amax1 (vend,vendmn)
         vend = amin1 (vend,vendmx)
         if(.not.(dbflg))goto 23031
            write(7,*)' axline: v,vend =',v,vend
c Position the pen and draw the major tick, except when ticks
c are inward-going at the segment edge and there's no offset
23031    continue
         pos = pos * axlen * pct
         x = xb + pos*xdir
         y = yb + pos*ydir
c extend path
         call plot2 (x,y,2)
         if(.not.(.not.((v.eq.s1 .or. v.eq.s2) .and. ticmrk.ne.0. .and. 
     &    offs.eq.0.)))goto 23033
            call plot2 (x+tiklen*xfac,y+tiklen*yfac,2)
c extend path
            call plot2 (x,y,2)
c Do the minor intervals, if they exist
23033    continue
         if(.not.(minors))goto 23035
            if(.not.(cyc .eq. 0.))goto 23037
c Linear axis
               vnext = v
               goto 23038
c           else
23037          continue
               vmid = .5*(v+vend)
               if(.not.(vmid.lt.0.))goto 23039
                  iexp=vmid-1.
                  goto 23040
c              else
23039             continue
                  iexp=vmid
23040          continue
23038       continue
c           for
            i=1
23041       if(.not.(i.lt.nminor))goto 23043
               if(.not.(cyc .eq. 0.))goto 23044
c Linear axis
                  vnext = v + i*delv/nminor
                  pos = (vnext-vmin)/(vmax-vmin)
                  goto 23045
c              else
23044             continue
c Log axis
                  if(.not.(delv.gt.0.))goto 23046
                     vnext = iexp + zlog(i)
                     goto 23047
c                 else
23046                continue
                     vnext = iexp + zlog(nminor-i)
23047             continue
                  pos = (vnext-zmin)/cyc
23045          continue
               if(.not.(vnext .le. vendmn .or. vendmx .le. vnext))goto 2
     &          3048
                  goto 23042
23048          continue
               if(.not.(dbflg))goto 23050
                  write(7,*)' axline: vnext =',vnext
23050          continue
               pos = pos * axlen * pct
               x = xb + pos*xdir
               y = yb + pos*ydir
c extend path
               call plot2 (x,y,2)
               call plot2 (x+t2*xfac,y+t2*yfac,2)
c extend path
               call plot2 (x,y,2)
23042           i=i+1
               goto 23041
c           endfor
23043       continue
23035    continue
         v = vend
         if(.not.(v .le. vendmn .or. vendmx .le. v))goto 23052
            goto 23026
23052    continue
c Finish the segment up by drawing the last tick and moving to the
c end of the segment, unless there isn't any offset and tick marks are inward
23025    goto 23024
23026 continue
      if(.not.(revers))goto 23054
         a = 0.
         goto 23055
c     else
23054    continue
         a = axlen - offs - offs
23055 continue
      x = xb + a*xdir
      y = yb + a*ydir
c extend path
      call plot2 (x,y,2)
      if(.not.(offs.ne.0. .or. ticmrk.eq.0.))goto 23056
         call plot2 (x+tiklen*xfac,y+tiklen*yfac,2)
c extend path
         call plot2 (x,y,2)
         if(.not.(revers))goto 23058
            offs = -offs
23058    continue
c extend path
         call plot2 (x+offs*xdir,y+offs*ydir,2)
23056 continue
c draw path
      call plot2 (xb,yb,1)
      return
      end
