/******************************************************************************

			UNSW Prolog (version 4)

			Written by Claude Sammut
		     Department of Computer Science
		     University of New South Wales
		   (and St. Joseph's U., Philadelphia)

		   Copyright (c)  1983 - Claude Sammut

******************************************************************************/





		/* SETUP FUNCTIONS AND ATOMS IN SYMBOL TABLE */


#include "pred.h"


add_atoms(atab)
atom_table atab;
{
	register h;
	register atom *p;
	extern atom *hashtable[];

	for (p = atab; p -> name != 0; p++)
	{
		h = hash(p -> name);
		p -> link = hashtable[h];
		hashtable[h] = p;
	}
}


hash_init()
{
	register int i;
	extern atom *hashtable[];	/* 9/9/86 - WEN - needed for VAX C */

	for(i = 0; i < HASHSIZE ; i++)
		hashtable[i] = 0;
}



static
atom_table pred =
{
	SET_ATOM(NONOP, 0, "nil"),
	SET_ATOM(NONOP, 0, "n"),
	SET_ATOM(XFY, 1000, ","),
	SET_ATOM(XF, 1200, "."),
	SET_ATOM(NONOP, 0, ".."),
	SET_ATOM(FX, 1200, "("),
	SET_ATOM(XF, 1201, ")"),
	SET_ATOM(FX, 1200, "["),
	SET_ATOM(XF, 1201, "]"),
	SET_ATOM(FX, 1200, "?-"),
	SET_ATOM(XF, 1200, "?"),
	SET_ATOM(NONOP, 0, "!"),
	SET_ATOM(XF, 1200, "!"),
	SET_ATOM(NONOP, 0, "_"),
	SET_ATOM(NONOP, 0, "end_of_file"),
	SET_ATOM(NONOP, 0, "input"),
	SET_ATOM(NONOP, 0, "output"),
	SET_ATOM(XFX, 1200, ":-"),
	SET_ATOM(FX, 1200, ":-"),
	SET_ATOM(NONOP, 0, "true"),
	SET_ATOM(NONOP, 0, "repeat"),
	SET_ATOM(NONOP, 0, "file"),
	SET_ATOM(FX, 100, "prefix"),
	SET_ATOM(FX, 100, "infix"),
	SET_ATOM(FX, 100, "postfix"),
	SET_PRED(FX, 320, 1, "+", UPLUS),	/* atoms with same name */
	SET_PRED(YFX, 500, 2, "+", PLUS),	/* must appear together */
	SET_PRED(FX, 300, 1, "-", UMINUS),
	SET_PRED(YFX, 500, 2, "-", MINUS),
	SET_ATOM(XFY, 1100, "|"),
	SET_ATOM(NONOP, 0, ": "),
	SET_ATOM(NONOP, 0, "> "),
	SET_ATOM(FX, 1200, "{"),
	SET_ATOM(XF, 1201, "}"),
	SET_ATOM(XFY, 1100, ";"),
	SET_ATOM(XFY, 1050, "->"),
	SET_ATOM(XFY, 800, "&"),
	SET_ATOM(XFX, 700, "="),
	SET_ATOM(XFX, 700, "/="),
	SET_ATOM(XFX, 700, "=.."),
	SET_PRED(YFX, 400, 2, "*", TIMES),
	SET_PRED(YFX, 400, 2, "/", DIV),
	SET_PRED(YFX, 400, 2, "mod", MOD),
	SET_PRED(XFY, 350, 2, "^", POW),
	END_MARK
};



	/* atoms which C must refer to should be together at start of table */

atom	*nil		= &(pred[0]),
	*no		= &(pred[1]),
	*_comma		= &(pred[2]),
	*_dot		= &(pred[3]),
	*_dot_dot	= &(pred[4]),
	*_lpren		= &(pred[5]),
	*_rpren		= &(pred[6]),
	*_lbrac		= &(pred[7]),
	*_rbrac		= &(pred[8]),
	*_query		= &(pred[9]),
	*_question	= &(pred[10]),
	*_cut		= &(pred[11]),
	*_bang		= &(pred[12]),
	*anon		= &(pred[13]),
	*_eof		= &(pred[14]),
	*_input		= &(pred[15]),
	*_output	= &(pred[16]),
	*_neck		= &(pred[17]),
	*_command	= &(pred[18]),
	*_true		= &(pred[19]),
	*_repeat	= &(pred[20]),
	*_file		= &(pred[21]),
	*_prefix	= &(pred[22]),
	*_infix		= &(pred[23]),
	*_postfix	= &(pred[24]),
	*_uplus		= &(pred[25]),
	*_plus		= &(pred[26]),
	*_uminus	= &(pred[27]),
	*_minus		= &(pred[28]),
	*_bar		= &(pred[29]),
	*init_prompt	= &(pred[30]),
	*prompt_string	= &(pred[30]),	/* same as init_prompt */
	*read_prompt	= &(pred[31]),
	*_lbrace	= &(pred[32]),
	*_rbrace	= &(pred[33]);

integer *stack_int;

var _1 = {VAR, 0, &pred[6]};
var _2 = {VAR, 1, &pred[6]};

clause *rep_cl;


extern atom_table
	p_IO,
	p_access,
	p_bag,
	p_basic,
	p_behave,
	p_clause,
	p_files,
	p_meta,
	p_unix;

setup()
{
	extern clause *create();

	add_atoms(pred);
	add_atoms(p_IO);
	add_atoms(p_access);
	add_atoms(p_bag);
	add_atoms(p_basic);
	add_atoms(p_behave);
	add_atoms(p_clause);
	add_atoms(p_files);
	add_atoms(p_meta);
	add_atoms(p_unix);

	stack_int = (integer *) new(INT);
	rep_cl = create(0, 0);
	_repeat -> val = rep_cl;
	_repeat -> lib = TRUE;
	rep_cl -> goal[0] = (pval)(_repeat);
	rep_cl -> rest = rep_cl;
}
