(*$M-,R-,X+*)
 
(*  THIS MODULE INITIALIZES THE OP CODE TABLE FOR THE INTEL-8086 ASSEMBLER  *)
 
(*$L-,I+ASSMHD.PAS*)
(*$L+*)
 
PROCEDURE INITTAB;
 
   (* INITIALIZE THE OPCODE NAMES *)
 
   PROCEDURE SETOP (O:INSTR; N:NAME; T:INSTP; H,H1:TWOCHAR);
 
      FUNCTION DCM(H:TWOCHAR) : CHAR ; 
	 VAR  I1,I2 : INTEGER;
	 BEGIN
	 IF H[1] IN ['A' .. 'F'] THEN I1 := ORD(H[1]) - ORD('A') + 10
				 ELSE I1 := ORD(H[1]) - ORD('0');
	 IF H[2] IN ['A' .. 'F'] THEN I2 := ORD(H[2]) - ORD('A') + 10
				 ELSE I2 := ORD(H[2]) - ORD('0');
	 I1 := I1*16 + I2;
         DCM := CHR(I1)
	 END;  
 
      BEGIN   (*  SETOP  *)
      WITH OPERATIONS[O] DO
        BEGIN
        OPNAME:=N;  OPTYP:=T;  OPCODE[2]:=DCM(H1); OPCODE[1]:=DCM(H)
        END;
      END;   (*  OF SETOP  *)
 
   PROCEDURE INIT1;
   BEGIN
   SETOP(MOV, 'MOV   ',CMPLX,'88','00');
   SETOP(PUSH,'PUSH  ',CMPLX,'FF','30');
   SETOP(POP ,'POP   ',CMPLX,'8F','00');
   SETOP(XCHG,'XCHG  ',CMPLX,'86','00');
   SETOP(INN ,'IN    ',CMPLX,'EC','00');
   SETOP(INW ,'INW   ',CMPLX,'ED','00');
   SETOP(OUT ,'OUT   ',CMPLX,'EE','00');
   SETOP(OUTW,'OUTW  ',CMPLX,'EF','00');
   SETOP(XLAT,'XLAT  ',NOOPS,'D7','00');
   SETOP(LEA ,'LEA   ',ONEMOP,'8D','00');
   SETOP(LDS ,'LDS   ',ONEMOP,'C5','00');
   SETOP(LES ,'LES   ',ONEMOP,'C4','00');
   SETOP(LAHF,'LAHF  ',NOOPS,'9F','00');
   SETOP(SAHF,'SAHF  ',NOOPS,'9E','00');
   SETOP(PUSHF,'PUSHF ',NOOPS,'9C','00');
   SETOP(POPF,'POPF  ',NOOPS,'9D','00');
   SETOP(NOP ,'NOP   ',NOOPS,'90','00');
   END;
 
PROCEDURE INIT3;
   BEGIN
   SETOP(ADD ,'ADD   ',CMPLX,'00','00');
   SETOP(ADC ,'ADC   ',CMPLX,'10','10');
   SETOP(INC ,'INC   ',CMPLX,'FE','00');
   SETOP(AAA ,'AAA   ',NOOPS,'37','00');
   SETOP(DAA ,'DAA   ',NOOPS,'27','00');
   SETOP(SUB ,'SUB   ',CMPLX,'28','28');
   SETOP(SBB ,'SBB   ',CMPLX,'18','18');
   SETOP(DEC ,'DEC   ',CMPLX,'FE','08');
   SETOP(NEG ,'NEG   ',ONEMOP,'F6','18');
   SETOP(CMP ,'CMP   ',CMPLX,'38','38');
   SETOP(AAS ,'AAS   ',NOOPS,'3F','00');
   SETOP(DAS ,'DAS   ',NOOPS,'2F','00');
   SETOP(MUL ,'MUL   ',ONEMOP,'F6','20');
   SETOP(IMUL,'IMUL  ',ONEMOP,'F6','28');
   SETOP(AAM ,'AAM   ',TWOB,'D4','0A');
   SETOP(DIVV,'DIV   ',ONEMOP,'F6','30');
   SETOP(IDIV,'IDIV  ',ONEMOP,'F6','38');
   SETOP(AAD ,'AAD   ',TWOB,'D5','0A');
   SETOP(CBW ,'CBW   ',NOOPS,'98','00');
   SETOP(CWD ,'CWD   ',NOOPS,'99','00');
   SETOP(NOTT,'NOT   ',ONEMOP,'F6','10');
   END;
 
PROCEDURE INIT5;
   BEGIN
   SETOP(SHL ,'SHL   ',ONEMOP,'D0','20');
   SETOP(SAL ,'SAL   ',ONEMOP,'D0','20');
   SETOP(SHR ,'SHR   ',ONEMOP,'D0','28');
   SETOP(SAR ,'SAR   ',ONEMOP,'D0','38');
   SETOP(ROL ,'ROL   ',ONEMOP,'D0','00');
   SETOP(ROR ,'ROR   ',ONEMOP,'D0','08');
   SETOP(RCL ,'RCL   ',ONEMOP,'D0','10');
   SETOP(RCR ,'RCR   ',ONEMOP,'D0','18');
   SETOP(ANDD,'AND   ',CMPLX,'20','20');
   SETOP(TEST,'TEST  ',CMPLX,'84','00');
   SETOP(ORR ,'OR    ',CMPLX,'08','08');
   SETOP(XOR ,'XOR   ',CMPLX,'30','30');
   SETOP(REP ,'REP   ',NOOPS,'F2','00');
   SETOP(REPZ,'REPZ  ',NOOPS,'F3','00');
   SETOP(MOVB,'MOVB  ',NOOPS,'A4','00');
   SETOP(MOVW,'MOVW  ',NOOPS,'A5','00');
   SETOP(CMPB,'CMPB  ',NOOPS,'A6','00');
   SETOP(CMPW,'CMPW  ',NOOPS,'A7','00');
   SETOP(SCAB,'SCAB  ',NOOPS,'AE','00');
   SETOP(SCAW,'SCAW  ',NOOPS,'AF','00');
   SETOP(LODB,'LODB  ',NOOPS,'AC','00');
   SETOP(LODW,'LODW  ',NOOPS,'AD','00');
   SETOP(STOB,'STOB  ',NOOPS,'AA','00');
   SETOP(STOW ,'STOW  ',NOOPS,'AB','00');
   END;
 
   PROCEDURE INIT2;
   BEGIN
   SETOP(CALL ,'CALL  ',CMPLX,'E8','10');
   SETOP(JMP  ,'JMP   ',CMPLX,'E9','20');
   SETOP(RET  ,'RET   ',CMPLX,'C3','00');
   SETOP(RETI ,'RETI  ',CMPLX,'CB','00');
   SETOP(JE   ,'JE    ',DISPL,'74','00');
   SETOP(JZ   ,'JZ    ',DISPL,'74','00');
   SETOP(JL   ,'JL    ',DISPL,'7C','00');
   SETOP(JNGE ,'JNGE  ',DISPL,'7C','00');
   SETOP(JLE  ,'JLE   ',DISPL,'7E','00');
   SETOP(JNG  ,'JNG   ',DISPL,'7E','00');
   SETOP(JB   ,'JB    ',DISPL,'72','00');
   SETOP(JNAE ,'JNAE  ',DISPL,'72','00');
   SETOP(JC   ,'JC    ',DISPL,'72','00');
   SETOP(JBE  ,'JBE   ',DISPL,'76','00');
   SETOP(JNA  ,'JNA   ',DISPL,'76','00');
   SETOP(JP   ,'JP    ',DISPL,'7A','00');
   SETOP(JPE  ,'JPE   ',DISPL,'7A','00');
   SETOP(JO   ,'JO    ',DISPL,'70','00');
   SETOP(JS   ,'JS    ',DISPL,'78','00');
   SETOP(JNE  ,'JNE   ',DISPL,'75','00');
   SETOP(JNZ  ,'JNZ   ',DISPL,'75','00');
   SETOP(JNL  ,'JNL   ',DISPL,'7D','00');
   SETOP(JGE  ,'JGE   ',DISPL,'7D','00');
   SETOP(JNLE ,'JNLE  ',DISPL,'7F','00');
   SETOP(JG   ,'JG    ',DISPL,'7F','00');
   SETOP(JNB  ,'JNB   ',DISPL,'73','00');
   SETOP(JNC  ,'JNC   ',DISPL,'73','00');
   END;
 
PROCEDURE INIT4;
   BEGIN
   SETOP(JAE  ,'JAE   ',DISPL,'73','00');
   SETOP(JNBE ,'JNBE  ',DISPL,'77','00');
   SETOP(JA   ,'JA    ',DISPL,'77','00');
   SETOP(JNP  ,'JNP   ',DISPL,'7B','00');
   SETOP(JPO  ,'JPO   ',DISPL,'7B','00');
   SETOP(JNO  ,'JNO   ',DISPL,'71','00');
   SETOP(JNS  ,'JNS   ',DISPL,'79','00');
   SETOP(LOOPP,'LOOP  ',DISPL,'E2','00');
   SETOP(LOOPZ,'LOOPZ ',DISPL,'E1','00');
   SETOP(LOOPE,'LOOPE ',DISPL,'E1','00');
   SETOP(LOOPNZ,'LOOPNZ',DISPL,'E0','00');
   SETOP(LOOPNE,'LOOPNE',DISPL,'E0','00');
   SETOP(JCXZ ,'JCXZ  ',DISPL,'E3','00');
   SETOP(INTT ,'INT   ',CMPLX,'CC','00');
   SETOP(INTO ,'INTO  ',NOOPS,'CE','00');
   SETOP(IRET ,'IRET  ',NOOPS,'CF','00');
   SETOP(CLC  ,'CLC   ',NOOPS,'F8','00');
   SETOP(CMC  ,'CMC   ',NOOPS,'F5','00');
   SETOP(STC  ,'STC   ',NOOPS,'F9','00');
   SETOP(CLD  ,'CLD   ',NOOPS,'FC','00');
   SETOP(STD  ,'STD   ',NOOPS,'FD','00');
   SETOP(CLI  ,'CLI   ',NOOPS,'FA','00');
   SETOP(STI  ,'STI   ',NOOPS,'FB','00');
   SETOP(EQW  ,'EQW   ',PSEUD,'00','00');
   SETOP(EQU  ,'EQU   ',PSEUD,'00','00');
   END;
 
PROCEDURE INIT6;
   BEGIN
   SETOP(HLT  ,'HLT   ',NOOPS,'F4','00');
   SETOP(WAIT ,'WAIT  ',NOOPS,'9B','00');
   SETOP(ESC  ,'ESC   ',ONEMOP,'D8','00');
   SETOP(LOCK ,'LOCK  ',NOOPS,'F0','00');
   SETOP(DB   ,'DB    ',PSEUD,'00','00');
   SETOP(DSB  ,'DSB   ',PSEUD,'00','00');
   SETOP(DSW  ,'DSW   ',PSEUD,'00','00');
   SETOP(DW   ,'DW    ',PSEUD,'00','00');
   SETOP(ELSEE,'ELSE  ',PSEUD,'00','00');
   SETOP(EJECT,'EJECT ',PSEUD,'00','00');
   SETOP(ENDIF,'ENDIF ',PSEUD,'00','00');
   SETOP(ENDD ,'END   ',PSEUD,'00','00');
   SETOP(IFF  ,'IF    ',PSEUD,'00','00');
   SETOP(ORG  ,'ORG   ',PSEUD,'00','00');
   SETOP(SETT ,'SET   ',PSEUD,'00','00');
   SETOP(TITL ,'TITLE ',PSEUD,'00','00');
   SETOP(STITL,'SBTTL ',PSEUD,'00','00');
   SETOP(LON  ,'LISTON',PSEUD,'00','00');
   SETOP(LOFF ,'LSTOFF',PSEUD,'00','00');
   SETOP(GEN  ,'MACLST',PSEUD,'00','00');
   SETOP(NOG  ,'MACOFF',PSEUD,'00','00');
   SETOP(DSEG ,'DSEG  ',PSEUD,'00','00');
   SETOP(CSEG ,'CSEG  ',PSEUD,'00','00');
   SETOP(GLBL ,'GLOBAL',PSEUD,'00','00');
   SETOP(XTRNL,'EXTERN',PSEUD,'00','00');
   SETOP(MCR  ,'MACRO ',PSEUD,'00','00');
   END;
 
 
   BEGIN  (*  INITTAB  *)
   INIT1;
   INIT3;
   INIT2;
   INIT4;
   INIT5;
   INIT6;
   END.
