
#include	"sysdef.h"

#include	"scerrd.h"
#include	"tempio.h"

#define	CR	015
#define	FF	014
#define	LF	012
#define	SPACE	040
#define	TAB	011

extern	int verbose ;

csearch(lun)
int lun ;
{
	extern int lowlim,highlim,*maxline,target ;
	extern int kblun,p_lines ;
	extern struct textline *textpointer();
	struct textline *tp ;
	register int i,match,patlen ;
	char s[64] ;

	match = 0 ;
	if ( ( patlen = getoldpat(s) ) != 0 )
	  then	{
		for (i=lowlim; i <=highlim && testcc() == 0; i++) {
		  tp = textpointer(i) ;
		  if ( instr(tp->c,tp->len,s,patlen) != 0 )
		    then {
			match = 1 ;
			echoline(lun,tp,i) ;
			}
		  }
		}
	if ( match == 0 ) then tederror("Search failure") ;
	return( match ) ;
}



creplace(lun)
int lun ;
{
	extern int lowlim,highlim,*maxline,target ;
	extern int kblun,p_lines ;
	extern struct textline *textpointer();
	struct textline *tp ;
	register int i,oldlen ;
	int lmatch,match,newlen,offset,txtlen ;
	register char *cp ;
	char olds[64],news[64] ;

	match = 0 ;
	if ( (oldlen=getoldpat(olds)) != 0 && (newlen=getnewpat(news)) >= 0 )
	  then	{
		for (i=lowlim; i <=highlim && testcc() == 0; i++) {
		  lmatch = 0 ;
		  tp = textpointer(i) ;
		  txtlen = tp->len ;
		  offset = 0 ;
		  cp = tp->c ;
		  while ((offset=instr(cp,txtlen,olds,oldlen))!=0) {
			txtmod() ;
			lmatch++ ;
			match++ ;
			cp = &cp[--offset] ;
			txtlen -= offset ;
			remove(cp,txtlen,oldlen) ;
			txtlen -= oldlen ;
			insert(cp,txtlen,news,newlen) ;
			txtlen += newlen ;
			tp->len = tp->len + newlen - oldlen ;
			cp = &cp[newlen] ;
			txtlen = txtlen - newlen ;
			}
		  if ( lmatch != 0 ) then echoline(lun,tp,i) ;
		  }
		}
	if ( match == 0 )
	  then tederror("Search failure") ;
	return( match ) ;
}


cappend(lun)
{
	extern struct textline *textpointer() ;
	extern struct textline inline ;
	extern int kblun,lowlim,highlim,maxlen ;
	register struct textline *tp ;
	register int lineno ;
	int kbin,status ;

	status = sys_normal ;
	kbin = ( lun == kblun ) ;
	for (lineno=lowlim; lineno<=highlim && status==sys_normal; lineno++ ) {
		tp = textpointer(lineno) ;
		if ( kbin )
		  then	{
			sxprintf(inline.c,"%6d )",lineno) ;
			inline.len = app(inline.c,8,tp->c,tp->len) ;
			inline.c[ cvtstring(inline.c,inline.len,04) ] = 0 ;
			if ((inline.len=getprm(inline.c,inline.c,maxlen))==0)
			  then status = 0 ;
			  else status = sys_normal ;
			}
		  else	status = getline(lun,inline.c,&inline.len) ;
		if ( status == sys_normal )
		  then	{
			tp->len = app(tp->c,tp->len,inline.c,inline.len) ;
			if (!kbin) then echoline(kblun,tp,lineno) ;
			}
		}
}



	
cduplicate()
{
	extern struct textline inline ;
	extern struct textline *textpointer() ;
	register struct textline *tp ;
	extern int kblun,lowlim,highlim ;
	register int i ;

	for (i=lowlim; i<=highlim; i++ ) {
		tp = textpointer(i) ;
		scopy(inline.c,tp->c,tp->len) ;
		inline.len = tp->len ;
		tp->len = app(tp->c,tp->len,inline.c,inline.len) ;
		echoline(kblun,tp,i) ;
		}
}


ctxtappend()
{
	extern struct textline *textpointer() ;
	register struct textline *tp ;
	extern int kblun,lowlim,highlim,cmdlun ;
	register int lineno ;
	char s[100] ;
	int size ;

	size = getprm(s,"Text to append ? ",100) ;
	if ( size && (size=cvtstring(s,size,04)) !=0 )
	  then	{
		s[size++] = CR ;
		s[size++] = LF ;
		for ( lineno=lowlim; lineno<=highlim; lineno++ ) {
			tp = textpointer(lineno) ;
			tp->len = app(tp->c,tp->len,s,size) ;
			if ( verbose ) then echoline(kblun,tp,lineno) ;
			}
		}
}
	



ctrim()
{
	extern int kblun,lowlim,highlim,target ;
	extern struct textline *textpointer() ;
	register struct textline *tp ;
	register int lineno,len ;

	if ( target == 0 ) then target = 80 ;

	for (lineno=lowlim; lineno <= highlim; lineno++ ) {
		tp = textpointer(lineno) ;
		if ( tp->len > target ) then tp->len = target ;
		len = cvtstring(tp->c,tp->len,0204) ;
		txtmod() ;
		tp->c[len++] = CR ;
		tp->c[len++] = LF ;
		tp->len = len ;
		if ( verbose) then echoline(kblun,tp,lineno) ;
	}
}





static app(s1,len1,s2,len2)
char *s1 ;
register char *s2 ;
int len1,len2 ;
{
	register int i ;
	register char *dp ;
	int len ;

	txtmod() ;
	len = cvtstring(s1,len1,04) ;
	dp = &s1[len] ;
	for (i=len2; i>0; i--) *dp++ = *s2++ ;
	return(len+len2) ;
}



static insert(s,size,new,newsize)
char *s,*new ;
int size,newsize ;
{
	register char *cp,*dp ;
	register int i ;

	cp = &s[size] ;
	dp = &s[size+newsize] ;
	for ( i=size; i > 0 ; i-- ) *(--dp) = *(--cp) ;
	cp = new ;
	dp = s ;
	for ( i=newsize; i > 0 ; i-- ) *dp++ = *cp++ ;
}

static remove(s,size,amount)
char *s ;
int size,amount ;
{
	register char *cp, *dp ;
	register int i ;

	cp = s ;
	dp = &s[amount] ;
	for ( i=size-amount; i>0; i-- ) *cp++ = *dp++ ;
}



static getoldpat(s)
char *s ;
{
	extern struct textline *textpointer();
	struct textline *tp ;
	int size,status ;
	extern int cmdlun,target ;
	register int i ;
	register char *cp,*dp ;

	if ( target )
	  then	{
		tp = textpointer(target) ;
		cp = tp->c ;
		dp = s ;
		for (i=tp->len; i>0; i--) *dp++ = *cp++ ;
		return(cvtstring(s,tp->len,04)) ;
		}
	  else	{
		if ( (size=getprm(s,"Search pattern ? ",64)) != 0 )
		  then	return( cvtstring(s,size,04) ) ;
		  else	return( status ) ;
		}
}		


static getnewpat(s)
register char *s ;
{
	register int status ;
	int size ;

	if ( (size=getprm(s,"Replacement text ? ",64)) != 0 )
	  then	return( cvtstring(s,size,04) ) ;
	  else	return( -1 ) ;
}

static echoline(lun,tp,lineno)
struct textline *tp ;
int lineno,lun ;
{
	extern int p_lines,kblun ;

	if (p_lines && lun == kblun) then plinenumber(lineno) ;
	putline(lun,tp->c,tp->len) ;

}


static scopy(d,s,len)
int len ;
register char *d,*s ;
{
	register int i ;
	for (i=len; i>0 ;i--) *d++ = *s++ ;
}
