DELETE MULTI__LOGY__LR;
REDEFINE PLOT MULTI__LOGY__LR
!
! This plot modified by B. Z. Lederman from MULTI__LOGY
!
!	It is used in exactly the same way, but it plots the Linear
!	Regression (best fit) line rather than connecting the data points.
!
DECLARE X__REF, X__LENGTH, X__MIN, X__MAX
DECLARE Y__REF, Y__LENGTH, Y__MIN__VALUE, Y__MAX__VALUE, D__LABEL
DECLARE I,J,K,N, COUNT, MX, WIDTH
DECLARE VECTOR X, Y1, Y2, Y3, Y__MIN, Y__MAX, Y__MX, COLOR
DECLARE STRING VECTOR Y__LABEL, CHR
ENTRY 0 (X__LABEL : STRING,
         LABEL__1 : STRING,
         LABEL__2 : STRING,
         LABEL__3 : STRING)
BEGIN
    PLOT HOUSEKEEP 0
    SET_SEGMENT 0
    PRINT 'L(A2)'
    PRINT 'L"5"00FF8181818181FF'
    PRINT 'L"6"0018244281422418'
    PRINT 'L"0"00FF814242242418'
    OUTPUT_SEGMENT 0
    SET_SEGMENT 1
    X__REF = 100    Y__REF = 360    X__LENGTH = 600    Y__LENGTH = 350
    PLOT LABEL 0 (X__REF, Y__REF, X__LENGTH, Y__LENGTH, X__LABEL, D__LABEL)
    CHR(1) = '6'    COLOR(1) = 1   Y__LABEL(1) = LABEL__1
    CHR(2) = '5'    COLOR(2) = 2   Y__LABEL(2) = LABEL__2
    CHR(3) = '0'    COLOR(3) = 3   Y__LABEL(3) = LABEL__3
    INCR I OVER Y__LABEL
        IF LENGTH(Y__LABEL(I)) NE 0 THEN
            COUNT = COUNT + 1
END
ENTRY 1 (X__VALUE, Y1__VALUE, Y2__VALUE, Y3__VALUE)
BEGIN
    X(SIZE(X)+1) = X__VALUE
    Y1(SIZE(Y1)+1) = LOG (Y1__VALUE)		! Note LOG value
    Y2(SIZE(Y2)+1) = LOG (Y2__VALUE)
    Y3(SIZE(Y3)+1) = LOG (Y3__VALUE)
END
ENTRY 2
BEGIN
    Y__MIN(1) = MIN(Y1)   Y__MIN(2) = MIN(Y2)   Y__MIN(3) = MIN(Y3)
    Y__MAX(1) = MAX(Y1)   Y__MAX(2) = MAX(Y2)   Y__MAX(3) = MAX(Y3)
    Y__MIN__VALUE = MIN(Y__MIN)
    Y__MAX__VALUE = MAX(Y__MAX)
    PLOT LABEL 5 (Y__MIN__VALUE, Y__MAX__VALUE)	! vice 3
    X__MIN = MIN(X)
    X__MAX = MAX(X)
    PLOT LABEL 2 (X__MIN, X__MAX, X)
    PRINT 'T(BA2S[8,16])'
    N = 0
    IF COUNT GE 1 THEN
        PLOT MULTI__LOGY__LR 3 (Y1)
    IF COUNT GE 2 THEN
        PLOT MULTI__LOGY__LR 3 (Y2)
    IF COUNT GE 3 THEN
        PLOT MULTI__LOGY__LR 3 (Y3)
    PRINT 'T(E)'
    WIDTH = X__LENGTH / 30
    Y__MX(30) = 0
    INCR I OVER X
    BEGIN
        Y__MIN(1) = Y1(I)   Y__MIN(2) = Y2(I)   Y__MIN(3) = Y3(I)
        MX = MIN(Y__MIN)
        J = ((X(I) - X__REF) / WIDTH) + 1
        Y__MX(J) = 1000
	IF Y__MX(J) GT MX THEN
            Y__MX(J) = MX
    END
    INCR I OVER Y__MX
        IF (I NE 1) AND (Y__MX(I) EQ 0) THEN
            Y__MX(I) = Y__MX(I -1)
    OUTPUT_SEGMENT 1
    PLOT LEGEND 4 (X__REF,Y__REF,X__LENGTH,Y__LENGTH,WIDTH,Y__MX,CHR,COLOR,Y__LABEL)
    PLOT HOUSEKEEP 2
END
ENTRY 3 (ARRAY : VECTOR)
BEGIN
    PLOT LABEL 8 (ARRAY)
    N = N + 1
    PRINT 'W(RI', CVT(COLOR(N)), ')'
    PLOT LABEL 7
    INCR I OVER X
    BEGIN
        PRINT 'p', LXY(X(I)-4,ARRAY(I)-10), 't', QUOTE(CHR(N))
    END
    PRINT 'W(V)'
END
END__PLOT
