.;[1,6]PROCESS.CMD
.;
.;	Create files with specific system accounting data and reports.
.;	B. Z. Lederman 26-Mar-84
.;		       13-Apr-84 brought up to date
.;			7-May-84 add default exit for batch processing
.;			5-Sep-84 Fixes for 2.1
.;	Kitty Bethe	5-Oct-84 Keep 5 versions of everything, dont
.;				 delete acntrn.sys
.;	B. Z. Lederman 31-Oct-84 Put most deletes back, the space is needed.
.;	B. Z. Lederman 28-Nov-84 Test for proper ACNTRN.SYS in case it
.;					has already been purged.
.;				 <FILERR> now compares to symbol <SUCCES>
.;				 Allow input on command line
.;
.;	INPUTS: none required, but will use $QUIET if defined.
.;
.;	If invoked with data on command line, will use first parameter
.;		as a file spec, and the second parameter (if present)
.;		as the date, or will prompt for missing file/date
.;
.;	Example: @PROCESS ACNTRN.SYS;1 01-JAN-84

	.ENABLE SUBSTITUTION
	.ENABLE TIMEOUT
	.ENABLE DECIMAL
	.SETF DELACC
	.IFDF $QUIET .ENABLE QUIET

.;				Install utilities if not already installed.

@[1,7]RMSINS
	.IFNINS SRT INS $SORTID
	.IFNINS SRT INS $SORT
	.IFNINS DTR INS $DTR
	.SETS $SYSID "Z"
.;					Get the system I.D.
	.TESTFILE LB:[1,2]SYSID.CMD
	.IF <FILERR> = <SUCCES> @LB:[1,2]SYSID
.;					Remember where we are.
	.SETS OUIC <UIC>
.;					We want to be in a particular account.

SET /UIC=[1,6]

.;				See if command file was invoked with input
	.IF P1 EQ "" .GOTO NOIN

.;				Use input as file spec
	.SETS INFILE P1
.;				If there was no date specified, ask for one
	.IF P2 EQ "" .GOTO ASK2

.;				Use input as date, then go test it.
	.SETS DAT P2
	.GOTO SET

.NOIN:

.;				See if there is a last file used message.

	.TESTFILE [1,6]LASTFIL.ACC
	.IF <FILERR> = <SUCCES> .GOTO LSTFIL

.;	No file information saved, ask for it.
.;	If we do not get a real answer, quit (assume batch processor)

.ASK1:
	.SETS DEF "X.X;1"
	.ASKS [3:32:DEF:60S] INFILE Source file
	.IFT <TIMOUT> .EXIT <WARNIN>
	.IFF <DEFAUL> .GOTO ASK2
	.DISABLE QUIET
;
;	There is no default answer: you must enter the name
;	of a file containing system accounting data. Usually
;	it will be [1,6]ACNTRN.SYS;n
;
	.IFDF $QUIET .ENABLE QUIET
	.GOTO ASK1
.;					Get the date for the file name.

.ASK2:
	.SETS DEF "01-JAN-81"
	.ASKS [8:9:DEF:60S] DAT Traffic date
	.IFT <TIMOUT> .EXIT <WARNIN>
	.IFF <DEFAUL> .GOTO SET
	.DISABLE QUIET
;
;	There is no default answer. You must enter a
;	traffic date of the type shown.
;
	.IFDF $QUIET .ENABLE QUIET
	.GOTO ASK2
.SET:
.;					Strip out the date.
	.PARSE DAT "-" T1 T2 T3 A
	.GOTO SHOW

.;	We have a last file used file, use it for name and date.

.LSTFIL:
	.OPENR #1 [1,6]LASTFIL.ACC;-1
	.SETS A " "			! need to create variable
.;				Skip directory header, then get real data.
	.READ #1 A
	.READ #1 A
.;					Separate file name.
	.PARSE A " " INFILE T3
.;					Remove leading spaces.
	.SETN COUNT 0
.L1:
	.INC COUNT
	.IF COUNT > 100 .GOTO BADFIL
	.PARSE T3 " " B T3
	.IF B = "" .GOTO L1
.;					Got to a date, remove data.
	.PARSE B "-" T1 T2 T3 A
	.CLOSE #1
	.ENABLE QUIET
	.SETT DELACC
.;				Convert the information to a readable form.

.SHOW:
	.DISABLE QUIET
.;				does the input file really exist?
	.TESTFILE 'INFILE'
	.IF <FILERR> = <SUCCES> .GOTO SHOW2	.; if yes, continue
;
;	The specified input file 'INFILE' does not exist.

	.IF P1 <> "" .GOTO 10$

;	It may have been purged.

.10$:

;

PIP LASTFIL.ACC;-1/DE/NM

	.EXIT	<WARNIN>

.SHOW2:

SHOW ACCOUNTING/DATATRIEVE:'INFILE' ACNTRN.SEQ
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT

	.ENABLE QUIET
.;				Clean up files.

PIP ACNTRN.SEQ/TR/NM
PIP ACNTRN.SEQ/PU/NM


.;	Split out the device data from today's accounting file.

	.DISABLE QUIET

SRT DEVDAT.SEQ = ACNTRN.SEQ, DEVICE/SF/SS
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT

	.ENABLE QUIET
PIP DEVDAT.SEQ/TR

.;		Don't need to keep a lot of old data: summaries are retained.

PIP DEVDAT.SEQ/PU/NM

.;					Ditto for task reports.
	.DISABLE QUIET

SRT TASK.SEQ = ACNTRN.SEQ, TASK/SF/SS
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
	.ENABLE QUIET

PIP TASK.SEQ/TR
PIP TASK.SEQ/PU/NM

.;					Now Datatrieve can summarize data.
	.DISABLE QUIET
;
;	You may ignore any messages of the form
;
;	"Proceeding to report unsorted records" or
;	"Attempt to divide by zero"
;
;	Do not type Control-C while DTR is running!
;
						.; device summaries
DTR :DEVICE-SUM-CREATE
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
						.; selected task stats
DTR :REDUCED-TASK-CREATE
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT
						.; all tasks, corrected names
DTR :CORRECT_TASK_SUM
	.IF <SUCCES> NE <EXSTAT>&7 .GOTO EREXT

	.ENABLE QUIET
.;					Create a file name from ID and date
	.SETS FILE $SYSID+T1+T2+T3

.;			Everything worked, can get rid of temporary file

PIP ACNTRN.SEQ;*/DE/NM

.;	Clean up files and re-name files for reference.

	.IFNDF $QUIET .DISABLE QUIET

PIP 'FILE'.DEV/NV/RE/NM = DEVSUM.SEQ
PIP 'FILE'.TAS/NV/RE/NM = TSKSUM.SEQ
PIP 'FILE'.ATS/NV/RE/NM = ALLTSK.SEQ

PIP 'INFILE'/DE/NM

.;PIP ACNTRN.SYS/PU:5

	.IFT DELACC PIP LASTFIL.ACC;-1/DE/NM

;
;	to transfer the accounting statistics to the PRO use
;
;	@[1,7]PROXFR
;
;	and transfer the files
;
;	'FILE'.TAS (or 'FILE'.ATS) and 'FILE'.DEV
;
;	The programs TASKS and DEVICES can graph the data
;	from these files.
;
	.IFDF $QUIET .ENABLE QUIET
.;					Put us back were we were.

SET /UIC='OUIC'

.;					Processing concludes successfully.
	.EXIT <SUCCES>

.;					Encountered an error during processing.

.EREXT:
	.DISABLE QUIET
;
;	A task had an unsuccessful exit status while
;	processing system accounting data.
;
	.EXIT <ERROR>

.;					Something wrong with stored file.

.BADFIL:
	.DISABLE QUIET
;
;	Improper format encountered in [1,6]LASTFIL.ACC,
;	please correct.
;
	.EXIT <ERROR>
