100	 ! Daily calibration log for Varian and AECL linac
	 ! Modified 2/78 to allow entering date (defaults to date of run)
	 ! Modified 12/80 to check input values - D.R.S.
	 ! Modified April 83 to include AECL factors		F.Borger
	 ! Mod Oct 83 to log time, print t-p correction factor	F.Borger
	 ! Mod Nov 85 to change to task group 21		F.Borger
	 ! Also as of Nov 85 all victoreen values are strictly
	 ! Empirical comparisons since TG21 ingnores vics	F.Borger
150 DIM D(10),V(10),V$[6](6),U$[10]V,F(8,6),C(10),R(10,10),R1(10)
160 DIM M(10),R2(10),A$[10]V,X$[10]V,T$[5],M$[8](8),B$[1]
170 DIM S1$[10]V,S2$[10]V,D1(10)
210 X$=DAT$(0):T$=TIM$(0)
220 ! old victoreen data as of 3/25/77 no longer used
221 ! new victoreen data empirical values for 6MV only.
222 ! old farmer still 5.466*.993 = NX=5.428
223 ! keithley November 85 Madison value of NX=4.702
231 ! 6 mev x - old a,b, new a,b, farmer, keithley (not yet changed)
232 DATA 1.090,0.934,0.949,0.958,5.048,4.350
233 ! 10 mev x - old a,b, new a,b, farmer, keithley
234 DATA 0.000,0.000,0.000,0.000,5.519,4.718
235 ! 18 mev x - old a,b, new a,b, farmer, keithley
236 DATA 0.000,0.000,0.000,0.000,5.776,5.026
237 ! 6 mev e - old a,b, new a,b, farmer, keithley
238 DATA 0.000,0.000,0.000,0.000,5.004,4.360
239 ! 9 mev e - old a,b, new a,b, farmer, keithley
240 DATA 0.000,0.000,0.000,0.000,4.883,4.253
241 ! 13 mev e - old a,b, new a,b, farmer, keithley
242 DATA 0.000,0.000,0.000,0.000,4.814,4.193
243 ! 17 mev e - old a,b, new a,b, farmer, keithley
244 DATA 0.000,0.000,0.000,0.000,4.725,4.116
245 ! 20 mev e - old a,b, new a,b, farmer, keithley
246 DATA 0.000,0.000,0.000,0.000,4.649,4.050
270 FOR I=1 TO 8
275 FOR J=1 TO 6 : READ F(I,J) : NEXT J
276 PRINT F(I,J)
279 NEXT I
280 V$(1)="Old A ":V$(2)="Old B ":V$(3)="New A ":V$(4)="New B ":V$(5)="Farmer":V$(6)="Keith."
282 M$(1)=" 6 MEV X" : M$(2)="10 MEV X" : M$(3)="18 MEV X"
284 M$(4)=" 6 MEV E" : M$(5)=" 9 MEV E" : M$(6)="13 MEV E" : M$(7)="17 MEV E" : M$(8)="20 MEV E"
285 DF=1			: ! assume calibration is not for today
290 INPUT "Date of calibration (mm/dd/yy)  (return means today) ",A$ :
	 IF LEN(A$)=0 THEN A$=DAT$(0) : DF=0 : GOTO 380
		 ELSE DA=DCEN(A$) :
			 IF DA<0 THEN 360
				 ELSE A$=DAT$(DA) : GOTO 380
360 PRINT "You must enter date as mm/dd/yy (month/day/year) please re-enter" :
	 GOTO 290
380 PRINT "Calibration calculated for ";A$;" done on ";X$;" at ";T$
385 IF DF=1 THEN  LET T$="00:00"	: ! put in null time if not a "live" calib
390 FOR JJ=1 TO 3 : PRINT M$(JJ);" (";FRMT$(JJ,2);")	";
391 PRINT M$(JJ+3);" (";FRMT$(JJ+3,2);")"
392 NEXT JJ
393 PRINT "		";M$(7);" ( 7)"
394 PRINT "		";M$(8);" ( 8)"
400 INPUT "           ";M0 :
	 IF M0<1 OR M0>8 THEN  PRINT "Answer out or range";CHR$(7) : GOTO 390
410 PRINT "Number of chambers";TAB(45);
420 INPUT N :
	 IF N<1 OR N>10 THEN  PRINT "Answer out of range";CHR$(7) : GOTO 410
430 PRINT "Atmospheric pressure, room temperature deg C";TAB(45);
440 INPUT P,T :
	 IF P<700 OR P>800 THEN  PRINT "Pressure out of range";CHR$(7) : GOTO 430
	 ELSE  IF T<18 OR T>30 THEN  PRINT "Temperature out of range";CHR$(7) : GOTO 430
445 PC=P*.00016339*T
446 TP=(T+273)/295*760/(P-PC)
447 PRINT "Corrected pressure = ";FRMT$(P-PC,5,1);"  T-P factor = ";FRMT$(TP,5,3)
450 FOR I=1 TO N
460 PRINT "(Chamber ID =) New A(3),New B(4),Farmer(5),Keith.(6)"
470 PRINT "Chamber I.D.";TAB(45);
480 INPUT V(I) :
	 IF V(I)<3 OR V(I)>6 THEN  PRINT "Answer out of range";CHR$(7) : GOTO 460
490 PRINT "Number of readings, number of counts set";TAB(45);
500 INPUT M(I),C(I) :
	 IF M(I)<1 OR M(I)>10 THEN 
		 PRINT "Number of readings out of range";CHR$(7) : GOTO 490
	 ELSE  IF C(I)<=0 OR C(I)>400 THEN 
		 PRINT "Number of counts out of range";CHR$(7) : GOTO 490
510 R1(0)=0
520 FOR J=1 TO M(I)
530 PRINT "Scale reading";TAB(45);
540 INPUT R(I,J) :
	 IF R(I,J)<=0 OR R(I,J)>250 THEN 
		 PRINT "Scale reading out of range";CHR$(7) : GOTO 530
550 R1(J)=R1(J-1)+R(I,J)
560 NEXT J
570 R2(I)=R1(J)/M(I)
580 P1=P*.00016339*T
590 D(I)=R2(I)*F(M0,V(I))*((T+273)/295)*(760/(P-P1))
600 D1(I)=D(I)/C(I)
605 PRINT TAB(21);"Calibration factor=";TAB(45);F(M0,V(I))
610 PRINT TAB(30);"Rad/count=";TAB(45);FRMT$(D1(I),6,3)
615 SET  UPPER  ON 
620 INPUT "Log this data (Yes) or restart (No) ",B$ :
	 IF B$="Y" THEN 650
	 ELSE  IF B$="N" THEN 290
	 ELSE  PRINT "please answer 'Yes' or 'No'" : GOTO 620
650 PRINT #4,A$;T$;M$(M0);" ";V$(V(I));P,T,D1(I)
660 NEXT I
670 CLOSE 4
680 PRINT "All done" 
690 EXIT 
