
#include	"sysdef.h"


/*	SCDUMP.C	formatted screen dump			*/
/*								*/
/*	28-Sep-84  14:15:05  Brian Nelson			*/
/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/

#define	then
#define	CR	015
#define	LF	012
#define	TAB	011

extern int read_only ;

vtdump(format)
int format ;
{
	extern int *curline,chposition,curposition,*maxline,page_size[] ;
	extern int termtype,worklength ;
	extern CHAR workbuffer[] ;

	int done,i,lpt,nlines,size ;
	register CHAR *cp,*tp ;
	register int ch ;
	CHAR txtbuffer[20], fmtbuffer[80] ;
	int oldcurline,oldchposition,oldcurposition ;

	oldcurline = *curline ;
	oldchposition = chposition ;
	oldcurposition = curposition ;
	creset() ;
	home() ;
	sclear() ;
	nlines = page_size[termtype] ;

	lpt = 0 ;
	scunloadline() ;
	scloadline() ;
	done = ( (ch = nextch(&lpt)) == -1 ) ;

	while ( nlines-- > 0 && done == 0 ) {
		size = 12 ;
		cp = fmtbuffer ;
		for (i=50; i>0; i-- ) *cp++ = ' ' ;
		tp = txtbuffer ;
		for (i=12; i>0; i-- ) *tp++ = ' ' ;
		cp = fmtbuffer ;
		tp = txtbuffer ;

		while ( size-- > 0 && done == 0 ) {
			if ( ch < 040 )
			  then *tp++ = 040 ;
			  else *tp++ = ch ;
			if ( format == 0 )
			  then	cvtoct(cp,ch) ;
			  else	cvthex(cp,ch) ;
			cp++ ; cp++ ;cp++ ;cp++ ;
			done = ( (ch = nextch(&lpt)) == -1 ) ;
			}
		*tp++ = CR ;
		*tp++ = LF ;
		*tp   = 0 ;
		putbin(fmtbuffer,50) ;
		putbin(txtbuffer,0 ) ;
	}
	*curline = oldcurline ;
	chposition = oldchposition ;
	curposition = oldcurposition ;
	lgetbin(fmtbuffer,"Type a carriage return to continue ? ") ;
	scloadline() ;
	ref_screen() ;
}



static nextch(lpt)
int *lpt ;
{
	extern int worklength ;
	extern CHAR workbuffer[] ;
	extern int *curline,*maxline ;

	if ( read_only ) then return(-1) ;
	if ( *lpt < worklength )
	  then	return( workbuffer[(*lpt)++] ) ;
	  else	{
		if ( ++(*curline) >= *maxline )
		  then	{
			(*curline)-- ;
			return( -1 ) ;
			}
		  else	{
			scloadline() ;
			*lpt = 0 ;
			if ( read_only )
			  then return(-1) ;
			  else return( workbuffer[(*lpt)++] ) ;
			}
		}
}


static cvtoct(s,ch)
CHAR *s ;
register int ch ;
{
	register CHAR *cp ;

	ch &= 0377 ;
	cp = s ;
	*cp++ = ( ( ch & 0377) / 0100 ) + '0' ;
	*cp++ = ( ( ch & 077 ) / 010  ) + '0' ;
	*cp++ = ( ch % 010 ) + '0' ;
	*cp++ = ' ' ;
}


static CHAR hexchars[] = "0123456789ABCDEF" ;

static cvthex(s,ch)
CHAR *s ;
register int ch ;
{
	register CHAR *cp ;

	ch &= 0377 ;
	cp = s ;
	*cp++ = hexchars[ ch / 020 ] ;
	*cp++ = hexchars[ ch & 017 ] ;
	*cp++ = ' ' ;
	*cp++ = ' ' ;
}

