; File: VIRTDISK.CMD    Last Edit: 3-OCT-1986 11:34:07 
;
; Command file to compile and build Virtual Disk package for 
; RSX-11M-PLUS V3.0.  The package is composed of the VD driver,
; AVD allocate virtual disk utility and DVD deallocate virtual disk
; utility.
;
; The following sysgen files are required:
;
;   LB:[1,1]EXEMC.MLB
;   LB:[1,1]EXELIB.OLB
;   LB:[1,1]SYSLIB.OLB
;   LB:[1,24]MCR.OLB
;   LB:[1,24]PIPUTL.OLB
;   LB:[1,54]RSX11M.STB
;   LB:[11,10]RSXMC.MAC
;
; They must be present on the disk assigned to LB: and in the indictate UFDs.
;
;
.enable substitution
;
.; See if we are running in DCL
.;
.sets curcli <cli>
.if curcli ne "MCR" mcr set /cli=ti:mcr
.;

; create VDDRV and VDTAB for VD loadable driver

PIP VDDRV.MAC=VDSYM.MAC,VDPRE.MAC,VDDRI.MAC
.if <exstat> gt 1 .goto badend
PIP VDTAB.MAC=VDSYM.MAC,VDPRE.MAC,VDTBL.MAC
.if <exstat> gt 1 .goto badend

; You now have VDDRV.MAC and VDTAB.MAC which can be used to build the
; VD loadable driver.  If you are doing a new sysgen,
; you can put VDDRV.MAC and VDTAB.MAC in [11,10] of sysgen work
; disk and identify VD as a user written driver at sysgen time.
; Then sysgen will take care of compiling and building and including
; the driver in the system image.  If you already did the sysgen,
; you will still put VDDRV.MAC and VDTAB.MAC in [11,10] of the sysgen
; work disk.  Then you will go and run a partial sysgen, selecting the
; section that allows you to build an additional loadable driver.
;
; You may build the driver now if you wish
;
.ask resp Do you want to build the VD driver
.iff resp .goto nodrv

MAC VDDRV,VDDRV/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,-
SY:'<uic>'VDDRV
.if <exstat> gt 1 .goto badend

MAC VDTAB,VDTAB/-SP=LB:[1,1]EXEMC/ML,[11,10]RSXMC/PA:1,-
SY:'<uic>'VDTAB
.if <exstat> gt 1 .goto badend

;
; The TKB file specifies partition size for DRVPAR.  You may need
; to modify them for your system.  Use this even if you do not have
; room in DRVPAR, since you can always LOAd VD: with the /PAR=GEN/HIGH
; modifiers to put driver in GEN.
;
TKB @VDDRV.TKB
.if <exstat> gt 1 .goto badend

.nodrv:

;
; Now we build AVD and DVD.  These are privledged tasks and have not
; been modified to use the new V3.0 vectored exec, so they must be 
; rebuilt for each unique sysgen. 

MAC AVD,AVD/-SP/CR=LB:[1,1]EXEMC/ML,LB:[11,10]RSXMC/PA:1,-
SY:'<uic>'PIPMAC/PA:1,VDSYM,VDPRE,AVD
.if <exstat> gt 1 .goto badend
;
; building AVD, multiple defines MSGSTR,PURE$D in ERRPRT and MSGSTR in FCSERR
;  are normal warnings.
;
TKB @AVD.TKB
.if <exstat> gt 2 .goto badend
.;
.; do DVD
.;
MAC DVD,DVD/-SP/CR=LB:[1,1]EXEMC/ML,LB:[11,10]RSXMC/PA:1,-
SY:'<uic>'PIPMAC/PA:1,VDSYM,VDPRE,DVD
.if <exstat> gt 1 .goto badend
;
; building DVD, multiple defines MSGSTR,PURE$D in ERRPRT and MSGSTR in FCSERR
;  are normal warnings.
;
TKB @DVD.TKB
.if <exstat> gt 2 .goto badend
.;
; 
; VD driver sources (VDDRV.MAC and VDTAB.MAC) are created, and
;    AVD and DVD assembled and built okay.  
;
.sett good
.goto done

.badend:
;
; VD driver assemble or build failed 
;
.setf good
.goto done

.done:
.;
.; Set back CLI to starting CLI if it was not MCR
.;
.if curcli ne "MCR" set /cli=ti:'curcli'
.;

.iff good .exit 4
.exit 1
