#include <cx.h>
#include <stdio.h>
#include <timbuf.h>
#include "clock.h"

#define DEFAULT -1

/********************************************************
* file name: setime.c
* author: C Staatse
* version: 1.0
* description: set system time from TCU-50 
* changes: 
*
********************************************************/

int $$narg =1;

main()
{
	struct timbuf time;
	FILE *fp, *fopen();
	int *iospace,month,year,
		monday,hrmin,secdat,status
		;
	extern $IOPAGE
		;


/*********************************************************
* next instruction required to map task to io page
*********************************************************/

	iospace = &$IOPAGE;





/*********************************************************
*  start of code 
*********************************************************/


	iospace = CLKSTAT;
	if( !(*iospace & CLKRDY)){
		printf("Clock Not Ready\n");
		exitt();
		}
/*********************************************************
* read clock twice to get data. Once could be junk
*********************************************************/

	/* get the month/day data */

	iospace = CLOCK;
	while( (monday = *iospace) != *iospace)
		;

	/* get the hour/minute data */
	iospace++;
	while( (hrmin = *iospace) != *iospace)
		;

	/* get the second data */
	iospace++;
	while( (secdat = *iospace) != *iospace)
		;

/*********************************************************
* fill in structure 
*********************************************************/

	time.g_timo = (monday & MONMASK) >> 8;
	time.g_tida = (monday & DAYMASK);
	time.g_tihr = (hrmin & HRMASK) >> 8;
	time.g_timi = hrmin & MINMASK;
	time.g_tisc = secdat & SECMASK;
	time.g_tict = DEFAULT;		/* Tick in second */
	time.g_ticp = DEFAULT;		/* Tix per second */

/*********************************************************
* read old data from file "clock.dat"
*********************************************************/

	if((fp = fopen("clock.dat","r")) == NULL)
		{
		printf("Can't find 'clock.dat'\n");
		do
			{
			printf("Enter current year ");
			scanf("%d",&year);
			}
			while(year < 85 || year > 99);
		}
	else {
		fscanf(fp,"%d %d",&year,&month);
		if(month == 12 && time.g_timo == 1) /* changed year */
			year++;
		fclose(fp);
		}

	time.g_tiyr = year;		/* Year, since 1900 */

	if((fp = fopen("clock.dat","w")) == NULL)
		{
		printf("Could not open new 'clock.dat'\n");
		exit();
		}
	else
		{
		fprintf(fp,"%d %d",year,time.g_timo);
		fclose(fp);
		}


/*********************************************************
* now call stim() to set the system time
*********************************************************/



	status = stim(&time,0);
	if(status < 0){
		printf("** Error Setting Time **\n");
		}
}
