
#include	"sysdef.h"

/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/
/*	The information in this  software  is  subject  to	*/
/*	change  without notice and should not be construed	*/
/*	as a commitment by the author.				*/
/*								*/
/*								*/

/*	SCDEF.C

	Screen control definitions for doing mundane things like
	clearing the screen, moving left and right and so forth.
	Sorry,  but this was done a lot cleaner in the origional
	Macro-11  version  with the  use of fairly sophisticated
	macros. This way is ok, but a lot harder to modify as in


	define	s$up			; move up in display one line

	vtdef	ansi	,esc,'[,'A	; heath (zenith) h19 and z19
	vtdef	mbee	,esc,'A		; microbee (behive)
	vtdef	vt100	,esc,'[,'A	; dec vt100 and lookalikes
	vtdef	vt52	,esc,'A		; the old vt52 and such
	vtdef	tel912	,'k&37		; televideo 912 ala Mike Horton
	

*/
 


#include	"scterm.h"
#define	then


#if	RSX+RSTS+RT11+POS
#else
extern int termtype ;
#define	gterm() termtype
#endif


static
char _cmdleadin[]={
		'\033'		,	/* tty				*/
		'\033'		,	/* ansi				*/
		'\033'		,	/* vt100			*/
		'\033'		,	/* vt220			*/
		'\033'			/* other			*/
		 } ;


static
char *s_132[]	={			/* set terminal into 132 col	*/
		""		,	/* null entry for hardcopy tty	*/
		""		,	/* null entry for ANSI terminal	*/
		"\033[?3h"	,	/* for vt100's			*/
		"\033[?3h"	,	/* for vt220's			*/
		""			/* other			*/
		} ;

static
char *s_80[]	={			/* set terminal into 80 col	*/
		""		,	/* null entry for hardcopy tty	*/
		""		,	/* null entry for ANSI terminal	*/
		"\033[?3l"	,	/* for vt100's			*/
		"\033[?3l"	,	/* for vt220's			*/
		""			/* other			*/
		} ;

static	
char *s_up[]	={			/* move up in the disply 1 line	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[A"	,	/* for ANSI (ie, H19) terminals	*/
		"\033[A"	,	/* for the real terminal, VT100	*/
		"\033[A"	,	/* for the vt220 types		*/
		""			/* some future type ?		*/
		 } ;
	
static
char *s_down[]	={			/* move down in display one line*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[B"	,	/* ansi				*/
		"\033[B"	,	/* vt100			*/
		"\033[B"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_home[]	={			/* move to relative [1,1]	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[H"	,	/* ansi				*/
		"\033[02;H"	,	/* vt100			*/
		"\033[02;H"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_fclear[]={			/* clear the entire screen	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[2J"	,	/* ansi				*/
		"\033[2J"	,	/* vt100			*/
		"\033[2J"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_clear[]	={			/* clear from current position	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[0J"	,	/* ansi				*/
		"\033[0J"	,	/* vt100			*/
		"\033[0J"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_l24[]	={			/* move to the last column	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[24;01H"	,	/* ansi				*/
		"\033[24;01H"	,	/* vt100			*/
		"\033[24;01H"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_ri[]	={			/* move back and scroll if need	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033M"		,	/* ansi				*/
		"\033M"		,	/* vt100			*/
		"\033[L"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_mid[]	={			/* move to center of last line	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[24;40H"	,	/* ansi				*/
		"\033[24;40H"	,	/* vt100			*/
		"\033[24;40H"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_c60[]	={			/* move to col 60 of last line	*/
		""		,	/* null entry for hardcopy tt's	*/
		"\033[24;60H"	,	/* ansi				*/
		"\033[24;60H"	,	/* vt100			*/
		"\033[24;60H"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *s_kill[]	={			/* delete to the end of line	*/
		""		,	/* null entry for hardcopy ttys	*/
		"\033[K"	,	/* ansi				*/
		"\033[K"	,	/* vt100			*/
		"\033[K"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;		


static
char *s_left[]	={			/* move left one position	*/
		""		,	/* null entry for hardcopy ttys	*/
		"\033[D"	,	/* ansi				*/
		"\033[D"	,	/* vt100			*/
		"\033[D"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;		

static
char *s_right[]	={			/* move right one position	*/
		""		,	/* null entry for hardcopy ttys	*/
		"\033[C"	,	/* ansi				*/
		"\033[C"	,	/* vt100			*/
		"\033[C"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;		


static
char *s_next[]	={			/* next line in display		*/
		""		,	/* null entry for hardcopy ttys	*/
		"\015\012"	,	/* ansi				*/
		"\015\012\012"	,	/* vt100			*/
		"\015\012\012"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;		

/*	special things for the terminal					*/

char *ff_prt[]	={			/* what to print for a form feed*/
		""		,	/* null entry for hardcopy ttys	*/
		"\033[10m^\033[11m",	/* ansi				*/
		"\033[7m\033(0c\033(B\033[0m", /* vt100 (a pain)	*/
		"\033[7m\033(0c\033(B\033[0m", /* vt220 (a pain)	*/
		""			/* some future type ?		*/
		} ;

static
char *rv_on[]	={			/* switch to reverse video	*/
		""		,	/* null entry for hardcopy ttys	*/
		"\033[7m"	,	/* ansi				*/
		"\033[7m"	,	/* vt100			*/
		"\033[7m"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *rv_off[]	={			/* disable reverse video	*/
		""		,	/* null entry for hardcopy ttys	*/
		"\033[0m"	,	/* ansi				*/
		"\033[0m"	,	/* vt100			*/
		"\033[0m"	,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *kp_on[]	={			/* turn keypad mode on (vt100's)*/
		""		,	/* null entry for hardcopy ttys	*/
		""		,	/* ansi				*/
		"\033="		,	/* vt100			*/
		"\033="		,	/* vt220			*/
		""			/* some future type ?		*/
		} ;

static
char *kp_off[]	={			/* turn keypad mode off (vt100)	*/
		""		,	/* null entry for hardcopy ttys	*/
		""		,	/* ansi				*/
		"\033>"		,	/* vt100			*/
		"\033>"		,	/* vt220			*/
		""			/* some future type ?		*/
		} ;


sclear()				/* clear entire screen		*/
{
	home() ;
	skill() ;
}

fclear()
{

	putbin(s_fclear[gterm()],0) ;
}

ceol24()				/* clear bottom line in display	*/
{
	if ( gterm() == _tty )
	  then	putbin("\015\012",0) ;
	  else	{
		movel24() ;
		skill() ;
		movel24() ;
		}
}


movel24()				/* move to start of bottom line	*/
{
	putbin(s_l24[gterm()],0) ;
}


lreverse()
{
	putbin(s_ri[gterm()],0) ;
}


lnext()					/* next line operation		*/
{
	putbin(s_next[gterm()],0) ;
}


skill()					/* clear to the end of display	*/
{
	putbin(s_clear[gterm()],0) ;
}


lkill()					/* erase to the end of the line	*/
{
	putbin(s_kill[gterm()],0) ;
}


cursup()				/* up one line in display	*/
{
	putbin(s_up[gterm()],0) ;
}


cursdown()				/* down one line in the display	*/
{
	putbin(s_down[gterm()],0) ;
}


cursright()				/* over to the right one please	*/
{
	putbin(s_right[gterm()],0) ;
}


cursleft()				/* over to the left one please	*/
{
	putbin(s_left[gterm()],0) ;
}


home()					/* to the home position now	*/
{
	putbin(s_home[gterm()],0) ;
}


ffprint()				/* what to print for a formfeed	*/
{
	putbin(ff_prt[gterm()],0) ;
}


rvon()					/* turn on reverse video ?	*/
{
	putbin(rv_on[gterm()],0) ;
}


rvoff()					/* turn off reverse video ?	*/
{
	putbin(rv_off[gterm()],0) ;
}


kpapplication()				/* turn keypad application mode on */
{
	putbin(kp_on[gterm()],0) ;
}


kpnormal()				/* put keypad back to normal mode  */
{
	putbin(kp_off[gterm()],0) ;
}


set132col()
{
	putbin(s_132[gterm()],0) ;
}

set80col()
{
	putbin(s_80[gterm()],0) ;
}

char cmdleadin()
{
	return( _cmdleadin[gterm()] ) ;
}
