#include	"sysdef"
#include	<smgdef>

#define	MAXMSG	40
static char msg_buffer[MAXMSG][81] ;
static int pbid, vdid ;
int msg_count = 0 ;
static int msg_number = 0 ;

static struct exithandler 
		{ int *nextaddr ;
		  int *myaddr ;
		  int nargs ;
		  int *status_arg ;
		} myhandler ;
static int exit_status ;

setbro_trap()

{
	int flag,status,clrbro_trap(),trapper() ;
	extern int vms_trapper() ;

	myhandler.nextaddr = 0 ;
	myhandler.myaddr = &clrbro_trap ;
	myhandler.nargs = 1 ;
	myhandler.status_arg = &exit_status ;

	flag = 1 ;
	if ( (status=smg$create_pasteboard(&pbid,0,0,0,&flag)) & 1 == 0 )
	  return( status ) ;
	if ( (status=smg$set_broadcast_trapping(&pbid,vms_trapper,0)) & 1 == 0)
	  return( status ) ;
	sys$dclexh(&myhandler) ;
	return(1) ;
}

clrbro_trap()
{
	int flag ;

	smg$set_broadcast_trapping(&pbid,0,0) ;
	smg$delete_pasteboard(&pbid,&flag) ;
}


trapper()
{
	struct dsc { int len ;
		     char *addr ;
		   } msg ;

	char *cp,msg_string[100] ;
	int i,len,ok,status ;

	cp = msg_string ;
	msg.len = 80 ;
	msg.addr = cp ;
	status = smg$get_broadcast_message(&pbid,&msg,&len);
	if ( (status & 1) == 0 ) return( status ) ;
	len &= 0377 ;
	*(cp+len) = 0 ;
	for (ok=0,i=0;i<len;i++)
	  if ( *cp++ > ' ' ) { ok = 1 ; break ; } ;
	if ( ok == 0 ) return(1) ;

	if ( msg_number >= MAXMSG-1 ) msg_number = 0 ;
	if ( msg_count < MAXMSG ) msg_count++ ;
	strcpy(msg_buffer[msg_number++],msg_string) ;
	ceol24() ;
	putbin(msg_string,0) ;
	msgcount_update() ;
	goback() ;
	return(1) ;
}

scbrodisplay()
{
	int i ;
	char junk[80] ;

	if ( msg_count == 0 ) {
	  ceol24() ;
	  putbin("No messages present",0) ;
	  goback() ;
	  return(0) ;
	} ;

	home() ;
	sclear() ;
	scunloadline() ;
	for (i=0; i < msg_count; i++) {
	  putbin(msg_buffer[i],0) ;
	  putbin("\015\012",0) ;
	} ;
	lgetbin(junk,"Type a carriage return to continue ? ") ;
	scloadline() ;
	ref_screen() ;
	goback() ;
}
