
#include	"sysdef.h"

/*	EDSTAR.C						*/
/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/
/*								*/

#include	"scerrd.h"
#include	"edswdf.h"
#define	then
#define	SPACE	040
#define	CR	015
#define	LF	012


#define	NEXT_FAILURE	0
#define	NEXT_OK	1
#define	NEXT_NMF	2
#define	NEXT_CONTROLC	3





edstart()
{
	int size,status ;
	char commandline[80] ;
	register char *cp,*dp ;
	extern int kblun,inlun,*maxline,sys_fnf,stvtedit ;
	extern char *infile[],insource[],infi1[] ;

#if	RSX
	xprintf("\n") ;
#endif
	stvtedit = forcevtedit() ;
	cp = commandline ;
	if (  ( status = getmcrcommand(commandline) ) != 0 )
	  then	{
		commandline[status] = 0 ;
		if ( *cp == 'S' || *cp == 's' ) then stvtedit = 1 ;
		while ( *cp != 0 && *cp != SPACE ) cp++ ;
		while ( *cp != 0 && *cp == SPACE ) cp++ ;
		}
	  else	*cp = 0 ;

	status = sys_normal ;
	if ( *cp == 0 )
	  then	{
		cp = commandline ;
		if ( rstfilename(cp) == 0 )
		  then	{
			size = 0 ;
			while ( status == sys_normal && size == 0 ) {
				xprintf("Input file ? ") ;
				status = getline( kblun,commandline,&size ) ;
				if ( testcc() ) then status = 0 ;
				size = trimjunk(commandline,size) ;
				commandline[size] = 0 ;
				}
			}
		  else	xprintf("Editing previous file %s\n",cp) ;
		}
	if ( status != sys_normal ) then return(0) ;
	dp = infile[0] ;
	while ( *cp != 0 && *cp != '/' ) *dp++ = *cp++ ;
	*dp = 0 ;
	strcpy(insource,infile[0]) ;
	if ( *cp == '/' )
	  then if (doswitches(cp)!=sys_normal) then return(0) ;

	if ( chkfilename(infile[0]) == 0 )
	  then	{
		tederror("Can't parse that filename") ;
		prsys_error() ;
		return(0) ;
		}
	  else if ( iswild( infile[0] ) && flookup( infile[0] ) == 0 )
	   	then	{
			xprintf("No files matching %s\n",infile[0]) ;
			return( 0 ) ;
			}
		else	return(1) ;
}





#define	STS_FATAL	0
#define	STS_NOTFOUND	1
#define	STS_FOUND	2

opennext()
{
	extern struct fswitch inswitch ;
	extern char *infile[], insource[] ;
	extern int  kblun, inlun, dirindex, kblun, restart, waswild ;
	register int status, ok ,res ;
	char s[128],ans[10],*fp ;
	int size ;

	fp = infile[0] ;
	if ( restart )
	  then	{
		xprintf("Input file ? ") ;
		status = getline( kblun,fp,&size ) ;
		if ( status && size && testcc() == 0 )
		  then	{
			size = trimjunk(fp,size) ;
			*(fp+size) = 0 ;
			strcpy(insource,fp) ;
			}
		  else	insource[0] = 0 ;
		}	
	if ( insource[0] == 0 ) then return(0) ;
	if ( (waswild=iswild(insource)) != 0 || isdirectory(insource) )
	  then	{
		while ( (status = donextfile()) == NEXT_NMF ) {
			dirindex = 0 ;
			tederror("No more files. Type QUIT to exit or SWITCH");
			tederror("to change to new input file specification.");
			tederror("") ;
			}
		if ( status != NEXT_OK )
		  then	status = 0 ;
		  else	{
			switch( doopen(fp) ) {
			  case STS_NOTFOUND:
				tederror("Could not open the file") ;
				prsys_error() ;
				status = 0 ;
				break ;
			  case STS_FATAL:
				status = 0 ;
				break ;
			  case STS_FOUND:
				status = 1 ;
				break ;
				}
			}
		}
	  else	{
		insource[0] = 0 ;
		if ( inswitch.create || flookup(fp) == 0 )
		  then	{
			strcpy(s,"Creating ") ;
			strcpy(&s[strlen(s)],fp) ;
			tederror(s) ;
			status = ifl_error(ifl( kblun )) ;
			}
		  else	{
			switch( doopen(fp) ) {
			  case STS_FATAL:
				status = 0 ;
				break ;
			  case STS_FOUND:
				status = 1 ;
				break ;
			  case STS_NOTFOUND:
				tederror("Failed to open the file") ;
				prsys_error() ;
				status = 0 ;
				break ;
				}				
			}
		}
	return( status ) ;
}





#if	VAXVMS

static char *old_source[10] = { 0,0,0,0,0,0,0,0,0,0 };
static char *old_infile[10] = { 0,0,0,0,0,0,0,0,0,0 };
static int dir_level = 0 ;


static donextfile()
{

	extern char *infile[], insource[] ;
	char temp[_FILESIZE+20], *cp, *dp, *fp ;
	extern int dirindex ;
	int vm_base[2], vm_size, res, sts ;

	if ((sts = __donextfile()) == NEXT_OK && isdirectory(infile[0]))
	  then	{
		*( dp = temp ) = 0 ;
		cp = infile[0] ;
		while ( *cp && !( *cp == ']' || *cp == '>' ) ) *dp++ = *cp++ ;
		*dp++ = '.' ;
		if (*cp) cp++ ;
		while ( *cp && *cp != '.' ) *dp++ = *cp++ ;
		*dp = 0 ;
		strcat(dp,"]*.*") ;
		vm_size = _FILESIZE*2 ;
		if (   ( lib$get_vm(&vm_size,&vm_base[0]) & 1 )
		    && ( lib$get_vm(&vm_size,&vm_base[1]) & 1 ) )
		  then {
			old_source[dir_level] = vm_base[0] ;
			old_infile[dir_level] = vm_base[1] ;
			strcpy(old_source[dir_level],insource) ;
			strcpy(old_infile[dir_level++],infile[0]) ;
			} ;
		strcpy(insource,temp) ;
		dirindex = 0 ;
		return( sts = donextfile() ) ;
		}
	  else	{
		if ( sts == NEXT_NMF && dir_level )
		  then	{
			fp = infile[0] ;
			strcpy(insource,old_source[--dir_level]) ;
			strcpy(fp,old_infile[dir_level]) ;
			printf("No more files in subdirectory\n\n") ;
			dirindex = 0 ;
			while (  (res=getnext(fp,insource,dirindex))==NEXT_OK
			       && strcmp(old_infile[dir_level],fp) != 0 )
			   dirindex++ ;
			if ( res == NEXT_OK )
			  then	return( sts = donextfile() ) ;
			  else	{
				dirindex = 0 ;
				return( sts = donextfile() ) ;
				} ;
			}
		  else	return( sts ) ;
		} ;
}
		


#else

static donextfile()
{
	return( __donextfile() ) ;
}

static isdirectory(f)
char *f ;
{
	return(0) ;
}


#endif




	
static __donextfile()
{
	extern char *infile[], insource[] ;
	extern int dirindex, waswild ;
	char ans[10],s[_FILESIZE+10] ;
	register int done,res,status ;

	done = 0 ;
	while ( (done = (testcc() != 0) ? -1:done) == 0 &&
		(res=getnext(infile[0],insource,dirindex)) == NEXT_OK ) {

		strcpy(s,"Edit ") ;
		strcpy(&s[strlen(s)],infile[0]) ;
		strcpy(&s[strlen(s)]," ? ") ;
		status = getprm(ans,s,10) ;
		if ( status == 0 )  then ans[0] = 'Q' ;
		if ( ans[0] == CR ) then ans[0] = 'N' ;
		done = 0 ;
		switch( tolower(ans[0]) ) {
		  case 'q': done = -1 ;
			    break ;
		  case 'y': done = 1 ;
			    break ;
		  case 'n': dirindex++ ;
			    break ;
		  case 'b': if ( dirindex > 0 ) then dirindex-- ;
			    break ;
		  case 't': dirindex = 0 ;
			    break ;
		  case 's': status=getprm(insource,"Input file ? ",_FILESIZE) ;
			    insource[trimjunk(insource,status)] = 0 ;
			    if ( (waswild=iswild( insource )) == 0 )
				then	{
					strcpy(infile[0],insource) ;
					insource[0] = 0 ;
					done = 1 ;
					}
			    if ( status == 0 )
				then	done = -1 ;
				else dirindex = 0 ;
			    break ;
			}
		}

	if ( res == NEXT_NMF ) then done = 2 ;
	switch(done) {
	  case 2:
		status = NEXT_NMF ;
		break ;
	  case 1:
		status = NEXT_OK ;
		break ;
	  case 0:
		status = NEXT_FAILURE ;
		break ;
	  case -1:
		status = NEXT_CONTROLC ;
		break ;
		}

	return(status) ;
}





#if	RSX
static loading()
{
}
#endif

static doopen(s)
char *s ;
{
	register int openstatus, iflstatus ;
	extern int filesize,infisize,inlun,*maxline ;
	extern int termtype ;
#if	VAXVMS
	extern int loading() ;
#endif

	setmbc() ;
	if ( (openstatus = openfi(s,inlun)) == sys_normal )
	  then	{
		saveprotection() ;
		savefilename(s) ;
		infisize = filesize ;
		termtype = inqtermtype() ;
		settimerast(10,loading) ;
		iflstatus = ifl(inlun) ;
		cantimerast() ;
		closef( inlun ) ;
		clrmbc() ;
		if ( ifl_error(iflstatus) == 0 )
		  then	return( STS_FATAL ) ;
		  else	return( STS_FOUND ) ;
		}
	clrmbc() ;
	return( STS_NOTFOUND ) ;
}


static ifl_error(sts)
int sts ;
{
	if ( sts != sys_normal )
	  then	{
		tederror("?Fatal workfile initialization error") ;
		tederror("?Please check for sufficient free disk space");
		return(0) ;
		}
	  else	return(1) ;
}
		





static doswitches(s)
char *s ;
{
	extern struct fswitch inswitch ;

	inswitch.casexl	= 0 ;
	inswitch.create = 0 ;
	inswitch.journal= 0 ;
	inswitch.recover= 0 ;
	inswitch.tabxl	= 0 ;
	inswitch.page	= 0 ;
	inswitch.casetabxl = 0 ;
	
	while ( *s != 0 ) {
		while ( ! ( *s == 0 || *s == '/' ) ) s++ ;
		if ( *s++ != 0 )
		  then
		    switch (*s++) {
		      case 'c':
		      case 'C': if (*s == 'r' || *s == 'R')
				  then inswitch.create = 1 ;
				  else inswitch.casexl   = 1 ;
				break ;
		      case 'j':
		      case 'J':	inswitch.journal = 1 ;
				break ;
		      case 'p':
		      case 'P':	inswitch.page = getval(s) ;
				xprintf("%d\n",inswitch.page);
				break ;
		      case 'r':
		      case 'R':	inswitch.recover = 1 ;
				break ;
		      case 't':
		      case 'T': inswitch.tabxl = 1 ;
				break ;
		      case 'x':
		      case 'X': inswitch.tabxl = 1 ;
				inswitch.casexl = 1 ;
				inswitch.casetabxl = 1 ;		
				break ;
		      default:	break ;
				}			/* end case	*/
		}					/* end while	*/
	  
	return( sys_normal ) ;
}





static getval(s)
char *s ;
{
	register int res ;
	register char ch ;

	res = 0 ;
	while (*s != 0 && *s++ != ':') ;
	while (*s != 0 && isdigit( (ch = *s++) ) ) res = 10*res + (ch - '0') ;
	return(res) ;
}

