;[1,6]SYSACT.CMD
.;
.;	Create files with specific system accounting data and reports.
.;	B. Z. Lederman 26-Mar-84
.;		       13-Apr-84 brought up to date
.;
.;	INPUTS: none required, but will use $QUIET if defined.
.;
	.ENABLE SUBSTITUTION
	.ENABLE DECIMAL
	.IFDF $QUIET .ENABLE QUIET
.;				need RMS utilities and such
	@[1,7]RMSINS
.;
.;	Just in case RMSINS didn't install DTR and SRT
.;
	.IFNINS SRT INS $SORT
	.IFNINS DTR INS $DTR
	.SETS $SYSID "Z"
.;
.;	get the system I.D.
.;
	.TESTFILE [1,2]SYSID.CMD
	.IF <FILERR> = 1 @[1,2]SYSID
.;
.;	"D" system goofs up
.;
	.IF $SYSID EQ "0" .SETS $SYSID "D"
.;
.;	get the date for the file name
.;
	.SETS DAT <DATE>
	.SETS T1 DAT[1:2]
	.SETS T2 DAT[4:6]
	.SETS T3 DAT[8:9]
.;
.;	create a file name
.;
	.SETS FILE $SYSID+T1+T2+T3
.;
.;	Remember where we are.
.;
	.SETS OUIC <UIC>
.;
.;	We want to be in a particular account.
.;
	SET /UIC=[1,6]
.;
.;	Stop accounting so collected data is written out.
.;
	STOP/ACCOUNTING SCHEDULED_SHUTDOWN
	.WAIT SYSLOG
.;
.;	Convert the information to a readable form.
.;
	SHOW ACCOUNTING/DATATRIEVE:ACNTRN.SYS ACNTRN.SEQ
.;
.;	Clean up files
.;
	PIP ACNTRN.SEQ/TR/NM
	PIP ACNTRN.SEQ/PU/NM
.;
.;	We don't need to keep a lot of old files around.
.;
	PIP ACNTRN.SYS/PU:4/NM
.;
.;	Split out the device data from today's accounting file.
.;
	SRT SY:DEVDAT.SEQ/FO:F:46 = SY:ACNTRN.SEQ/FO:F:120, SY:DEVICE
	PIP SY:DEVDAT.SEQ/TR
.;
.;	Don't need to keep a lot of old data: summaries are retained
.;
	PIP SY:DEVDAT.SEQ/PU:2/NM
.;
.;	Ditto for task reports.
.;
	SRT SY:TASK.SEQ/FO:F:64 = SY:ACNTRN.SEQ/FO:F:120, SY:TASK
	PIP SY:TASK.SEQ/TR
	PIP SY:TASK.SEQ/PU:2/NM
.;
.;	Now Datatrieve can summarize data.
.;
	.DISABLE QUIET
;
;	You may ignore any messages of the form
;
;	"Proceeding to report unsorted records" or
;	"Attempt to divide by zero"
;
;	Do not Control-C while DTR is running!
;
	DTR :DEVICE-SUM-CREATE
	DTR :REDUCED-TASK-CREATE
.;
	.IFDF $QUIET .ENABLE QUIET
.;
.;	Clean up files and re-name files for reference.
.;
	PIP DEVSUM.SEQ/TR/NM, TSKSUM.SEQ
	PIP 'FILE'.DEV/NV/RE/NM = DEVSUM.SEQ
	PIP 'FILE'.TSK/NV/RE/NM = TSKSUM.SEQ
.;
.;	Put us back were we were.
.;
	SET /UIC='OUIC'
/
