	PROGRAM SEE
C
C	ROBERT WATSON
C	CISCO, INC.
C	(918)665-2110
C	4135 S. 100TH E. AVE.
C	TULSA OK 74145
C
C	THIS PROGRAM HAS BEEN DONATED TO THE PUBLIC DOMAIN
C	AND IS NOT TO BE COPYRIGHTED.
C
C
C	THIS PROGRAM DISPLAYS THE TIME, THE NUMBER OF FREE NODES, THE 
C	SIZE OF THE LARGEST HOLE, AND THE ENTRIES IN THE ATL AND MRL ON
C	A VT52 OR VT100.  IT REFRESHES THE SCREEN AUTOMATICALLY AND
C	TIMES OUT ACCORDING TO THE PARAMETERS SET BELOW.  IT CAN BE HALTED
C	AT ANY TIME BY ENTERING ANY PRINTABLE CHARACTER.  UNLIKE DEC'S
C	'SYS', THIS PROGRAM DISPLAYS ANY TIMESHARING TASKS WITH STATUS
C	OF 'MRL', 'MRE', OR 'MRR' AS BEING IN THE MRL.
C
C
C       MOD BY F.BORGER TO WORK WITH SOROC INSTEAD OF VT52
C	AND INCLUDE TI IDENTIFICATION, ALSO UPDATE TASK LIST
C	EACH SECOND, ONLY RE-WRITE TASKS IF THEY MOVED IN THE LIST
C
C	WHEN THE LARGEST HOLE DROPS BELOW THIS VALUE, THE PROGRAM RINGS
C	THE BELL ONCE EVERYTIME THE LARGEST HOLE SIZE IS UPDATED.
C
	PARAMETER	WELL = 100
C
C	WHEN IT DROPS BELOW THIS VALUE, THE BELL RINGS THREE TIMES FOR
C	EVERY UPDATE.
C
	PARAMETER	SICK = 50
C
C	WHEN IT DROPS BELOW THIS VALUE, THE PROGRAM DISPLAYS A MESSAGE
C	AND EXITS.
C
	PARAMETER	DYING = 25
C
C	THIS VALUE IS THE NUMBER OF SECONDS BETWEEN UPDATES OF THE TIME,
C	NODES, AND LARGEST HOLE.
C
	PARAMETER	SEC = 1
C
C	THIS VALUE IS THE NUMBER OF TIMES THE TIME, NODES, AND HOLE ARE
C	UPDATED FOR EVERY TIME THE ATL AND MRL ARE UPDATED.
C
	PARAMETER	TOP = 1
C
C	THIS VALUE IS THE NUMBER OF TIMES THAT THE ATL AND MRL UPDATE
C	BEFORE THE PROGRAM TIMES OUT.
C
C	PARAMETER	TIMOUT = 1000
C
	INTEGER*2	IATL(201),	IMRL(121),	INOD
	INTEGER*2	OLDATL(201),	OLDMRL(121)
	INTEGER*2	IHOL,		ISTAT(2),	IPRM(6)
	INTEGER*2	SFSMC,		TFTMO,		SFRDF
	INTEGER*2	TINAM
	BYTE		TITLE(17),	TIM(12),	TNOD(11)
	BYTE		THOL(18),	ANOD(7),	AHOL(7)
	BYTE		TATL(8),	TMRL(8),	NAM(16)
	BYTE		ESCDN(2),	CLR(4),		B
	BYTE		FIRST,		BSTAT(2),	ESDEL(2)
	BYTE		GOTMRL,		NONE(14),	ESCLF(2)
	BYTE		TRMCHR(8),	BELL(7),	UNDER(25)
	BYTE		ESDES(2),	END(4),		TIBYT(2)
	BYTE		TRMRES(8),	SET52(5),	SET100(2)
	EQUIVALENCE	(ISTAT(1),BSTAT)
	EQUIVALENCE	(ISTAT(1),STAT)
	EQUIVALENCE	(TINAM,TIBYT(1))
	DATA	ICNT	/0/
	DATA	FIRST	/.TRUE./
	DATA	TITLE	/"33,'Y',"40,"52,'S','Y','S','T','E','M',' ',
	1		 'S','T','A','T','U','S'/
	DATA	TIM	/"33,'Y',"40,"101,8*'X'/
	DATA	TNOD	/"33,'Y',"42,"52,'N','O','D','E','S',' ','='/
	DATA	THOL	/"33,'Y',"42,"101,'L','A','R','G','E','S','T',
	1		 ' ','H','O','L','E',' ','='/
	DATA	ANOD	/"33,'Y',"42,"62,3*'X'/
	DATA	AHOL	/"33,'Y',"42,"120,3*'X'/
	DATA	TATL	/"33,'Y',"44,"40,'A','T','L',':'/
	DATA	TMRL	/"33,'Y',"57,"40,'M','R','L',':'/
	DATA	ESCLF	/"12,"0/
	DATA	NAM	/"33,'Y',"0,"0,12*'X'/
	DATA	ESCDN	/"33,'B'/
	DATA	CLR	/"33,'H',"33,'J'/
	DATA	ESDEL	/"33,'K'/
	DATA	ESDES	/"33,'J'/
	DATA	B	/' '/
	DATA	NONE	/"33,'Y',"61,"40,'N','O',' ','E','N','T','R',
	1		 'I','E','S'/
C	24=TC.ACR	35=TC.ESQ	7=TC.RAT	44=TC.HLD
	DATA	TRMCHR	/"24,"0,"35,"1,"7,"1,"44,"0/
	DATA	TRMRES	/"24,"1,"35,"0,"7,"2,"44,"1/
	DATA	BELL	/"33,'Y',"40,"40,7,7,7/
	DATA	UNDER	/"33,'Y',"63,"40,'S','Y','S','T','E','M',' ',
	1		 'G','O','I','N','G',' ','U','N','D','E','R',
	2		 7,7,7/
	DATA	END	/"33,'Y',"65,"40/
	DATA	SFSMC	/"2440/
	DATA	IOWLB	/"400/
	DATA	TFTMO	/"1220/
	DATA	SFRDF	/"2460/
	DATA	SET52	/"33,"133,'?','2',"154/
	DATA	SET100	/"33,'<'/
C
C	GET MCR SO WE RECALL MCR ON EXIT
C
	CALL GETMCR (IATL)
C
C	SET MULTIPLE TERMINAL CHARACTERISTICS:
C	NO CARRIAGE RETURN
C	TERMINAL REQUIRES ESCAPE SEQUENCE SUPPORT
C	DEFERRED PROCESSING OF READAHEAD
C	NOT IN HOLD SCREEN MODE
C
	CALL GETADR (IPRM(1), TRMCHR)
	IPRM(2) = 8
	CALL WTQIO (SFSMC, 1, 16, , ISTAT, IPRM, IDS)
C	SET TERMINAL TO VT52 MODE ON VT100
	CALL GETADR (IPRM(1), SET52)
	IPRM(2) = 5
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
C
C	BUILD BASIC SCREEN
C
	CALL GETADR (IPRM(1), CLR)
	IPRM(2) = 4
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), TITLE)
	IPRM(2) = 17
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), TNOD)
	IPRM(2) = 11
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), THOL)
	IPRM(2) = 18
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), TATL)
	IPRM(2) = 8
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), TMRL)
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
C
C	UPDATE TIME, NODES, AND HOLE
C
100	DO 300 I = 1, TOP
	CALL TIME (TIM(5))
	CALL HOLE (INOD, IHOL)
	INOD = INOD / 16
	IHOL = IHOL / 16
	IF (IHOL .GE. WELL) GO TO 190
	CALL GETADR (IPRM(1), BELL)
	IF (IHOL .GE. SICK) GO TO 150
	IF (IHOL .LT. DYING) GO TO 1450
	IPRM(2) = 7
	GO TO 160
150	IPRM(2) = 5
160	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
190	ENCODE (3, 200, ANOD(5)) INOD
	ENCODE (3, 200, AHOL(5)) IHOL
200	FORMAT (I3)
	CALL GETADR (IPRM(1), TIM)
	IPRM(2) = 12
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), ANOD)
	IPRM(2) = 7
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), AHOL)
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM ,IDS)
	IF (FIRST) GO TO 400
C
C	READ WITH TIMOUT TO TERMINAL, SEE IF USER HAS REQUESTED
C	TERMINATION, OR IF WE HAVE TIMED OUT
C
	CALL GETADR (IPRM(1), B)
	IPRM(2) = 1
	IPRM(3) = 0	!TIMOUT IN 0 TIME UNITS
	CALL WTQIO (TFTMO, 1, 16, , ISTAT, IPRM, IDS)
	IF (B .NE. ' ') GO TO 1500
C	IF (ICNT .GT. TIMOUT) GO TO 1500
	CALL WAIT (SEC, 2, N)
300	CONTINUE
C
C	GET TASK INFORMATION
C
400	FIRST = .FALSE.
	ICNT = ICNT + 1
	CALL GETSYS (IATL, IMRL)
C
C	UPDATE ATL
C
	CALL GETADR (IPRM(1), NAM)
	IPRM(2) = 15
	NAM(3) = "46
	NAM(4) = "40
C	NAM(5-10) RECEIVE TASK NAME
	NAM(11) = "40
C	NAM(12,13,14,15) RECEIVE TASK TI NAME & NUMBER
	NAM(16)= "72
	DO 600 J = 1, 199, 4
	IF (IATL(J) .EQ. -1) GO TO 700
	CALL R50ASC (6, IATL(J), NAM(5))
	TINAM=IATL(J+2)
	NAM(12)=TIBYT(1)
	NAM(13)=TIBYT(2)
	IHGH=IATL(J+3)/8
	ILOW=IATL(J+3)-8*IHGH
	NAM(14)=IHGH+48
	NAM(15)=ILOW+48
	IF (NAM(4) .LE. "145) GO TO 500
	NAM(3) = NAM(3) + 1
	NAM(4) = "40
C
C	DON'T UPDATE POSITION IF SAME TASK AND TI
C
500	NOMAT=0
	DO 525 I=1,4
525	IF (IATL(J+I-1).NE.OLDATL(J+I-1)) NOMAT=1
	IF (NOMAT.EQ.0) GOTO 550
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
550	NAM(4) = NAM(4) + 13
	DO 575 I=1,4
575	OLDATL(J+I-1)=IATL(J+I-1)
600	CONTINUE
	GO TO 1450
C
C	CLEAR REST OF ATL AREA
C	BUT FIRST RE-DO LAST ENTRY SO ERASE WORKS CORRECTLY
C
700	NAM(4)=NAM(4) - 13
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), ESDEL)
C
C	ERASE REST OF THIS LINE
C
	IPRM(2) = 2
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
C
C	MOVE TO START OF THIS LINE
C
	CALL GETADR (IPRM(1), NAM)
	IPRM(2) = 4
	NAM(4) = "40
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
C
C	AND MOVE DOWN ONE LINE
C
	IPRM(2) = 2
	DO 900 L = NAM(3), "54
	CALL GETADR (IPRM(1), ESCDN)
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), ESDEL)
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
900	CONTINUE
C
C	UPDATE MRL
C
1000	GOTMRL = .FALSE.
	CALL GETADR (IPRM(1), NAM)
	IPRM(2) = 15
	NAM(3) = "61
	NAM(4) = "40
	DO 1200 M = 1, 119, 4
	IF (IMRL(M) .EQ. -1) GO TO 1300
	GOTMRL = .TRUE.
	CALL R50ASC (6, IMRL(M), NAM(5))
	TINAM=IMRL(M+2)
	NAM(12)=TIBYT(1)
	NAM(13)=TIBYT(2)
	IHGH=IMRL(M+3)/8
	ILOW=IMRL(M+3)-8*IHGH
	NAM(14)=IHGH+48
	NAM(15)=ILOW+48
	IF (NAM(4) .LE. "145) GO TO 1100
	NAM(3) = NAM(3) + 1
	NAM(4) = "40
C
C	DON'T UPDATE POSITION IF SAME TASK AND TI
C
1100	NOMAT=0
	DO 1125 I=1,4
1125	IF (IMRL(M+I-1).NE.OLDMRL(M+I-1)) NOMAT=1
	IF (NOMAT.EQ.0) GOTO 1150
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
1150	NAM(4) = NAM(4) + 13
	DO 1175 I=1,4
1175	OLDMRL(M+I-1)=IMRL(M+I-1)
1200	CONTINUE
	GO TO 1450
1300	IF (GOTMRL) GO TO 1400
	CALL GETADR (IPRM(1), NONE)
	IPRM(2) = 14
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
C
C	CLEAR REST OF MRL AREA
C	FIRST MAKE SURE CURSOR IS AT END (IF WE DIDN'T CHANGE)
C	JUST WRITE LAST NAME AGAIN
C
1400	NAM(4) = NAM(4) - 13
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), ESDES)
	IPRM(2) = 2
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	GO TO 100
C
C	SYSTEM IS DRASTICALLY OVERLOADED... GET OUT FAST
C
1450	CALL GETADR (IPRM(1), UNDER)
	IPRM(2) = 25
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	GO TO 1700
C
C	POSITION CURSOR NEAR BOTTOM OF SCREEN, RESTORE DEFAULT
C	TERMINAL CHARACTERISTICS
C
1500	CALL GETADR (IPRM(1), END)
	IPRM(2) = 4
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
C	RESET TERMINAL
1700	CALL GETADR (IPRM(1), SET100)
	IPRM(2) = 2
	CALL WTQIO (IOWLB, 1, 16, , ISTAT, IPRM, IDS)
	CALL GETADR (IPRM(1), TRMRES)
	IPRM(2) = 8
	CALL WTQIO (SFSMC, 1, 16, , ISTAT, IPRM, IDS)
	END
