/*
 * \USR\C\VIDEO.H
 *
 *	Copyright (C) 1984 by Larry Campbell, 73 Concord St., Maynard Mass.
 *
 *	This software may be freely copied and disseminated for
 *	noncommercial purposes, if and only if this entire copyright
 *	statement and notice is included intact.  This software, and
 *	the information contained herein, may not be used for commercial
 *	purposes without my prior written permission.
 *
 * Video hacking definitions
 *
 */

#define MENU_CLEAR_SCREEN 2		/* clear screen before drawing menu */
#define MENU_ANIMATE 4			/* draw menu like window shade */
#define MENU_POST_CLEAR 8		/* clear menu from screen when done */
#define MENU_ACTIVE_MODE 16		/* menu actively calls semantic 
					   routines, quits when "done" entry
					   selected */
#define MENU_ONCE_ONLY 32		/* call just one routine then quit */

#define DONE -1

struct menu_item
    {
    char *name;
    int (*handler) ();
    };

#define WAIT_FOR_ANY_KEY while (kbdin () < 0)

struct saved_video
    {
    struct saved_video *next;
#ifdef DEBUG
    int magic;
#endif
    int length;
    int row;
    int col;
    char *text;
    char *attributes;
    };
