C
	SUBROUTINE ANGTB	! Vers AUG81
C
C	Revised by: Bernard Warshaw
C		    Hadassa University Hospital
C		    Jerusalem, Israel.
C
C	This subroutine evaluates and returns the
C	complex function PEXP(i), i=0,1,...,N-1;
C	also known as W(ik)=exp(2*pi*j*(i*k)/N).
C	k=1 for fundamental approximation.
C	N=LSTP (number of frames in study).
C
C	Change the dimensions of PEXP to equal at least
C	Half the number of frames in your study.
C	The dimension of PEX is ALWAYS twice that of PEXP.
C	
	DIMENSION PEXP(24),PEX(48)
	COMPLEX PEXP,CMFL(512)
	EQUIVALENCE(PEX,PEXP)
C
	COMMON /TABS/ LSTP,PEXP,CMFL
	DATA PI/3.1415927/
C
	K=1			! Assume fundamental.
	A=FLOAT(LSTP)
	P=(2.*PI*K)/A
	NF=LSTP/2
	DO 10 I=1,NF		! W(i+NF)=-W(i); i=integer
	XI=(I-1)*P		! Begin with i=0.
	PEX(2*I-1)=COS(XI)	! Store alternately in
 10	PEX(2*I)=SIN(XI)	! complex locations PEXP.
C
	RETURN
	END
