/*
 *			s k i p . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	skip	Move Past Next Whitespace
index		move past next Whitespace

synopsis

	int
	skip(ccp)
	 char **ccp;	/* pointer to buffer pointer */

description

	Function to move past NEXT whitespace encountered (if any)
	and update the current buffer pointer to the position of next
	nonwhite character. We may be either in the previous data
	or in the whitespace but there must be at least one whitespace
	character - which may be the character currently pointed to -
	before the next data.
	Return ERROR if a \0 or \n is encountered instead, as the
	field expected may be an optional field. Return NOERROR
	otherwise.

bugs

author

	Machiavelli Systems

#endif

#include "symbols.h"



int	skip(cpp)

char	**cpp;

{
int	retval;

while ((!iswhite(**cpp)) && (**cpp != '\0')) 
	{
	(*cpp)++;	/* go past any non-whites */
	};

if (**cpp == '\0')	/* in case end of string is upon us..*/ 
	{
	retval = ERROR;
	return(retval);
	};
while (iswhite(**cpp) && 
	((retval = (((**cpp == '\0') || (**cpp == '\n')) ? ERROR : NOERROR))
			!= ERROR))  (*cpp)++;
				/*   stop at a nonwhite or '\n'  */

				/*   the above mouthful should have
				     decided if we have encountered
				     end-of-line or end-of-string, in
				     which case retval will be ERROR   */

return(retval);
}				  


