/*
 *			r e c s i z . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	recsiz	Set File Record Size
index		set file Record size

synopsis

	int
	recsiz(ioptr,size)
	 FILE *ioptr;		/* pointer to file to be set */
	 unsigned size;		/* what to set the record size to */

description

	recsiz() sets the record size in the file descriptor block.
	recsiz() doesn't check for a previously set record size. The size
	set, will stay set in the file, after the file is closed.

bugs

author

	Machiavelli Systems

#endif

#define _production

#include <stdio.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>

#define	FDBOFF	024		/* where the fdb really is in FILE struct */




recsiz(ioptr,size)		/* set record size any time after open */
char		*ioptr;		/* which file to set */
unsigned	size;		/* what to set the record size to */
{
	FDB	*fdbp;		/* the pointer to the file descriptor block */

	/* point the users fdp at the correct place */
	fdbp = (char *)(ioptr) + FDBOFF;

	/* set the record size */
	fdbp->f_fatt.f_rsiz = size;

}

