/*
 *			INTERSECT
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	intersect	Finds the intersection of two lines
index			Finds the Intersection of Two Lines

SYNOPSIS:

	intersect(ret_x, ret_y, x1, y1, x2, y2, x3, y3, x4, y4)
	 double	*ret_x;		/* X and Y 
	 double *ret_y;		   intercept */
	 double x1;
	 double y1;
	 double x2;		/* X and Y coordinates
	 double y2;		   for points along
	 double x3;		   respective lines */
	 double y3;
	 double x4;
	 double y4;

DESCRIPTION:

	Determines the intersection of two lines given
	two sets of coordinates from each line. 

BUGS:

	No intersection occurs when gradients are the
	same (ie. lines are parallel ).

AUTHOR:

	Machiavelli data systems

#endif



#define	HUGE_GRAD	1.0E20		/* infinity ?? */

intersect(ret_x, ret_y, x1, y1, x2, y2, x3, y3, x4, y4)
double	*ret_x, *ret_y, x1, y1, x2, y2, x3, y3, x4, y4;
{
	double	m1,m2;

/* calc. gradient of first line */

	if ((x2 - x1) == 0.0)
		m1 = HUGE_GRAD;					/* vertical gradient */
	else
		m1 = (y2 - y1) / (x2 - x1);

/* calc. gradient of second line */

	if ((x4 - x3) == 0.0)
		m2 = HUGE_GRAD;					/* vertical gradient */
	else
		m2 = (y4 - y3) / (x4 - x3);

/* calc. x intersection */

	*ret_x = (y3 - y1 + m1 * x1 - m2 * x3) / (m1 - m2);

/* calc. y intersection - two cases because line 1 could be vertical */

	if (((m1 > 5.0) && (m1 > m2)) || ((m1 < -5) && (m1 < m2)))
		*ret_y = y3 + m2 * (*ret_x - x3);
	else
		*ret_y = y1 + m1 * (*ret_x - x1);
}
