/*
 *			g e t q t e x t . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	getqte	Get Quoted Text
index		Get quoted text

synopsis

	int
	getqtext(ccp,dest)
	 char **ccp;	/* buffer pointer pointer	*/
	 char *dest;	/* destination buffer		*/

description

	getqtext() copys a data element from a buffer  to a given
	destination, starting with the character currently pointed to.

	If the data element is not a quoted string, the function is
	analogous to strcopy() but using whitespace as its terminator.
	The pointer is left pointing to the first whitespace character.

	If first character indicates that the data element is a quoted
	string, the function accepts the whole string but discards the
	quotes, leaving the pointer immediately after the closing quotes.

	Its main use is to accept a complete field, but it may also be
	used to extract quoted text embedded in another string (for
	example, when decoding a "format string".

	This function modifies the pointer to the source string (*ccp).

bugs

author

	Machiavelli Systems

#endif

#include "symbols.h"




getqtext(ccp, dest)

char		**ccp, *dest;

{
/* printf("QT - ccp <%x> *ccp <%s> **ccp <%x>\n",ccp, *ccp,**ccp);
printf("QT - dest <%x> *dest <%s>\n",dest,*dest);	*/
if (**ccp == QUOTEMARK)
	{ 	
	(*ccp)++;			/* advance past the quotes */
				/* now copy until next quotes */

	while (**ccp !=  QUOTEMARK) 
		{
		if (**ccp == '\n' || **ccp == '\0')
			{
zerror("Newline or Nul encountered before closing quotes (<ret> to cont)");
			getchar();	/* wait for key */
			};
		
		*dest++ = *(*ccp)++;	/* let's do it! */
		};
		*dest = '\0';		/* we are now at the quote */
		(*ccp)++;			/* go past the quote */
	}

else 	{	while ((!iswhite(**ccp)) && (**ccp != '\n') && (**ccp != '\0'))
		{
		(*dest++ = *(*ccp)++);	/* copy the char */
		};
		*dest = '\0';		/* terminate the copied string */
	};
/*	printf("QT - dest <%x> *dest <%s>\n",dest,*dest);
printf("QT - ccp <%x> *ccp <%s> **ccp <%x>\n",ccp,*ccp,**ccp);	*/
}
