/*
 *			f o p e n c . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	fopenc	Open New Fixed File
index		Open new fixed file

synopsis

	FILE *
	fopenc(filnam,recz)
	 char *filnam;		/* pointer to the name of the file to open */
	 unsigned recz;		/* record size in the file */

description

	fopenc() creates and opens a fixed length file.
	0 is returned on error, $$ferr contains the error code.

bugs

author

	Machiavelli Systems

#endif

#define _production

#include <stdio.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>

#define	FDBOFF	024		/* where the fdb really is in FILE struct */



FILE *fopenc(filnam,recz)	/* open(create) named file for random access with given record size */
char *filnam;			/* name of file to open */
unsigned	recz;		/* record size (bytes) */
{
	FILE	*ioptr;

	/* open the file */
	ioptr = fopen(filnam,"wn");

	/* if it's ok, then set random access, and record size */
	if (ioptr) {
		ranacc(ioptr);
		recsiz(ioptr,recz);
	};

	/* return the pointer to the fdb */
	return	(ioptr);	/* return NULL, $$ferr if failed */

}
