/* ICSP: return TRUE if char is in a set of chars */

/* prodoc.c - empty skeleton for documentation (of tools) */

#ifdef	DOCUMENTATION
title	icsp()	TRUE if char is element of a set of chars
index	Set
index	Element of
synopsis
	 
	 char chr;	/* subject of inquiry */
	 char set[] = { "..." };
	 int isinit;	/* TRUE if chr is in set[] */
	 
	 isinit = icsp(chr,set);
	 
description

	The origins of "icsp" are historical (hysterical?) and if
	you don't speak LISP, you don't want to know!

	The idea is like strchr(). You ask if a character is a member
	of a set of characters. HOWEVER you may include '\0' in the
	set of characters; an option unavailable with strchr().

	To
	make '\0' part of the set, include it as the FIRST character of
	set[]. Naturally, we still expect a (second) '\0' to end the
	set. I think this trick is also used by Data General for their
	"byte move until ..." instructions, at least in ForTran.

	Apart from the trick of '\0' in the set, the order of characters
	in the set is immaterial. Repeating a character in set[] is harmless
	but silly.

	Why does icsp use (chr,str) instead of (str,chr) like strchr?
	To confuse the enemy! (That's YOU.) Actually, it is from LISP,
	which at least has two excuses: (1) it was (nearly) first, (2) it is
	a considerable improvement on (most) all its successors.
	To all LISP programmers: I *KNOW* it doesn't make sense in LISP
	either: please don't write to tell me.

internal

	Based on a BDS C algorithm debugged on a Delta.

author

	Dean Elsner.
#endif

/*
 *		E D I T   H I S T O R Y
 *
 * ??-???-?? DLE	Create.
 * 10-aug-85 DLE	Exhume for MLS.
 */

#include <algol68.h>

int icsp(c,s)
char	c;
char	*s;
BEGIN
char	d;
	IF	(*s==0)
	THEN	IF	(c==0)
		THEN	return(TRUE);
		FI
		s++;
	FI
	WHILE	(d=*s++)
	DO	IF	(c==d)
		THEN	return(TRUE);
		FI
	OD
	return(FALSE);
END

/*   N O T E : on a particular computer, it may be better to build a bitmap
     so that one array lookup gives whether a character is in the set ,
     then zoom through a number of characters using that bitmap */

/* end: icsp.c */
