/* task.c - show RSX/M(+) user what status a task has */
/* written to debug I/D tasks with decus C */

#include <algol68.h>
#include <cx.h>

word	buf[8];		/* info lands here */
word	parameters[6];	/* DPB */
int	dsw;		/* result */

char * s[] =	{
			"?",
			"?",	/* these 5 bits are a blocking count */
			"?",
			"?",
			"?",
			"?",
			" CKR  checkpoint requested",
			" CKP  being checkpointed",
			" OUT  out of memory",
			" STP  externally blockd by CLI command",
			" HLD  half loaded",
			" RUN  running on another processor",
			" NRP  task mapped to non-resident partition",
			" MSG  abort message being output",
			" RDN  I/O rundown in progress",
			"-EXE  not executing",
			""
		};

char * s2[] =	{
			" WFR  wait for",
			" WF2  was WFR before AST",
			" SPN  suspended",
			" SP2  was SPN before AST",
			" STP  stopped",
			" ST2  was STP before AST",
			" ABO  marked for abort",
			" HLT  being halted",
			" CAF  dynamic checkpoint space allocation failure",
			" REX  abort AST in progress (or effected)",
			" FXD  fixed in memory",
			" SEF  stopped for event flags",
			" CKD  checkpointing disabled",
			"-CHK  not checkpointable",
			" DST  disable AST recognition",
			" AST  AST in progress",
			""
		};

char * s3[] =	{
			" GFL  group global event flags lock",
			" SWS  ?software services",
			" CMD  executing CLI command",
			" MPC  mapping change with outstanding I/O",
			" NET  network protocol level",
			" ROV  resident overlays",
			" CAL  checkpoint space allocated in task image",
			" NSD  not allow send data",
			" RST  restricted",
			" CLI  command line interpreter",
			" SLV  slave",
			" MCR  requested as external MCR function",
			" PRV  privileged",
			" REM  remove on exit",
			"-PMD  don't dump when synchronous abort",
			" ACP  ancillary control processor",
			""
		};

char * s4[] =	{
			" SNC  uses commons for synchronisation",
			" DSP  data space (I/D task)",
			" PRV  t3.prv was cleared by GIN",
			" PRO  prototype",
			" LDD  load device dismounted",
			" MUT  multi-user",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			""
		};

main(argc,argv)
int	argc;
char **	argv;
BEGIN
char * r50long();

	IF	(argc<2)
	THEN	error("usage %s taskname\7",*argv);
	FI

	parameters[0] = 6<<8;	/* length of dpb */
	parameters[1] = 10;	/* SFFTK get task info */
	parameters[2] = buf;	/* address of buffer */
	parameters[3] = 8;	/* size of buffer */
	ascr50( min(strlen(argv[1]),6), argv[1], parameters+4);
	dsw = gin(parameters);
	printf("dsw=%oo\n",dsw);

	IF	(dsw>0)
	THEN	printf("task \"%s\"",r50long(buf));
		printf(" partition=\"%s\"\n",r50long(buf+6));

		tell("blocking ", buf[2] & ~037, s );	/* forget blocking count */
		tell("state    ", buf[3]       , s2);
		tell("attribute", buf[4]       , s3);
		tell("         ", buf[5]       , s4);
	FI
END

tell(wot,bits,names)
char *	wot;
int	bits;
char **	names;
BEGIN
	printf("\n--%s status--  %oo\n",wot,bits);
	mask(bits,names);
END


char * r50long(x)	/* 2 rad50 words => give a string(no trailing blanks) */
address	x;
BEGIN
static char c7[7];

	c7[6] = 0;
	r50toa(c7,x,2);
	$_$rtb(c7);
	return (c7);
END

mask(m,text)		/* sorry about the BASIC(k) accent! */
unsigned	m;
char * text[];
BEGIN
unsigned	b;
unsigned	i;
	FOR	(i=0;	i<16;	i++)
	DO	b = 1<<i;
		IF	((b&m) || !streq("?",text[i]))
		THEN	printf("%s%s\n",b&m?"Yes ":"No  ",text[i]);
		FI
	OD
END

/* end: task.c */
