PASDDT
======

GENERAL:

   THE PASCAL DEBUG SYSTEM (PASDDT) IS AN AID FOR DETECTING LOGICAL ER-
   RORS IN A PASCAL PROGRAM.
   IT ALLOWS THE USER, VIA A TERMINAL, TO INTERACT WITH AN EXECUTING
   PASCAL PROGRAM, INSPECTING CURRENT VALUES OF VARIABLES, ASSIGNING
   NEW VALUES, GENERATING SYMBOLIC DUMPS OF STACK AND HEAP, ETC..

REQUIREMENTS:

   TO ENABLE DEBUGGING, THE USER PROGRAM MUST BE COMPILED WITH THE DEBUG
   OPTION SET (D+) IN FRONT OF THE PROGRAM HEADING. THE OPTION MAY BE
   SWITCHED OFF AND ON AROUND LOCAL PROCEDURES IF DEBUGGING ONLY SHALL
   APPLY TO PART OF THE PROGRAM.
   DEBUGGING DOES NOT APPLY TO SEPARATELY COMPILED PROCEDURES REFERED
   TO IN A MAIN PROGRAM (EXTERNAL PROCEDURES), AND SUCH PROCEDURES MUST
   BE COMPILED WITHOUT THE DEBUG OPTION SET.

   COMPILATION WITH DEBUG OPTION SET INCREASES THE LOAD MODULE CONSIDE-
   RABLY. THEREFORE, WHEN A PROGRAM IS CONSIDERED BUG-FREE, IT SHOULD
   BE RECOMPILED  WITHOUT THE DEBUG OPTION SET.

   SINCE THE DEBUG SYSTEM IS LINE NUMBER ORIENTED, IT IS ADVISABLE 
   TO HAVE A COMPILATION LIST OF THE SOURCE PROGRAM AVAILABLE WHEN AP-
   PLYING THE DEBUGGER.

FUNCTION:

   A RUNNING PROGRAM CAN BE IN ONE OF TWO MODES:
   - EXECUTION MODE,  WHERE THE PROGRAM EXECUTES NORMALLY.
   - DEBUG MODE,      WHERE PROGRAM EXECUTION IS SUSPENDED TO ALLOW THE
                      USER TO EXECUTE DEBUG COMMANDS.

   DEBUG MODE IS ENTERED IN THE FOLLOWING SITUATIONS:
   - AT THE START OF PROGRAM EXECUTION, TO ALLOW THE USER TO SPECIFY
     INITIAL BREAK POINTS.
   - ENCOUNTERING A USER SPECIFIED BREAK POINT.
   - ON OCCURRENCE OF A RUN TIME ERROR.
   - EXECUTING A HALT STATEMENT.

   DEBUG MODE IS TERMINATED BY THE COMMAND 'CONTINUE' OR 'CANCEL EXECU-
   TION'.

   IN DEBUG MODE, THE PROMPT CHARACTER '?' INDICATES THAT THE SYSTEM IS
   READY TO RECEIVE A COMMAND FROM THE USER. THE COMMAND IS TYPED IN ON
   THE SAME LINE. ***** ONLY UPPER CASE CHARACTERS ARE RECOGNIZED! *****

COMMAND SUMMARY:

   THE FOLLOWING COMMANDS ARE AVAILABLE IN DEBUG MODE:
      SET BREAKS
      CANCEL BREAKS
      LIST BREAKS
      EXAMINE
      DEPOSIT
      TRACE CALLSEQUENCE
      DUMP STACK
      DUMP HEAP
      CONTINUE
      CANCEL EXECUTION

   THESE COMMANDS ARE DESCRIBED IN THE FOLLOWING SECTIONS.

   A COMMAND MAY NOT EXCEED ONE LINE OF INPUT.
  
   COMMAND KEYWORDS MAY BE ABBREVIATED UP TO THE SHORTEST ACCEPTABLE
   FORM INDICATED BY UNDERLINING.
   EXAMPLE:  CONTINUE
             --
             CO,CON,CONT, .. ,CONTINUE, ALL HAVE THE SAME MEANING.

    
   COMMAND:
                                      *
      SET BREAKS <LINENR> [, <LINENR>]
      --  --

   MEANING:
      BREAK POINTS ARE SET AT LINE NUMBERS SPECIFIED.
      EXECUTION WILL BE SUSPENDED UPON THE NEXT OCCURRENCE OF AN ACTIVE
      BREAK POINT AND DEBUG MODE WILL BE ENTERED.

   EXAMPLE:
      SET BREAKS 320,330,402,234


   COMMAND:
                                         *
      CANCEL BREAKS <LINENR> [, <LINENR>]
      ---    --

   MEANING:
      BREAK POINTS EARLIER SET AT SPECIFIED LINE NUMBERS ARE CANCELLED.
 
   EXAMPLE:

      CANCEL BREAKS 320,330


   COMMAND:
      
      LIST BREAKS
      --   --

   MEANING:
      ALL ACTIVE BREAK POINTS ARE LISTED.


   COMMAND:
  
      EXAMINE <VARIABLE>
      --

   MEANING:
      THE CURRENT VALUE OF THE SPECIFIED VARIABLE IS LISTED .
      <VARIABLE> MUST BE A VARIABLE DECLARED WITHIN THE SCOPE OF THE
      POINT WHERE EXECUTION WAS SUSPENDED.

   EXAMPLE:

      EXAMINE A[I].X


   COMMAND:

      DEPOSIT <VARIABLE> := <EXPRESSION>
      --

   MEANING:
      <VARIABLE> IS ASSIGNED THE VALUE RESULTING FROM EVALUATION OF
      <EXPRESSION>.
      ALL VARIABLES SPECIFIED MUST BE WITHIN THE SCOPE OF THE POINT
      FROM WHERE EXECUTION WAS SUSPENDED.
      ONLY SIMPLE ARITHMETIC OPERATORS ON INTEGER AND REAL VARIABLES
      ARE ALLOWED.

   EXAMPLE:
  
      DEPOSIT I := J + 10


   COMMAND:

      TRACE CALLSEQUENCE
      --    ---

   MEANING:
      NAMES OF ALL CURRENTLY ACTIVE PROCEDURES ARE LISTED TOGETHER
      WITH NUMBERS OF LINES FROM WHERE THEY WERE CALLED.


   COMMAND:

      DUMP STACK
      --   --

   MEANING:
      THE CURRENT VALUES OF ALL VARIABLES, ALLOCATED ON THE STACK,
      OF ACTIVE PROCEDURES ARE LISTED.


   COMMAND:

      DUMP HEAP
      --   --

   MEANING:
      THE CURRENT VALUES OF ALL DYNAMICALLY ALLOCATED VARIABLES ARE
      LISTED.


   COMMAND:
      
      CONTINUE
      --

   MEANING:
      EXIT FROM DEBUG MODE.
      NORMAL EXECUTION IS RESUMED AT THE POINT OF SUSPENSION BEFORE
      DEBUG MODE WAS ENTERED.


   COMMAND:

      CANCEL EXECUTION
      ---    ---

   MEANING:
      EXIT FROM DEBUG MODE.
      PROGRAM EXECUTION IS TERMINATED AND CANNOT BE RESUMED.

