/*
 *			F I X D O C
 */

/*)BUILD	$(TKBOPTIONS) = {
			TASK	= ...FXD
		}
*/

#ifdef	DOCUMENTATION

title	fixdoc	Fix runoff output files
index		Fix runoff output files

synopsis

	fixdoc <infile >outfile

description

	Because of bugs in RSTS/E RNO.TSK and VMS "Standard Runoff", this
	filter must be applied to C library documentation.  It is executed as
	.s
		fixdoc <infile >outfile
	.s
	It is specific to the Decus C
	documentation standards (left margin 8, right margin 72,
	page size 80 columns).
	.s
	On VMS, the title lines are output "<FF>text...".

author

	Martin Minow

#endif

#include <stdio.h>

#define PAGESIZE	72	/* .right margin 72			*/
#define	EOS		0

char	line[1025];
char	out[1025];

main(argc,argv)
int argc;
char *argv[];
{
	register char	*lp;			/* Line pointer		*/
	register char	*op;			/* Output pointer	*/
	register int	c;			/* Random character	*/
	char		*from;			/* Marker in line	*/
	char		*hack_start;		/* You'll see		*/

#ifdef	rt11
	/*
	 * This is needed to preserve the naked carriage-return
	 * that runoff uses for underlining.
	 */
	fgetname(stdin, line);
	if (freopen(line, "rn", stdin) == NULL)
		error("Can't reopen \"%s\"\n", line);
#endif
	/*
	 * For native RSX, we probably have to reopen stdin "rn".
	 */
#ifdef vms
	/*
	 * For VAX C, we have to do our own redirection.
	 */
	argc = getredirection(argc,argv);
#endif

	while (gets(line) != NULL) {
		hack_start = line;
		lp = line + strlen(line) - 1;	/* lp -> last char	*/
		if (*lp == '\r')
			*lp = EOS;
		lp = line;
		/*
		 * Form feed?
		 */
		if (*lp == '\f') {
			putchar('\f');
			hack_start = ++lp;	/* Skip over col 1 <FF>	*/
		}
		while ((c = *lp) == ' ' || c == '\t')
			lp++;			/* Leading blanks	*/
		if (c != '[' || lp[1] != '[')	/* "[[text ..."		*/
			goto nogood;
		from = &lp[2];			/* "text..."		*/
		while ((c = *++lp) && c != ']'); /* "... ]]"		*/
		if (c == EOS || lp[1] != ']')
			goto nogood;
		op = copy(out, from, lp - from);
		*op = EOS;
		lp += 2;
		while ((c = *lp) && c <= ' ')
			lp++;			/* "[[text]]   Page"	*/
		if (tolower(c) != 'p'
				|| tolower(lp[1]) != 'a'
				|| tolower(lp[2]) != 'g'
				|| tolower(lp[3]) != 'e'
				|| lp[4] != ' ')
			goto nogood;
		printf("%s%?s\n", out, PAGESIZE - (op - out) + 1, lp);
		continue;

nogood:		puts(hack_start);
	}
}

