
#include	"sysdef.h"

/*	SCUTIL.C							*/
/*	oft needed utility routines					*/

/*+	pinc()								*/
/*+	pdec()								*/
/*+	fixposition() 							*/
/*+	newpage(linenumber)						*/
/*+	page()								*/
/*+	lposition()							*/
/*+	lposition()							*/
/*+	cnpage(linenumber)						*/
/*+	sclinc()							*/
/*+	scldec()							*/
/*+	rstpage(linenumber)						*/
/*+	lreset()							*/
/*+	creset()							*/
/*+	retype()							*/
/*+	goback()							*/
/*+	vtbell()							*/
/*+	gettxtsave(where)						*/
/*+	puttxtsave(where)						*/
/*+	deleoln(where)							*/
/*+	delboln(where)							*/
/*+	findeoln()							*/
/*+	sveoln(where)							*/
/*+	svboln(where)							*/
/*+	svlinsert(where)						*/
/*+	svwinsert(where)						*/
/*+	svcinsert(where)						*/
/*+	svinsert(where,s,len)						*/
/*+	remchar(where)							*/
/*+	delword()							*/
/*+	atcrlf()							*/
/*+	attabspace()							*/
/*+	putcrlf()							*/
/*+	putcr()								*/
/*+	redolines()							*/
/*+	inscheck()							*/
/*+	scdecout(val)							*/
/*+	revline()							*/

#include	"scerrd.h"
#include	"scterm.h"
#include	"tempio.h"

#define	CR	015
#define	LF	012
#define	FF	014
#define	SPACE	040
#define	tab	011
#define	TAB	011
#define	false	0
#define	true	1
#define	then

extern int chposition,curposition,worklength ;
extern char workbuffer[] ;





/*	PINC	adjust the cursor and line pointer			*/


pinc()

{
	extern int chposition,curposition,erasef,worklength;
	extern char workbuffer[] ;

	if (chposition < worklength)
	  then	{
		if (workbuffer[chposition] == TAB)
		  then erasef = true ;
		chposition++ ;
		curposition++;
		fixposition();
		}
}



pdec()

{
	extern int chposition,curposition,erasef,worklength;
	extern char workbuffer[] ;

	if (chposition > 0)
	  then	{
		chposition-- ;
		curposition--;
		if ( workbuffer[chposition] == TAB ) then fixposition();
		}
}


fixposition() 
{
	
	extern int chposition,curposition,erasef,worklength;
	extern char workbuffer[] ;
	register char *wp ;
	register int temp ;
	register int i ;

	temp = 1 ;
	wp = workbuffer ;
	for (i=0;i<chposition;i++) {
		if ( *wp++ == TAB && (temp&07) != 0 )
		  then temp += 8 - (temp&07) ;
		temp++ ;
		}
	curposition = temp ;
}





newpage(linenumber)
int linenumber ;
{
	rpage(linenumber);
	page() ;
	
}

page()
{
	extern int *curline,*loclow ;

	creset() ;
	rstpage(*loclow);
	*curline = *loclow ;
	ref_screen() ;
	scloadline();
	home() ;
	lposition() ;
}


lposition()
{
	extern int curposition ;
	register int save ;

	save = curposition ;
	curposition = 1 ;
	scmove() ;
	curposition = save ;
}

cnpage(linenumber)
int linenumber;

{

	extern int *curline,page_size[],termtype ;
	register int temp,linetemp;

	linetemp = linenumber ;
	temp = page_size[termtype]/4 ;
	if (temp < linetemp) then linetemp -= temp ;
	rstpage(linetemp) ;
	ref_screen() ;
	*curline = linenumber ;
	creset() ;
	scloadline() ;
}


	
sclinc()
{
	extern int *loclow ;
	rstpage(*loclow+1);
}


scldec()
{
	extern int *loclow ;
	rstpage(*loclow-1);
}




static rpage(linenumber)
int linenumber ;
{
	extern int *loclow,*lochigh,*maxline,page_size[],termtype;
	register int temp ;

	rstpage(linenumber) ;
	if ( ( temp = *lochigh - *loclow ) < page_size[termtype] )
	  then rstpage( linenumber + temp - page_size[termtype] ) ;
}


rstpage(linenumber)
int linenumber;
{
	extern int *loclow,*lochigh,*maxline,page_size[],termtype;
	register int *ip ;
	register int temp ;

	temp = linenumber ;
	ip = loclow ;
	if ( (*ip = temp) <= 0 )
	  then	{
		temp = 1 ;
		*ip = temp ;
		}
	  else	{
		if (*ip >= *maxline) then *ip = *maxline - 1 ;
		}
	if ( (temp += page_size[termtype]) >= *maxline ) then temp = *maxline-1;
	*lochigh = temp ;
}



lreset()
{
	scunloadline() ;
}

creset()
{
	extern int chposition, curposition ;

	curposition = 1 ;
	chposition  = 0 ;
}

retype()
{
	lposition() ;
	lkill() ;
	dumpworkbuffer() ;
	scmove() ;
}


goback()
{
	extern int fastio ;
	register int save ;

	save = fastio ;
	fastio = 0 ;
	scmove() ;
	fastio = save ;
}
	
vtbell()
{
	putbin("\07",1);
}




gettxtsave(where)
int where;
{
	extern struct textline txtsave ;
	extern int worklength ;
	extern char workbuffer[] ;
	register char *gp,*wp ;
	register int  i ;

	gp = txtsave.c ;
	wp = workbuffer ;
	for (i=where; i<worklength && isdelimiter(*wp)==0; i++ ) *gp++ = *wp++ ;
	return( txtsave.len = i ) ;
}


puttxtsave(where)
int where ;
{
	extern struct textline txtsave ;
	return( svinsert(where,txtsave.c,txtsave.len) ) ;
}





deleoln(where)
int where;
{
	register int	count,savepos;

	savepos = chposition ;
	chposition = where ;
	count = 0 ;
	while ( atcrlf() == 0 ) {
		chposition++ ;
		count++ ;
		}
	txtmod() ;
	worklength = where + 2 ;
	workbuffer[where++] = CR ;
	workbuffer[where] = LF ;
	chposition = savepos ;
	if ( savepos >= worklength ) then creset() ;
	return(count) ;
}



delboln(where)
int where ;
{
	extern struct deltype lastdeleted ;
	register int i ;
	register char savech ;

	savech = lastdeleted.lastc ;
	txtmod() ;
	for ( i=0; i<where; i++ ) remchar(0) ;
	lastdeleted.lastc = savech ;
	return(i) ;
}



findeoln()
{

	while (atcrlf() == 0) pinc() ;
}






sveoln(where)
int where ;
{
	extern int worklength, chposition ;
	extern char workbuffer[] ;
	extern struct deltype lastdeleted ;
	register char *cp,*wp ;
	register int save ;

	save = chposition ;
	chposition = where ;
	wp = &workbuffer[chposition] ;
	cp = lastdeleted.lastline.c ;
	lastdeleted.lastline.len = 0 ;
	lastdeleted.lastline.partial = 1 ;
	*cp = '\0' ;
	while ( atcrlf() == 0 ) {
		*cp++ = *wp++ ;
		lastdeleted.lastline.len++ ;
		chposition++ ;
		}
	chposition = save ;
	return( lastdeleted.lastline.len ) ;
}


svboln(where)
int where ;
{
	extern int worklength, chposition ;
	extern char workbuffer[] ;
	extern struct deltype lastdeleted ;
	register char *cp,*wp ;
	register int i ;

	wp = workbuffer ;
	cp = lastdeleted.lastline.c ;
	lastdeleted.lastline.len = 0 ;
	lastdeleted.lastline.partial = 1 ;
	*cp = '\0' ;
	for ( i=0; i<where; i++ ) {
		*cp++ = *wp++ ;
		lastdeleted.lastline.len++ ;
		}
	return(i) ;
}

revline()
{
	extern struct deltype lastdeleted ;
	register int i ;

	sveoln(0) ;
	deleoln(0) ;
	for (i=0; i < lastdeleted.lastline.len; i++ )
	  svinsert(0,&lastdeleted.lastline.c[i],1);
}






atcrlf()
{
	extern int chposition, curposition, worklength ;
	extern char workbuffer[] ;
	register char ch ;

	if (chposition >= worklength) then return(true) ;
	ch = workbuffer[chposition] ;
	return ( ch== CR || ch==LF || ch==FF ) ;
}


attabspace()
{
	extern int chposition, curposition, worklength ;
	extern char workbuffer[] ;
	register char ch ;

	ch = workbuffer[chposition] ;
	return ( ch==SPACE || ch ==TAB ) ;
}


atworddelim()
{
	extern int chposition, curposition, worklength ;
	extern char workbuffer[] ;
	register char ch, *cp ;
	extern char worddelim[] ;

	ch = workbuffer[chposition] ;
	if ( ch == SPACE || ch==TAB )
	  then	return(1) ;
	  else	{
		cp = worddelim ;
		while (*cp != 0) if (ch == *cp++) then return(1) ;
		return(0) ;
		}
}



scttin()
{
	return(1) ;
}






putcrlf()
{
	putbin("\015\012",2) ;
}

putcr()
{
	putbin("\015",1) ;
}

redolines()
{
}


	


inscheck()
{
/*
	extern int doiref,inmode ;

	if ( inmode == 0 )
	  then	scunloadline() ;
	  else	{
		lreset() ;
		if ( doiref ) then retype() ;
		}
*/
}		


ckmacro()
{
}



scdecout(val)
int val ;
{
	char s[10] ;

	sxprintf(s,"%7d",val) ;
	putbin(s,7) ;
}
