
#include	"sysdef.h"

#include	"scerrd.h"

#define	CR	015
#define	FF	014
#define	LF	012
#define	ESC	033

extern char bigbuffer[] ;

#define	then

s_lstpage()
{
	set_limits(-1);
	ref_screen() ;
}


s_page()
{
	set_limits(1);
	ref_screen() ;
}


set_limits(direction)
int direction ;
{
	extern int *loclow,*lochigh,*maxline,ttpsize ;
	register int save ;

	if (direction > 0)
	  then {
	    save = *loclow ;
	    *loclow += ttpsize ;
	    if ( *loclow >= *maxline ) then *loclow = save ;
	    }
	  else {
	    *loclow -= ttpsize ;
	    if ( *loclow < 0 ) then *loclow = 1 ;
	   }
	*lochigh = *loclow + ttpsize ;
	if ( *lochigh >= *maxline ) then *lochigh = *maxline - 1 ;
}



static char crlf[] = "\015\012" ;

screfscreen()
{
	lreset() ;
	ref_screen() ;
}

static int ast_done ;

#define	NLINES_BUFFERED 3

ref_screen()

{
	extern int *curline,*loclow,*lochigh,sts_one,sts_two,*maxline,worklength;
	extern int page_size[],termtype,ttastarm ;
	register int cursave,linenumber,nlines,bufcount ;
	extern char workbuffer[] ;

	if ( ( sts_one & _vtedit ) == 0 ) return(0) ;
	ast_done = 0 ;
	if ( ttastarm) then dclinpast(&ast_done) ;
	cursave = *curline ;
	scunloadline() ;
	sclear() ;
	putbin("\015",1) ;
	bufcount = NLINES_BUFFERED ;
	enabuffering() ;
	for (linenumber = *loclow; linenumber <= *lochigh; linenumber++) {
		if ( ast_done ) then break ;
		*curline = linenumber ;
		scloadline() ;
		dumpnext(workbuffer,worklength) ;
		nlines++ ;
		if ( --bufcount == 0 )
		  then	{
			disbuffering() ;
			enabuffering() ;
			bufcount = NLINES_BUFFERED ;
			if ( nlines > NLINES_BUFFERED*3 ) bufcount = 100 ;
			} ;
		}
	disbuffering() ;
	*curline = cursave ;
	scloadline() ;
	if ( ttastarm ) then clrinpast(&ast_done) ;
	scmove() ;
}


dumpworkbuffer()
{
	extern char workbuffer[] ;
	extern int *curline,worklength,sts_one ;

	putbin("\015",1) ;
	if ((sts_one & _vtnolines)==0) then plinenumber(*curline);
	dumpl(workbuffer,worklength) ;
}


dumpl(s,len)
char *s;
int len;
{
	register char *cp ;
	register int i,doff ;

	cp = &s[len] ;
	for (i=len; i > 0 && *(--cp) != FF && *cp <= ' ' && *cp != ESC; i-- ) ;
	if ( *cp == FF ) then i-- ;
	if ( i > 0 && *s == FF )
	  then	{
		ffprint() ;
		s++ ;
		}
	if ( i > 0 ) then puttrbin(s,i) ;
	if ( *cp == FF ) then ffprint() ;
}



/*	DUMPNEXT is a lower overhead version of DUMPL for REFSCREEN	*/

dumpnext(s,len)
char *s;
int len;
{
	extern int termtype ;
	register char lastch ;
	register char *cp ;
	register int i,j ;

	cp = &s[len] ;
	for (i=len; i > 0 && *(--cp) != FF && *cp <= ' ' && *cp != ESC; i-- ) ;
	if ( ( lastch = *cp ) == FF ) then i-- ;
	cp = &bigbuffer ;
	if ( *s == FF && i > 0 )
	  then	{
		s++ ;
		ffprint() ;
		}
	for (j=i; j>0; j-- ) *cp++ = *s++ ;
	if ( lastch == FF ) 
	  then	{
		if ( i > 0 ) then puttrbin(bigbuffer,i) ;
		ffprint() ;
		putbin("\015\012",2) ;
		}
	  else	{
		*cp++ = CR ;
		*cp++ = LF ;
		puttrbin(bigbuffer,i+2) ;
		}
}
	
partdump()
{
	extern char workbuffer[] ;
	extern int  chposition,worklength ;

	dumpl(&workbuffer[chposition],worklength-chposition) ;
}
