/*
 *	t m s g
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

Title	tmsg	Type operator messages
Index		Type operator messages

synopsis
	.s.nf
	tmsg(severity, fmt, args);
	char severity;	/* 'M', 'W', 'E', 'F' */
	char *fmt;	/* standard printf format string */
	/* one of more args for format string */
	.s.f
Description

	tmsg provides a clean way to send messages to the console.
	It automatically provides the task name and current time
	prepended to the message.

	Assume a task named TSTTSK where a variable "value"
	can't exceed 5. If a test failed and a message was needed,
	a typical warning message might be:

	.s.nf
	   11:20:14 TSTTSK-W-value too big 10 max 5
	.s.f

	To generate this message, the call would be:

	.s.nf
	   tmsg('W', 'value to big %d max %d\n", value, MAX);
	.s.f

	The severity argument provides the character following
	the task name. Standard characters are:
	.s.nf

		M	informational message
		W	warning, processing continuing
		E	error, processing continuing but may 
			have bad results
		F	fatal error, task aborting.
	.s.f
	Note that this routine only prints a message, it will
	not abort the task.

	The format string is any regular printf style format.
	You may have any number of arguments. Tmsg always writes
	to stderr.

Implementation Details

	Tmsg gets the task name from $$task[], defined during
	the C runtime code startup. Note tht the name displayed
	is the current task name. If the task was just run without
	an explicit name, the name displayed would be the local
	terminal name.
Bugs


#endif

#include <stdio.h>
#include <cx.h>
#include <timbuf.h>

static struct timbuf timstamp;

extern char $$task[];

tmsg(svr, argl)
int svr;	/* severity char */
{
  $$rtime(&timstamp);

  fprintf(stderr, "\n%02d:%02d:%02d %s-%c-%r", timstamp.g_tihr, 
  	timstamp.g_timi, timstamp.g_tisc, $$task, svr, &argl);
}
