c Subroutine to extract and convert time-of-day string for DTC package
c Converts string of form hh:mm to integer between 80 and 173
c (half-hour intervals).  If range h1:m1>h2:m2 is present, second
c value is returned, else same as t1>t1.

c Special cases
c	*	=>	{itr1}>{itr2}
c	E or EV	=>	17:00
c	h:	=>	0h:00
c	h:n	=>	0h:n0	(if n .ge. 3, then 3, else 0)
c	h1>h2	=>	h1:00>h2:00

c If ':' or '>' is not 2nd or 3rd character, or not '*', 'E' or 'EV',
c entire string is left untouched, and default values are returned
c (parameters unchanged)

	subroutine dtctimcvt (itr1, itr2)

	include 'comdtc.inc/nolist'

	byte ll, ln1, wk(2)
	integer*2 iwk
	logical first, expectmin

	equivalence (line, ln1), (iwk, wk)

	include 'stmtfunc.for/nolist'

	it1 = itr1			! Caller's limits
	it2 = itr2			! (formerly 8:00 AM > 5:30 PM)

	ix = 0				! Amount to strip

	if (ln1 .eq. '*') then		! Check special cases first

	    ix = 1			! Defaults, dump 1 char

	else if ((ln1 .and. ucmask) .eq. 'E') then

	    it1 = 170			! Set eventide
	    it2 = it1

	    ix = 1
	    if ((line(2) .and. ucmask) .eq. 'V') ix = 2

	else

	    i = 0			! Temp index
	    first = .true.		! Helpful

 10	    if (numeric(line(i+1))) then

		if (numeric(line(i+2))) then
		    wk(1) = line(i+1)
		    wk(2) = line(i+2)
		    ih = icvtbin(iwk) * 10
		    i = i + 2
		else
		    ih = icvtbn1(line(i+1)) * 10
		    i = i + 1
		end if

		if (line(i+1) .eq. ':') then
		    i = i + 1
		    if (numeric(line(i+1))) then
			im = icvtbn1(line(i+1))
			if (im .ge. 3) then
			    im = 3
			else
			    im = 0
			end if
			ih = ih + im
			i = i + 1
			if (numeric(line(i+1))) i = i + 1 ! Just ignore it
		    end if
		    ix = i			! Accept all processed chars
		end if

		if ((ih .ge. 10) .and. (ih .lt. 70))
	1	   ih = ih + 120	! Force early AM to PM
		ih = min0(max0(ih, 80), 180)	! Normalize within limits

		if (line(i+1) .eq. '>') then
		    i = i + 1
		    ix = i				! Insure it gets copied
		    it2 = ih
		    if (first) then
			it1 = it2
			first = .false.
			go to 10
		    end if
		else if (ix .ne. 0)	then		! Got some numeric
		    if (first) then
			it1 = ih			! terminated by ':'
			it2 = ih			! first time t1>t1
		    else
			it2 = ih			! 2nd numeric
			ix = i			! Claim everything looked at
		    end if	! Which time
		end if		! Range delimiter ('>')
	    end if		! First numeric
	end if			! All others unrecognized (includes EOL)

	itr1 = it1		! All exit here
	itr2 = max0(it2, it1)	! Make sure range OK

	if (ix .ne. 0) call shrink (ix, ifnb, lnb) ! Unload what we've used

	end
