C
C	SUBROUTINE READW
C
C
C	FUNCTION: READW READS A SPECIFIED NUMBER OF WORDS INTO A BUFFER
C		 ,CHECKS FOR ALL POSSIBLE ERRORS THEN RETURNS
C
C
C	AUTHOR:	G. GUELFI	1-APRIL-1985
C
C
C	CALL IS
C
C		CALL READW(IWCNT,IQ,IBLK,ICHAN)
C
C	WHERE
C
C	IWCNT	IS NUMBER OF WORDS TO BE READ
C	IQ	IS BUFFER TO HOLD WORDS
C	IBLK	IS BLOCK TO START READING FROM
C	ICHAN	IS CHANNEL FOR READ
C
C
	SUBROUTINE READW(IWCNT,IQ,IBLK,ICHAN)
	DIMENSION IQ(IWCNT)
C	CALL SCCA(NFLAG)
	CALL RDERR(IREADW(IWCNT,IQ,IBLK,ICHAN),IRD,0)
C	CALL SCCA(NFLAG)
C
C	INCREMENT BLOCK COUNTER AND RETURN
C
	IBLK = IBLK + IRD/256
	RETURN
	END
C
C	SUBROUTINE  RDERR
C
C	FUNCTION : TO CHECK THE RETURNED FUNCTION CODE AFTER THE IREADW
C		   HAS BEEN PERFORMED AND TO REPORT ALL POSSIBLE ERRORS .
C
C		  ON ERROR THE PROGRAM CAN GENERATE A DIVIDE BY ZERO TO 
C	   	  GIVE A TRACE BACK .
C
C
C
C	AUTHOR:	G. GUELFI	1-APRIL-1985
C
C
C	CALL IS
C
C	SUBROUTINE RDERR(ICODE,IRD,NUM)
C
C		WHERE
C
C			ICODE	 IS IREADW FUNCTION VALUE
C			IRD	 CAN CONTAIN ERROR VALUE TO BE IGNORED
C				 AND IT RETURNS VALUE OF ICODE
C			NUM	 IS VALUE TO GENERATE TRACE BACK
C
C				IF NUM = 0 THEN TRACE BACK
C				IF NUM = 1 ONLY REPORT ERROR
C
	SUBROUTINE RDERR(ICODE,IRD,NUM)
C
C
C	ERROR MESSAGES FOR IREADW
C
	IF (ICODE.GE.0.OR.ICODE.EQ.IRD) GOTO 100

D	DO 1 I = 1,14
D	J = I - 1
D	CALL CLOSEC(J)
D1	CALL IFREEC(J)
	TYPE *,ICODE,'  IREADW ERROR '
D	IF (ICODE.EQ.-1) TYPE *,'READ PASS EOF'
D	IF (ICODE.EQ.-2) TYPE *,'HWD ERR ON CHAN'
D	IF (ICODE.EQ.-3) TYPE *,'CHAN NOT OPEN'
	R = 1./NUM
100	IRD = ICODE
	RETURN
	END
