C***********************************************************************
C
	PROGRAM CURKE1
C
C	PURPOSE:
C	   To transform a CURVE macro from RT-11 format back to
C	   CURVE format.
C
C	USAGE:
C	   See file CURKED.DOC
C
C	INPUT DATA:
C	   The CURVE macro in RT-11 "stream ASCII" (normal ASCII)
C	   FORMAT in file CURKE1.TMP
C	   The file CURKE1.COM that contains on its second line
C	   after the exclamation sign (!) the name of the CURVE
C	   macro file.
C
C	OUTPUT DATA:
C	   The CURVE macro in CURVE format.
C
C	METHOD:
C	   A CURVE macro consists of 82 byte records, where the first 6
C	   characters contain the number of characters (I6 format) in
C	   the corresponding CURVE macro line excluding trailing blanks.
C	   The records have been filled to 82 ch length by adding
C	   blanks.
C
C	   The transformation to CURVE format from RT-11 stream ASCII
C	   format is made simply by adding the preceding 6 character
C	   field and adding trailing blanks.
C	
C	SUBROUTINES AND FUNCTION SUBPROGRAMS USED:
C	   Various SYSLIB routines
C
C	DATE/AUTHOR:
C	   24-Sep-82	A. Virjo
C	   Central University Hospital of Tampere
C	   SF-33520 Tampere 52, Finland
C
C***********************************************************************
C
C
	LOGICAL*1 MNAME(14)		!Macro name
	LOGICAL*1 LBUF(82)		!Line buffers
	LOGICAL*1 STR(8)		!Character count string
C
	CALL ASSIGN (3,'SY0:CURKEC.COM')
	READ (3,200) (MNAME(I),I=1,14)
 200	FORMAT(/X,14A1)
	CALL CLOSE (3)
C
	CALL ASSIGN (2,'SY0:CURKED.TMP')	!Input file
	CALL ASSIGN (1,MNAME,14)	!Output file
C
 20	DO 22 I=1,82
 22	LBUF(I)=0
	READ (2,210,END=40) LN,(LBUF(I),I=1,LN)
 210	FORMAT(Q,76A1)
	IF (LN.le.76) GOTO 302
C
C   Error branch
C
301	CALL ITTOUR("007)	!Ring the bell
	WRITE (5,2003) IZ
2003	FORMAT ('0*** Error: More than 76 characters in row ',
	@i2,','/'     extra characters discarded'//)
	LN=76
C
 302 	ENCODE(6,220,STR) LN	!Form character count
 220	FORMAT(I6)
	CALL STRPAD(LBUF,76)	!Add trailing blanks
	WRITE (1,230) (STR(I),I=1,6),(LBUF(I),I=1,76)
 230	FORMAT(6A1,76A1)
	GOTO 20
C
 40	CALL CLOSE (2)
	CALL CLOSE(1)
	CALL EXIT
C
	END
