#include <stdio.h>		/* standard I/O definitions */
#include <cx.h>			/* F11ACP definitions */
#include <nboff.h>		/* Name block definitions */
#include <fdoff.h>		/* FDB definitions */

/*#define testing*/

#ifdef testing
main()
{
	fildmp(stderr,stdout);
	fildmp(stdin,stdout);
	fildmp(stdout,stdout);
	fildmp(fopen("filedmp.c","r"),stdout);
}
#endif


/* definitions for flag words */

static char *_flagt[] = {
	16,
	"_IOREAD  open for reading",
	"_IOWRT   open for write",
	"_IONBF   unbufferd 'u' mode",
	"_IOMYBUF io stuf got buffer",
	"_IOEOF   eof seen",
	"_IOERR   error seen",
	"_IOSTRG",
	"_IORW    open for read/write",
	"IO_BZY   Buffer busy",
	"IO_APN   Append mode open",
	"IO_NOS   No newlines needed",
	"IO_NEWL  RSX tty newline hack",
	"IO_FIL   Disk file",
	"IO_TTY   Console terminal",
	"IO_REC   Record device",
	"IO_OPN   Open file"
		};

static char *_wflagt[] = {
	5,
	"IO_WLD   Wildcard file",
	"IO_VM1   Version 1",
	"IO_VER   ;0 or ;-1",
	"IO_WF1   first flag",
	"IO_NLH   fopen 'n' hack bit"
		};

static char *_rtype[] = {
	3,
	1,"R_FIX    Fixed length records",
	2,"R_VAR    Variable length records",
	3,"R_SEQ    Sequenced records"
		};






/*
 *   Dump out all data about the specified file, to specified channel
 *
 */

fildmp(fptr,out)
FILE *fptr;		/* wot to dump */
FILE *out;		/* where to dump it */
{
	int a;
	int b;
	char abuf[80];
	char ac,bc;

	fprintf(out,"\14Buffer address			_: %oo\n",fptr);
	fprintf(out,"LUN  [f_lun]			_: %dd\n",((FDB *)(fptr->io_fdb))->f_lun);

	/* output file name */
	ac=((FDB *)(fptr->io_fdb))->f_fnb.n_dvnm[0];
	bc=((FDB *)(fptr->io_fdb))->f_fnb.n_dvnm[1];
	fprintf(out,"File name			_: %c%c%o:",ac,bc,((FDB *)(fptr->io_fdb))->f_fnb.n_unit);
	a=((fptr->io_uic>>8)&255);
	b=(fptr->io_uic&255);
	fprintf(out,"[%o,%o]",a,b);
	zero(abuf,80);
	r50toa(abuf,((FDB *)(fptr->io_fdb))->f_fnb.n_nfen.n_fnam,3);
	fprintf(out,"%s.",abuf);
	zero(abuf,80);
	r50toa(abuf,((FDB *)(fptr->io_fdb))->f_fnb.n_nfen.n_ftyp,1);
	fprintf(out,"%s;%o\n",abuf,((FDB *)(fptr->io_fdb))->f_fnb.n_nfen.n_fver);

	/* file I/D */
	fprintf(out,"File number			_: (%o,",((FDB *)(fptr->io_fdb))->f_fnb.n_nfen.n_fid.fid_fnum);
	fprintf(out,"%o) / ",((FDB *)(fptr->io_fdb))->f_fnb.n_nfen.n_fid.fid_fseq);
	fprintf(out,"%o[Reserved  fid_3rd]\n",((FDB *)(fptr->io_fdb))->f_fnb.n_nfen.n_fid.fid_3rd);

	/* directory I/D */
	fprintf(out,"Directory name  io_dnam 	_: %s\n",fptr->io_dnam);
	fprintf(out,"Directory file number		_: (%o,",((FDB *)(fptr->io_fdb))->f_fnb.n_did.fid_fnum);
	fprintf(out,"%o) / ",((FDB *)(fptr->io_fdb))->f_fnb.n_did.fid_fseq);
	fprintf(out,"%o[Reserved fid_3rd]\n",((FDB *)(fptr->io_fdb))->f_fnb.n_did.fid_3rd);

	fprintf(out,"File status  n_stat 		_: %oo\n",((FDB *)(fptr->io_fdb))->f_fnb.n_stat);
	fprintf(out,"Find-next tempory  n_next	_: %oo\n",((FDB *)(fptr->io_fdb))->f_fnb.n_next);

	fprintf(out,"\nBytes left in buffer  _cnt	_: %oo\n",fptr->_cnt);
	fprintf(out,"Free spot in buffer  _ptr	_: %oo\n",fptr->_ptr);
	fprintf(out,"Base of buffer  _base		_: %oo\n",fptr->_base);

	fprintf(out,"Flag word  _flag		_: %oo\n",fptr->_flag);
	flgout(out,fptr->_flag,_flagt,"\t\t\t\t   ");

	fprintf(out,"Wild card flags  io_wflag	_: %oo\n",fptr->io_wflag);
	flgout(out,fptr->io_wflag,_wflagt,"\t\t\t\t   ");

	fprintf(out,"Wild card buffer  io_wild	_: %oo\n",fptr->io_wild);
	fprintf(out,"Record buffer size  io_rbsz	_: %oo\n",fptr->io_rbsz);
	fprintf(out,"Block buffer start  io_bbuf	_: %oo\n",fptr->io_bbuf);

	fprintf(out,"\nFDB 					_: %oo\N",&(fptr->io_fdb));
	fprintf(out,"\tfile attributes\n");
	fprintf(out,"\t\tRecord type  f_rtyp			_: %oo\n",((FDB *)(fptr->io_fdb))->f_fatt.f_rtyp);
	fprintf(out,"\t\tRecord attributes  f_ratt		_: %oo\n",((FDB *)(fptr->io_fdb))->f_fatt.f_ratt);
	fprintf(out,"\t\tRecord size  f_rsiz			_: %oo\n",((FDB *)(fptr->io_fdb))->f_fatt.f_rsiz);
	fprintf(out,"\t\tHighest virtual block  f_hibk		_: %loo\n",((FDB *)(fptr->io_fdb))->f_fatt.f_hibk);
	fprintf(out,"\t\tEnd-of-file virtual block #  f_efbk	_: %loo\n",((FDB *)(fptr->io_fdb))->f_fatt.f_efbk);
	fprintf(out,"\t\tFirst free byte in last block  f_ffby	_: %oo\n",((FDB *)(fptr->io_fdb))->f_fatt.f_ffby);
	fprintf(out,"\tRecord access method  f_racc			_: %oo\n",((FDB *)(fptr->io_fdb))->f_racc);
	fprintf(out,"\tDevice characteristics  f_rctl			_: %oo\n",((FDB *)(fptr->io_fdb))->f_rctl);
	fprintf(out,"\tUser buffer description f_urbd			_: %oo\n",&((FDB *)(fptr->io_fdb))->f_urbd);
	fprintf(out,"\t\tBuffer length  bd_len			_: %oo\n",((FDB *)(fptr->io_fdb))->f_urbd.bd_len);
	fprintf(out,"\t\tBuffer address  bd_adr			_: %oo\n",((FDB *)(fptr->io_fdb))->f_urbd.bd_adr);
	fprintf(out,"\tNext record buffer description f_nrbd		_: %oo\n",&((FDB *)(fptr->io_fdb))->f_nrbd);
	fprintf(out,"\t\tBuffer length  bd_len			_: %oo\n",((FDB *)(fptr->io_fdb))->f_nrbd[0].bd_len);
	fprintf(out,"\t\tBuffer address  bd_adr			_: %oo\n",((FDB *)(fptr->io_fdb))->f_nrbd[0].bd_adr);
	fprintf(out,"\tNext record in block  f_nrec			_: %oo\n",((FDB *)(fptr->io_fdb))->f_nrec);
	fprintf(out,"\tEnd of block buffer  f_eobb			_: %oo\n",((FDB *)(fptr->io_fdb))->f_eobb);
	fprintf(out,"\tRecord number  f_rcnm				_: %loo\n",((FDB *)(fptr->io_fdb))->f_rcnm);
	fprintf(out,"\tExtension increment  f_aloc			_: %oo\n",((FDB *)(fptr->io_fdb))->f_aloc);
	fprintf(out,"\tAccess mode  f_facc				_: %oo\n",((FDB *)(fptr->io_fdb))->f_facc);
	fprintf(out,"\tAddress of dataset descriptor  f_dspt		_: %oo\n",((FDB *)(fptr->io_fdb))->f_dspt);
	fprintf(out,"\tAddress of default filename block  f_dfnb	_: %oo\n",((FDB *)(fptr->io_fdb))->f_dfnb);
	fprintf(out,"\tRecord I/O event flag  f_efn			_: %oo\n",((FDB *)(fptr->io_fdb))->f_efn);
	fprintf(out,"\tBook keeping  f_bkp1				_: %oo\n",((FDB *)(fptr->io_fdb))->f_bkp1);
	fprintf(out,"\tError code  f_err				_: %oo\n",((FDB *)(fptr->io_fdb))->f_err);
	fprintf(out,"\tDSW  f_err1					_: %oo\n",((FDB *)(fptr->io_fdb))->f_err1);
	fprintf(out,"\tNumber of buffers wanted  f_mbct		_: %oo\n",((FDB *)(fptr->io_fdb))->f_mbct);
	fprintf(out,"\tActual buffers in use  f_mbc1			_: %oo\n",((FDB *)(fptr->io_fdb))->f_mbc1);
	fprintf(out,"\tMulti-buffer flag word  f_mbfg			_: %oo\n",((FDB *)(fptr->io_fdb))->f_mbfg);
	fprintf(out,"\tBig buffer block count  f_bgbc			_: %oo\n",((FDB *)(fptr->io_fdb))->f_bgbc);
	fprintf(out,"\tVirtual block size  f_vbsz			_: %oo\n",((FDB *)(fptr->io_fdb))->f_vbsz);
	fprintf(out,"\tBlock buffer size  f_bbfs			_: %oo\n",((FDB *)(fptr->io_fdb))->f_bbfs);
	fprintf(out,"\tVirtual block number  f_vbn			_: %oo\n",((FDB *)(fptr->io_fdb))->f_vbn);
	fprintf(out,"\tBlock buffer descriptor block 			_: %oo\n",&((FDB *)(fptr->io_fdb))->f_bdb);
	fprintf(out,"\t\tBuffer length  bd_len			_: %oo\n",((FDB *)(fptr->io_fdb))->f_bdb->bd_len);
	fprintf(out,"\t\tBuffer address  bd_adr			_: %oo\n",((FDB *)(fptr->io_fdb))->f_bdb->bd_adr);
	fprintf(out,"\tACP global volume characteristics  f_chr	_: %oo\n",((FDB *)(fptr->io_fdb))->f_chr);
	fprintf(out,"\tNumber of retrieval pointers  f_actl[low]	_: %oo\n",(((FDB *)(fptr->io_fdb))->f_actl)&255);
	fprintf(out,"\tBits for user and FCS  f_actl[high]		_: %oo\n",((((FDB *)(fptr->io_fdb))->f_actl)>>8)&255);
	fprintf(out,"\tSequence number  f_seqn				_: %oo\n",((FDB *)(fptr->io_fdb))->f_seqn);
	fprintf(out,"\n\n\n");

}



flgout(out,fword,tab,pre)
FILE *out;
unsigned fword;
char **tab;
char *pre;
{
	int entry;
	int bitm;
	int bitcnt;

	bitm=1;
	bitcnt=(int)(*tab++);

	for (entry=0 ; entry<16 ; entry++) {
		if ( fword & bitm ) {
			if (entry>=bitcnt) {
				fprintf(out,"%s\? bit %oo\n",pre,entry);
			} else {
				fprintf(out,"%s%s\n",pre,*(tab+entry));
			}
		}
		bitm = bitm << 1;
	};
}

