/*
 *			w a l k . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	walk	Walk over next whitespace
index		walk over next Whitespace

synopsis

	int
	walk(cpp)
	 char **cpp;	/* string pointer pointer */

description

	Function to move past next whitespace encountered (if any)
	and return position of next nonwhite character. The current
	position is in the whitespace, with at least one whitespace
	character - which may be the character currently pointed
	to - before the next data.

	Return ERROR if a \0 or \n is encountered instead, as the
	field expected may be an optional field. Return NOERROR
	otherwise.

bugs

author

	Machiavelli Systems

#endif

#include "symbols.h"


int	walk(cpp)

char	**cpp;
{
int	retval;

 while  (((retval = (((**cpp == '\0') || (**cpp == '\n')) ? ERROR : NOERROR)) != ERROR) && iswhite(**cpp))  (*cpp)++;
				/*   stop at a nonwhite or '\n'  */

				/*   the above mouthful should have
				     decided if we have encountered
				     end-of-line or end-of-string, in
				     which case retval will be ERROR   */
return(retval);
}				  
