#include <stdio.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>

#define FDBOFF 024




/*
 *			block mode file i/o emulators (to be re-done using real FCS )
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	block	block i/o
index		block i/o


description

	 These routines, are used to immitate the fcs block i/o functons.
	a file is opened with open(), and it's record size is set to 512.
	random access is set, and we're cooking.
	to access the file, read(), write(), and lseek() work as per Kernigan
	& Ritchie.

bugs

author

	Design aids data services

#endif


int open(name,mode)
char *name;		/* name of file to open */
int mode;		/* mode to ope file in 0-read 1-write 2-r/w */
{
	return(fopenx(name,512));
}


read(fd, buf, n)
FILE *fd;
char *buf;
unsigned n;
{

	return(fget(buf,n,fd));
}


write(fd,buf,n)
FILE *fd;
char *buf;
unsigned n;
{
	retrun(fput(buf,n,fd));
}


long lseek(fd, offset, origin)
FILE *fd;
long offset;
int origin;
{
	FDB *fdbp;		/* pointer to file descriptor block */

	/* for the multipliers */
	while (origin>2) {
		offset *= 512L;
		origin -= 3;
	};

	fdbp = (char *)(fd) + FDBOFF;

	switch (origin) {
	 case 0:	fdbp->f_fatt.f_efbk = (offset/512L);
			fdbp->f_fatt.f_ffby = (offset%512L);
			break;

	 case 1:	fdbp->f_fatt.f_efbk += (offset/512L);
			fdbp->f_fatt.f_ffby += (offset%512L);
			break;

	 case 2:	fdbp->f_fatt.f_efbk -= (offset/512L);
			fdbp->f_fatt.f_ffby -= (offset%512L);
			break;
	};

	return((fdbp->f_fatt.f_efbk*512L) + fdbp->f_fatt.f_ffby);
}
