/*
 *			GETWORD.C
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	getword	Copy current word in source to dest string
index		Copy Current Word in Source to Dest String

SYNOPSIS:

	char *getword(dest,source)
	 char *source;			/* the string to get the word from */
	 char *dest;			/* where to put the word */

DESCRIPTION:

	Copys source to dest from the current word to the end of the
	current word.
	Returns a pointer to the next word in the string,
	or 0 for at end of string or null-string.
		
BUGS:

AUTHOR:

		Machiavelli Data Systems

#endif

#ifdef testing

#include <gcl.h>

main()
{
	char *lin;
	char word[100];
	char *getword();

	lin=gcl("\n\rGETWORD >");
	while(!GCLEOF) {
		while(lin=getword(word,lin)) {
			printf("word<%s> lin[%oo]<%s>\n",word,lin,lin);
		}
		lin=gcl("\n\rGETWORD >");
	}
}

#endif

char *getword(dest,source)
char *dest;
char *source;
{
	/* Check to see if a string exists */
	if ((!source) || (!*source))
		return(0);

	/* Copy source to dest until next white space */
	while((!iswhite(*source)) && (*source))
		*(dest++) = *(source++);

	/* NULL-terminate dest */
	*dest=0;

	/* Point source at next word */
	while((iswhite(*source)) && (*source))
		source++;

	/* Return a pointer to the word */
	return(source);
}
