
/*
 *			g e t n e x t . c
 */

/*)library
*/

#ifdef	documentation

title	getnex	get next data item after white space
index		get next data item after white space

synopsis

	int
	getnext(ccp,dest)
	 char **ccp;
	 char *dest;

description

	getnext() is a composite function call made from within leading
	whitespace to find the next data item and transfer it to the
	required buffer, dest.
	a pointer to where the data was taken from, is returned.
	 eg: ccp -> * -> <     there>
	 after:
	     ccp -> * -> <there>
	     dest -> <there>

bugs

author

	machiavelli systems

#endif




getnext(ccp, dest)
char **ccp;		/* pointer to source pointer */
char *dest;		/* destination string */
{
	int retval;	/* wot gets returned */

	retval = walk(ccp);	/* walk over next whitespace */

	getqtext(ccp, dest);	/* get the data */

	return (retval);	/* return a pointer to the source data item */
}

