/*
 *			f i e l d p t . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	fieldp	Format Data Into Buffer
index		Format Data Into Buffer

synopsis

	char *
	fieldpt(destr, typ, wid, jst, fltfmt, left, right, sour)
	 char *destr;           /* append output to here */
	 char typ;              /* the data type */
	 int wid;		/* field width */
	 char jst;		/* justification */
	 char *fltfmt;		/* floating point format */
	 char *left;		/* left string */
	 char *right;		/* right string */
	 type *sour;		/* pointer to the data to be formatted */

description

	fieldpt() formats data to the users specifications :
	 a) field size : wid is the total width of the field
	 b) type is the data type { I F $ }
	 c) just is the justification { L C R }
	 d) fltfmt is the format for a float number (pointer to a null if
	not being used. format : Ftot.dec
	 e) left is a string to be appended to the left of the data
	 f) right is a string to be appended to the right of the data
	 g) sour is where the data is to come from (pointer)

	Returns a pointer to the end of destr.

bugs

author

	Machiavelli Systems

#endif





#include "symbols.h"

fieldpt(destr, typ, wid, jst, fltfmt, left, right, sour)      /* print field to a string */

char		*destr;                 /* append output to here */
char		typ;                    /* the data type { L I F $ } */
int		wid;			/* field width */
char		jst;			/* justification { L C R } */
char		*fltfmt;		/* floating point format { F<tot>.<right> } */
char		*left;			/* left string */
char		*right;			/* right string */
union __f2 {
	char	*strdat;
	int	*intdat;
	double	*doudat;
#ifdef longs
	long	*lngdat;
#endif
	    }   sour;			/* the source data field */
{
char            fieldbuf[100];		/* a big field */
char	        f[20];			/* a 'c' flavored format string */
char            cp[80];                 /* string buffer */
int             pad;                    /* number of spaces to pad buffer with */
unsigned        pad1;                   /* half pad */
unsigned        pad2;                   /* half pad */
char	        pad1str[40];		/* pading strings */
char	        pad2str[40];
int		len;			/* length os string var. */
char		*cpystr();		/* explicit declaration of cpystr */
char		*c_ptr;			/* pointer to end of destination string */


*fieldbuf = ENDSTRING;	/* initialise */

strcat(fieldbuf, left);

switch (typ)
        {
#ifdef longs
 case 'L':
	ltoa(*sour.lngdat,cp);		/* make the long into a char */
	break;
#endif
 case 'I':
        itoa(*sour.intdat,cp);		/* make the int into a char */
        break;
 case 'F':
	skpalf(&fltfmt);
	*f=0;
	aggreg(f, 3, "%", fltfmt, "lf");
	sprintf(cp, f, *sour.doudat);
        break;
 case '$':
	strcpy(cp, sour.strdat);         /* string is in record buffer */
        break;
 default:
        error("\7typ=%c\nUnrecognised type\n",typ);
        };
strcat (fieldbuf, cp);
	
strcat(fieldbuf, right);

len = strlen(fieldbuf);
pad = wid - len;

c_ptr = destr+strlen(destr);

if  (pad < 0)
        { 
	if (typ == '$')		/* right truncate */
               {
                fieldbuf[wid] = ENDSTRING;
                };
         c_ptr = cpystr(c_ptr, fieldbuf);	/* didn't hurt a bit */
        }
 else					/* some padding to do */
        {
         pad1 = pad / 2;
         pad2 = pad - pad1;		/* pad1 + pad2 == pad */

	 *pad1str = ENDSTRING;
	 *pad2str = ENDSTRING;
	 while (pad1--)
		strcat(pad1str, " ");
	 while (pad2--)
		strcat(pad2str, " ");

         switch (jst)
                {
	 case 'L':
/*			printf("Left justifying\n");	*/
			c_ptr = cpystr(c_ptr, fieldbuf);
			c_ptr = cpystr(c_ptr, pad1str);
			c_ptr = cpystr(c_ptr, pad2str);
			break;
         case 'C':
/*			printf("Centerizing\n");	*/
			c_ptr = cpystr(c_ptr, pad1str);
			c_ptr = cpystr(c_ptr, fieldbuf);
			c_ptr = cpystr(c_ptr, pad2str);
	                break;
         case 'R':
/*			printf("Right justifying\n");	*/
			c_ptr = cpystr(c_ptr, pad1str);
			c_ptr = cpystr(c_ptr, pad2str);
			c_ptr = cpystr(c_ptr, fieldbuf);
			break;
                };
        };

	return(c_ptr);
}
