#define testing
/*
 *			DO_CMD
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	docmd	Do command
index		Do Command

SYNOPSIS:

	int do_cmd (cmd, table)
	 char *cmd		 /* command to be done */
	 cmdlist table[]	 /* table containing the list of commands */

DESCRIPTION:

	This routine receives a command line with which it seperates
	the command from the line if applicable.
 	Returns	-1	if the command line doesnt contain a command
 			if the command is not in the list
	or the command number if all goes well.
	The function associated with the key is called, with the rest of
	the line passed as the first argument.
	If a zero is present in the command list in place of the function
	name, the function number is returned with the function not 
	being despatched.

	Cmdlist is of the format :
	 typedef struct {
	  char *cmd;		/* Command string to be looked for */
	  int (*function)();	/* Function associated with command key */
	 } cmdlist;

	To create the table use :
	 cmdlist table[] = {
		"KEY1",&funct1,
		"KEY2",&funct2,
		.     .     .
		0 };

 	Program must include cmddisp.h to define the table type

BUGS:

AUTHOR:

		Machiavelli Data Systems

#endif



#include <cmddisp.h>


#ifdef testing

#include <gcl.h>

static cmdlist cmdtab[] = {
	"PRINT",&puts,
	"ONE",&puts,		/* Table containing valid commands */
	"TWO",&puts,
	"THREE",&puts,
	0 };

extern int *gcl();
int *x;


main()
{
	/* this main tests the do_cmd() module */

	char *lin;

	x=gcl;
	x += 075;
	lin=gcl("\n\rdo_cmd>");

	while(!GCLEOF) {
		printf("do_cmd result : %d\n",do_cmd(lin,cmdtab));
		lin=gcl("\n\rdo_cmd>");
	}
}


#endif


int do_cmd (cmd, table)
char *cmd;		/* command line to be done */
cmdlist table[];	/* list of known commands */
{
	int i;			/* loop variable */
        char *command[50];	/* command from cmd */
	char *line;		/* command line */
	char *getword();

	/* remove command from cmd */
	if (!(line = getword(command, cmd)))
		return(-1);

	/* Look for the keyword in the list */
	for (i=0 ; ((table[i].cmd) && (instr(table[i].cmd,toupps(command)))) ; i++);
	
	if(!(table[i].cmd))
		return(-1);
	
	/* Do command if there's a proceedure to execute */
	if (table[i].function)
		(*table[i].function)(line);
	
	/* Return function number */
	return (i);
}
